/*
 * Decompiled with CFR 0.152.
 */
package com.doodle.android.chips.views;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import com.doodle.android.chips.ChipsView;
import java.util.ArrayList;
import java.util.List;

public class ChipsVerticalLinearLayout
extends LinearLayout {
    private List<LinearLayout> mLineLayouts = new ArrayList<LinearLayout>();
    private float mDensity;
    private int mRowSpacing;

    public ChipsVerticalLinearLayout(Context context, int rowSpacing) {
        super(context);
        this.mDensity = this.getResources().getDisplayMetrics().density;
        this.mRowSpacing = rowSpacing;
        this.init();
    }

    private void init() {
        this.setOrientation(1);
    }

    public TextLineParams onChipsChanged(List<ChipsView.Chip> chips) {
        this.clearChipsViews();
        int width = this.getWidth();
        if (width == 0) {
            return null;
        }
        int widthSum = 0;
        int chipsCount = 0;
        int rowCounter = 0;
        LinearLayout ll = this.createHorizontalView();
        for (ChipsView.Chip chip : chips) {
            View view = chip.getView();
            view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            if (widthSum + view.getMeasuredWidth() > width) {
                ++rowCounter;
                widthSum = 0;
                chipsCount = 0;
                ll = this.createHorizontalView();
            }
            widthSum += view.getMeasuredWidth();
            ++chipsCount;
            ll.addView(view);
        }
        if ((float)(width - widthSum) < (float)width * 0.1f) {
            widthSum = 0;
            chipsCount = 0;
            ++rowCounter;
        }
        if (width == 0) {
            rowCounter = 0;
        }
        return new TextLineParams(rowCounter, widthSum, chipsCount);
    }

    private LinearLayout createHorizontalView() {
        LinearLayout ll = new LinearLayout(this.getContext());
        ll.setPadding(0, 0, 0, this.mRowSpacing);
        ll.setOrientation(0);
        this.addView((View)ll);
        this.mLineLayouts.add(ll);
        return ll;
    }

    private void clearChipsViews() {
        for (LinearLayout linearLayout : this.mLineLayouts) {
            linearLayout.removeAllViews();
        }
        this.mLineLayouts.clear();
        this.removeAllViews();
    }

    public static class TextLineParams {
        public int row;
        public int lineMargin;
        public int chipsCount = 0;

        public TextLineParams(int row, int lineMargin, int chipsCount) {
            this.row = row;
            this.lineMargin = lineMargin;
            this.chipsCount = chipsCount;
        }
    }
}

