/*
 * Decompiled with CFR 0.152.
 */
package com.doodle.android.chips;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.LeadingMarginSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.doodle.android.chips.R;
import com.doodle.android.chips.model.Contact;
import com.doodle.android.chips.util.Common;
import com.doodle.android.chips.views.ChipsEditText;
import com.doodle.android.chips.views.ChipsVerticalLinearLayout;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChipsView
extends ScrollView
implements ChipsEditText.InputConnectionWrapperInterface {
    private static final String TAG = "ChipsView";
    private static final int CHIP_HEIGHT = 32;
    private static final int SPACING_TOP = 4;
    private static final int SPACING_BOTTOM = 4;
    public static final int DEFAULT_VERTICAL_SPACING = 1;
    private static final int DEFAULT_MAX_HEIGHT = -1;
    private int mChipsBgRes = R.drawable.chip_background;
    private int mMaxHeight;
    private int mVerticalSpacing;
    private int mChipsColor;
    private int mChipsColorClicked;
    private int mChipsColorErrorClicked;
    private int mChipsBgColor;
    private int mChipsBgColorIndelible;
    private int mChipsBgColorClicked;
    private int mChipsBgColorErrorClicked;
    private int mChipsTextColor;
    private int mChipsTextColorIndelible;
    private int mChipsTextColorClicked;
    private int mChipsTextColorErrorClicked;
    private int mChipsPlaceholderResId;
    @ColorInt
    private int mChipsPlaceholderTint;
    private int mChipsDeleteResId;
    private String mChipsHintText;
    private int mChipsMargin;
    private float mDensity;
    private RelativeLayout mChipsContainer;
    private ChipsListener mChipsListener;
    private ChipsEditText mEditText;
    private ChipsVerticalLinearLayout mRootChipsLayout;
    private EditTextListener mEditTextListener;
    private List<Chip> mChipList = new ArrayList<Chip>();
    private Object mCurrentEditTextSpan;
    private ChipValidator mChipsValidator;
    private Typeface mTypeface;
    private boolean mUseInitials = false;
    private int mInitialsTextSize;
    private Typeface mInitialsTypeface;
    @ColorInt
    private int mInitialsTextColor;

    public ChipsView(Context context) {
        super(context);
        this.init();
    }

    public ChipsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(context, attrs);
        this.init();
    }

    public ChipsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(context, attrs);
        this.init();
    }

    @TargetApi(value=21)
    public ChipsView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttr(context, attrs);
        this.init();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mMaxHeight != -1) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxHeight, (int)Integer.MIN_VALUE);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttr(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ChipsView, 0, 0);
        try {
            this.mMaxHeight = a.getDimensionPixelSize(R.styleable.ChipsView_cv_max_height, -1);
            this.mVerticalSpacing = a.getDimensionPixelSize(R.styleable.ChipsView_cv_vertical_spacing, (int)(1.0f * this.mDensity));
            this.mChipsColor = a.getColor(R.styleable.ChipsView_cv_color, ContextCompat.getColor((Context)context, (int)R.color.base30));
            this.mChipsColorClicked = a.getColor(R.styleable.ChipsView_cv_color_clicked, ContextCompat.getColor((Context)context, (int)R.color.colorPrimaryDark));
            this.mChipsColorErrorClicked = a.getColor(R.styleable.ChipsView_cv_color_error_clicked, ContextCompat.getColor((Context)context, (int)R.color.color_error));
            this.mChipsBgColor = a.getColor(R.styleable.ChipsView_cv_bg_color, ContextCompat.getColor((Context)context, (int)R.color.base10));
            this.mChipsBgColorClicked = a.getColor(R.styleable.ChipsView_cv_bg_color_clicked, ContextCompat.getColor((Context)context, (int)R.color.blue));
            this.mChipsBgColorIndelible = a.getColor(R.styleable.ChipsView_cv_bg_color_indelible, this.mChipsBgColor);
            this.mChipsBgColorErrorClicked = a.getColor(R.styleable.ChipsView_cv_bg_color_clicked, ContextCompat.getColor((Context)context, (int)R.color.color_error));
            this.mChipsTextColor = a.getColor(R.styleable.ChipsView_cv_text_color, -16777216);
            this.mChipsTextColorClicked = a.getColor(R.styleable.ChipsView_cv_text_color_clicked, -1);
            this.mChipsTextColorErrorClicked = a.getColor(R.styleable.ChipsView_cv_text_color_clicked, -1);
            this.mChipsTextColorIndelible = a.getColor(R.styleable.ChipsView_cv_text_color_indelible, this.mChipsTextColor);
            this.mChipsPlaceholderResId = a.getResourceId(R.styleable.ChipsView_cv_icon_placeholder, R.drawable.ic_person_24dp);
            this.mChipsPlaceholderTint = a.getColor(R.styleable.ChipsView_cv_icon_placeholder_tint, 0);
            this.mChipsDeleteResId = a.getResourceId(R.styleable.ChipsView_cv_icon_delete, R.drawable.ic_close_24dp);
            this.mChipsHintText = a.getString(R.styleable.ChipsView_cv_text_hint);
            this.mChipsMargin = a.getDimensionPixelSize(R.styleable.ChipsView_cv_chips_margin, 0);
        }
        finally {
            a.recycle();
        }
    }

    private void init() {
        this.mDensity = this.getResources().getDisplayMetrics().density;
        this.mChipsContainer = new RelativeLayout(this.getContext());
        this.addView((View)this.mChipsContainer);
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(0, 0);
        linearLayout.setLayoutParams(params);
        linearLayout.setFocusable(true);
        linearLayout.setFocusableInTouchMode(true);
        this.mChipsContainer.addView((View)linearLayout);
        this.mEditText = new ChipsEditText(this.getContext(), this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.topMargin = (int)(4.0f * this.mDensity);
        layoutParams.bottomMargin = (int)(4.0f * this.mDensity) + this.mVerticalSpacing;
        this.mEditText.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mEditText.setMinHeight((int)(32.0f * this.mDensity));
        this.mEditText.setPadding(0, 0, 0, 0);
        this.mEditText.setLineSpacing(this.mVerticalSpacing, 32.0f * this.mDensity / (float)this.mEditText.getLineHeight());
        this.mEditText.setBackgroundColor(Color.argb((int)0, (int)0, (int)0, (int)0));
        this.mEditText.setImeOptions(0x10000000);
        this.mEditText.setInputType(131105);
        this.mEditText.setHint(this.mChipsHintText);
        this.mChipsContainer.addView((View)this.mEditText);
        this.mRootChipsLayout = new ChipsVerticalLinearLayout(this.getContext(), this.mVerticalSpacing);
        this.mRootChipsLayout.setOrientation(1);
        this.mRootChipsLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.mRootChipsLayout.setPadding(0, (int)(4.0f * this.mDensity), 0, 0);
        this.mChipsContainer.addView((View)this.mRootChipsLayout);
        this.initListener();
        if (this.isInEditMode()) {
            LinearLayout editModeLinLayout = new LinearLayout(this.getContext());
            editModeLinLayout.setOrientation(0);
            this.mChipsContainer.addView((View)editModeLinLayout);
            View view = new Chip("Test Chip", null, new Contact(null, null, "Test", "asd@asd.de", null)).getView();
            view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            editModeLinLayout.addView(view);
            View view2 = new Chip("Indelible", null, new Contact(null, null, "Test", "asd@asd.de", null), true).getView();
            view2.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            editModeLinLayout.addView(view2);
        }
    }

    private void initListener() {
        this.mChipsContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChipsView.this.mEditText.requestFocus();
                ChipsView.this.unselectAllChips();
            }
        });
        this.mEditTextListener = new EditTextListener();
        this.mEditText.addTextChangedListener(this.mEditTextListener);
        this.mEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    ChipsView.this.unselectAllChips();
                }
            }
        });
    }

    public void addChip(String displayName, String avatarUrl, Contact contact) {
        this.addChip(displayName, Uri.parse((String)avatarUrl), contact);
    }

    public void addChip(String displayName, Uri avatarUrl, Contact contact) {
        this.addChip(displayName, avatarUrl, contact, false);
        this.mEditText.setText("");
        this.addLeadingMarginSpan();
    }

    public void addChip(String displayName, Uri avatarUrl, Contact contact, boolean isIndelible) {
        Chip chip = new Chip(displayName, avatarUrl, contact, isIndelible);
        this.mChipList.add(chip);
        if (this.mChipsListener != null) {
            this.mChipsListener.onChipAdded(chip);
        }
        this.mEditText.setHint(null);
        this.onChipsChanged(true);
        this.post(new Runnable(){

            @Override
            public void run() {
                ChipsView.this.fullScroll(130);
            }
        });
    }

    public void setTypeface(@NonNull Typeface typeface) {
        this.mTypeface = typeface;
        if (this.mEditText != null) {
            this.mEditText.setTypeface(this.mTypeface);
        }
    }

    public void useInitials(int textSize, @Nullable Typeface initialsTypeface, @ColorInt int textColor) {
        this.mUseInitials = true;
        this.mInitialsTextSize = textSize;
        this.mInitialsTypeface = initialsTypeface;
        this.mInitialsTextColor = textColor;
    }

    public void clearText() {
        this.mEditText.setText("");
        this.onChipsChanged(true);
    }

    @NonNull
    public List<Chip> getChips() {
        return Collections.unmodifiableList(this.mChipList);
    }

    public boolean removeChipBy(Contact contact) {
        for (int i = 0; i < this.mChipList.size(); ++i) {
            if (this.mChipList.get(i).mContact == null || !this.mChipList.get(i).mContact.equals(contact)) continue;
            this.mChipList.remove(i);
            if (this.mChipList.isEmpty()) {
                this.mEditText.setHint(this.mChipsHintText);
            }
            this.onChipsChanged(true);
            return true;
        }
        return false;
    }

    public Contact tryToRecognizeAddress() {
        String text = this.mEditText.getText().toString();
        if (!TextUtils.isEmpty((CharSequence)text) && Common.isValidEmail(text)) {
            return new Contact(text, "", null, text, null);
        }
        return null;
    }

    public void setChipsListener(ChipsListener chipsListener) {
        this.mChipsListener = chipsListener;
    }

    public void setChipsValidator(ChipValidator chipsValidator) {
        this.mChipsValidator = chipsValidator;
    }

    public EditText getEditText() {
        return this.mEditText;
    }

    private void onChipsChanged(final boolean moveCursor) {
        ChipsVerticalLinearLayout.TextLineParams textLineParams = this.mRootChipsLayout.onChipsChanged(this.mChipList);
        if (textLineParams == null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ChipsView.this.onChipsChanged(moveCursor);
                }
            });
            return;
        }
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mEditText.getLayoutParams();
        params.topMargin = (int)((float)(4 + textLineParams.row * 32) * this.mDensity) + textLineParams.row * this.mVerticalSpacing;
        this.mEditText.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addLeadingMarginSpan(textLineParams.lineMargin + this.mChipsMargin * textLineParams.chipsCount);
        if (moveCursor) {
            this.mEditText.setSelection(this.mEditText.length());
        }
    }

    private void addLeadingMarginSpan(int margin) {
        Editable spannable = this.mEditText.getText();
        if (this.mCurrentEditTextSpan != null) {
            spannable.removeSpan(this.mCurrentEditTextSpan);
        }
        this.mCurrentEditTextSpan = new LeadingMarginSpan.Standard(margin, 0);
        spannable.setSpan(this.mCurrentEditTextSpan, 0, 0, 17);
        this.mEditText.setText((CharSequence)spannable);
    }

    private void addLeadingMarginSpan() {
        Editable spannable = this.mEditText.getText();
        if (this.mCurrentEditTextSpan != null) {
            spannable.removeSpan(this.mCurrentEditTextSpan);
        }
        spannable.setSpan(this.mCurrentEditTextSpan, 0, 0, 17);
        this.mEditText.setText((CharSequence)spannable);
    }

    private boolean onEnterPressed(String text) {
        boolean shouldDeleteText = true;
        if (text != null && text.length() > 0) {
            if (Common.isValidEmail(text)) {
                this.onEmailRecognized(text);
            } else {
                shouldDeleteText = this.onNonEmailRecognized(text);
            }
            if (shouldDeleteText) {
                this.mEditText.setSelection(0);
            }
        }
        return shouldDeleteText;
    }

    private void onEmailRecognized(String email) {
        this.onEmailRecognized(new Contact(email, "", null, email, null));
    }

    private void onEmailRecognized(Contact contact) {
        Chip chip = new Chip(contact.getDisplayName(), null, contact);
        this.mChipList.add(chip);
        if (this.mChipsListener != null) {
            this.mChipsListener.onChipAdded(chip);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                ChipsView.this.onChipsChanged(true);
            }
        });
    }

    private boolean onNonEmailRecognized(String text) {
        if (this.mChipsListener != null) {
            return this.mChipsListener.onInputNotRecognized(text);
        }
        return true;
    }

    private void selectOrDeleteLastChip() {
        if (this.mChipList.size() > 0) {
            this.onChipInteraction(this.mChipList.size() - 1);
        }
    }

    private void onChipInteraction(int position) {
        try {
            Chip chip = this.mChipList.get(position);
            if (chip != null) {
                this.onChipInteraction(chip, true);
            }
        }
        catch (IndexOutOfBoundsException e) {
            Log.e((String)TAG, (String)"Out of bounds", (Throwable)e);
        }
    }

    private void onChipInteraction(Chip chip, boolean nameClicked) {
        this.unselectChipsExcept(chip);
        if (chip.isSelected()) {
            this.mChipList.remove(chip);
            if (this.mChipsListener != null) {
                this.mChipsListener.onChipDeleted(chip);
            }
            this.onChipsChanged(true);
            if (nameClicked) {
                this.mEditText.setText(chip.getContact().getEmailAddress());
                this.addLeadingMarginSpan();
                this.mEditText.requestFocus();
                this.mEditText.setSelection(this.mEditText.length());
            }
        } else {
            chip.setSelected(true);
            this.onChipsChanged(false);
        }
    }

    private void unselectChipsExcept(Chip rootChip) {
        for (Chip chip : this.mChipList) {
            if (chip == rootChip) continue;
            chip.setSelected(false);
        }
        this.onChipsChanged(false);
    }

    private void unselectAllChips() {
        this.unselectChipsExcept(null);
    }

    @Override
    public InputConnection getInputConnection(InputConnection target) {
        return new KeyInterceptingInputConnection(target);
    }

    public static abstract class ChipValidator {
        public abstract boolean isValid(Contact var1);
    }

    public static interface ChipsListener {
        public void onChipAdded(Chip var1);

        public void onChipDeleted(Chip var1);

        public void onTextChanged(CharSequence var1);

        public boolean onInputNotRecognized(String var1);
    }

    public class Chip
    implements View.OnClickListener {
        private static final int MAX_LABEL_LENGTH = 30;
        private String mLabel;
        private final Uri mPhotoUri;
        private final Contact mContact;
        private final boolean mIsIndelible;
        private RelativeLayout mView;
        private View mIconWrapper;
        private TextView mTextView;
        private TextView mInitials;
        private ImageView mAvatarView;
        private ImageView mPersonIcon;
        private ImageView mCloseIcon;
        private ImageView mErrorIcon;
        private boolean mIsSelected = false;

        public Chip(String label, Uri photoUri, Contact contact) {
            this(label, photoUri, contact, false);
        }

        public Chip(String label, Uri photoUri, Contact contact, boolean isIndelible) {
            this.mLabel = label;
            this.mPhotoUri = photoUri;
            this.mContact = contact;
            this.mIsIndelible = isIndelible;
            if (this.mLabel == null) {
                this.mLabel = contact.getEmailAddress();
            }
            if (this.mLabel.length() > 30) {
                this.mLabel = this.mLabel.substring(0, 30) + "...";
            }
        }

        public View getView() {
            if (this.mView == null) {
                this.mView = (RelativeLayout)View.inflate((Context)ChipsView.this.getContext(), (int)R.layout.chips_view, null);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, (int)(32.0f * ChipsView.this.mDensity));
                layoutParams.setMargins(0, 0, ChipsView.this.mChipsMargin, 0);
                this.mView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                this.mAvatarView = (ImageView)this.mView.findViewById(R.id.ri_ch_avatar);
                this.mIconWrapper = this.mView.findViewById(R.id.rl_ch_avatar);
                this.mTextView = (TextView)this.mView.findViewById(R.id.tv_ch_name);
                this.mInitials = (TextView)this.mView.findViewById(R.id.tv_ch_initials);
                this.mPersonIcon = (ImageView)this.mView.findViewById(R.id.iv_ch_person);
                this.mCloseIcon = (ImageView)this.mView.findViewById(R.id.iv_ch_close);
                this.mErrorIcon = (ImageView)this.mView.findViewById(R.id.iv_ch_error);
                if (ChipsView.this.mTypeface != null) {
                    this.mTextView.setTypeface(ChipsView.this.mTypeface);
                }
                this.mView.setBackgroundResource(ChipsView.this.mChipsBgRes);
                if (this.mIsIndelible) {
                    ((GradientDrawable)this.mView.getBackground()).setColor(ChipsView.this.mChipsBgColorIndelible);
                } else {
                    ((GradientDrawable)this.mView.getBackground()).setColor(ChipsView.this.mChipsBgColor);
                }
                this.mIconWrapper.setBackgroundResource(R.drawable.circle);
                if (this.mIsIndelible) {
                    this.mTextView.setTextColor(ChipsView.this.mChipsTextColorIndelible);
                } else {
                    this.mTextView.setTextColor(ChipsView.this.mChipsTextColor);
                }
                this.mPersonIcon.setImageResource(ChipsView.this.mChipsPlaceholderResId);
                if (ChipsView.this.mChipsPlaceholderTint != 0) {
                    this.mPersonIcon.setColorFilter(ChipsView.this.mChipsPlaceholderTint, PorterDuff.Mode.SRC_ATOP);
                }
                this.mCloseIcon.setBackgroundResource(ChipsView.this.mChipsDeleteResId);
                if (ChipsView.this.mUseInitials) {
                    this.mPersonIcon.setVisibility(8);
                    this.mInitials.setVisibility(0);
                    if (ChipsView.this.mInitialsTypeface != null) {
                        this.mInitials.setTypeface(ChipsView.this.mInitialsTypeface);
                    }
                    if (ChipsView.this.mInitialsTextColor != 0) {
                        this.mInitials.setTextColor(ChipsView.this.mInitialsTextColor);
                    }
                    if (ChipsView.this.mInitialsTextSize != 0) {
                        this.mInitials.setTextSize(2, (float)ChipsView.this.mInitialsTextSize);
                    }
                } else {
                    this.mPersonIcon.setVisibility(0);
                    this.mInitials.setVisibility(8);
                }
                this.mView.setOnClickListener((View.OnClickListener)this);
                this.mIconWrapper.setOnClickListener((View.OnClickListener)this);
            }
            this.updateViews();
            return this.mView;
        }

        private void updateViews() {
            this.mTextView.setText((CharSequence)this.mLabel);
            if (ChipsView.this.mUseInitials) {
                this.mInitials.setText((CharSequence)this.getInitials());
            }
            if (ChipsView.this.mTypeface != null) {
                this.mTextView.setTypeface(ChipsView.this.mTypeface);
            }
            if (this.mPhotoUri != null) {
                Picasso.with((Context)ChipsView.this.getContext()).load(this.mPhotoUri).noPlaceholder().into(this.mAvatarView, new Callback(){

                    public void onSuccess() {
                        Chip.this.mPersonIcon.setVisibility(4);
                    }

                    public void onError() {
                    }
                });
            }
            if (this.isSelected()) {
                if (ChipsView.this.mChipsValidator != null && !ChipsView.this.mChipsValidator.isValid(this.mContact)) {
                    ((GradientDrawable)this.mView.getBackground()).setColor(ChipsView.this.mChipsBgColorErrorClicked);
                    this.mTextView.setTextColor(ChipsView.this.mChipsTextColorErrorClicked);
                    this.mIconWrapper.getBackground().setColorFilter(ChipsView.this.mChipsColorErrorClicked, PorterDuff.Mode.SRC_ATOP);
                    this.mErrorIcon.setColorFilter(-1, PorterDuff.Mode.SRC_ATOP);
                } else {
                    ((GradientDrawable)this.mView.getBackground()).setColor(ChipsView.this.mChipsBgColorClicked);
                    this.mTextView.setTextColor(ChipsView.this.mChipsTextColorClicked);
                    this.mIconWrapper.getBackground().setColorFilter(ChipsView.this.mChipsColorClicked, PorterDuff.Mode.SRC_ATOP);
                }
                if (ChipsView.this.mUseInitials) {
                    this.mInitials.animate().alpha(0.0f).setDuration(200L).start();
                } else {
                    this.mPersonIcon.animate().alpha(0.0f).setDuration(200L).start();
                }
                this.mAvatarView.animate().alpha(0.0f).setDuration(200L).start();
                this.mCloseIcon.animate().alpha(1.0f).setDuration(200L).setStartDelay(100L).start();
            } else {
                if (ChipsView.this.mChipsValidator != null && !ChipsView.this.mChipsValidator.isValid(this.mContact)) {
                    this.mErrorIcon.setVisibility(0);
                    this.mErrorIcon.setColorFilter(null);
                } else {
                    this.mErrorIcon.setVisibility(8);
                }
                if (this.mIsIndelible) {
                    ((GradientDrawable)this.mView.getBackground()).setColor(ChipsView.this.mChipsBgColorIndelible);
                    this.mTextView.setTextColor(ChipsView.this.mChipsTextColorIndelible);
                } else {
                    ((GradientDrawable)this.mView.getBackground()).setColor(ChipsView.this.mChipsBgColor);
                    this.mTextView.setTextColor(ChipsView.this.mChipsTextColor);
                }
                this.mIconWrapper.getBackground().setColorFilter(ChipsView.this.mChipsColor, PorterDuff.Mode.SRC_ATOP);
                if (ChipsView.this.mUseInitials) {
                    this.mInitials.animate().alpha(1.0f).setDuration(200L).setStartDelay(100L).start();
                } else {
                    this.mPersonIcon.animate().alpha(1.0f).setDuration(200L).setStartDelay(100L).start();
                }
                this.mAvatarView.animate().alpha(1.0f).setDuration(200L).setStartDelay(100L).start();
                this.mCloseIcon.animate().alpha(0.0f).setDuration(200L).start();
            }
        }

        @NonNull
        private String getInitials() {
            if (this.mLabel != null) {
                if (this.mLabel.trim().contains(" ")) {
                    String[] split = this.mLabel.trim().split(" ");
                    return String.format("%s%s", String.valueOf(split[0].charAt(0)), String.valueOf(split[split.length - 1].charAt(0)));
                }
                return String.valueOf(this.mLabel.charAt(0));
            }
            return "";
        }

        public void onClick(View v) {
            ChipsView.this.mEditText.clearFocus();
            if (v.getId() == this.mView.getId()) {
                ChipsView.this.onChipInteraction(this, true);
            } else {
                ChipsView.this.onChipInteraction(this, false);
            }
        }

        public boolean isSelected() {
            return this.mIsSelected;
        }

        public void setSelected(boolean isSelected) {
            if (this.mIsIndelible) {
                return;
            }
            this.mIsSelected = isSelected;
        }

        public Contact getContact() {
            return this.mContact;
        }

        public boolean equals(Object o) {
            if (this.mContact != null && o instanceof Contact) {
                return this.mContact.equals(o);
            }
            return super.equals(o);
        }

        public String toString() {
            return "{[Contact: " + this.mContact + "][Label: " + this.mLabel + "][PhotoUri: " + this.mPhotoUri + "][IsIndelible" + this.mIsIndelible + "]}";
        }
    }

    private class KeyInterceptingInputConnection
    extends InputConnectionWrapper {
        public KeyInterceptingInputConnection(InputConnection target) {
            super(target, true);
        }

        public boolean commitText(CharSequence text, int newCursorPosition) {
            return super.commitText(text, newCursorPosition);
        }

        public boolean sendKeyEvent(KeyEvent event) {
            if (ChipsView.this.mEditText.length() == 0 && event.getAction() == 0 && event.getKeyCode() == 67) {
                ChipsView.this.selectOrDeleteLastChip();
                return true;
            }
            if (event.getAction() == 0 && event.getKeyCode() == 66) {
                ChipsView.this.mEditText.append("\n");
                return true;
            }
            return super.sendKeyEvent(event);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            if (ChipsView.this.mEditText.length() == 0 && beforeLength == 1 && afterLength == 0) {
                return this.sendKeyEvent(new KeyEvent(0, 67)) && this.sendKeyEvent(new KeyEvent(1, 67));
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }
    }

    private class EditTextListener
    implements TextWatcher {
        private boolean mIsPasteTextChange = false;

        private EditTextListener() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (count > 1) {
                this.mIsPasteTextChange = true;
            }
        }

        public void afterTextChanged(Editable s) {
            if (this.mIsPasteTextChange) {
                this.mIsPasteTextChange = false;
            } else if (s.toString().contains("\n")) {
                String text = s.toString();
                text = text.replace("\n", "");
                while (text.contains("  ")) {
                    text = text.replace("  ", " ");
                }
                if (text.length() > 1) {
                    s.clear();
                    if (!ChipsView.this.onEnterPressed(text)) {
                        s.append((CharSequence)text);
                    }
                } else {
                    s.clear();
                    s.append((CharSequence)text);
                }
            }
            if (ChipsView.this.mChipsListener != null) {
                ChipsView.this.mChipsListener.onTextChanged((CharSequence)s);
            }
        }
    }
}

