/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import java.util.Objects;

public class SizeScaler {
    private static final int ROUNDING_VALUE = 64;
    private final float scaleFactor;
    private final boolean noStrideAlignment;

    public SizeScaler(float scaleFactor) {
        this(scaleFactor, false);
    }

    public SizeScaler(float scaleFactor, boolean noStrideAlignment) {
        this.scaleFactor = scaleFactor;
        this.noStrideAlignment = noStrideAlignment;
    }

    Size scale(int width, int height) {
        int nonRoundedScaledWidth = this.downscaleSize(width);
        int scaledWidth = this.roundSize(nonRoundedScaledWidth);
        float roundingScaleFactor = (float)width / (float)scaledWidth;
        int scaledHeight = (int)Math.ceil((float)height / roundingScaleFactor);
        return new Size(scaledWidth, scaledHeight);
    }

    Size scale(Size size) {
        return this.scale(size.width, size.height);
    }

    boolean isZeroSized(int measuredWidth, int measuredHeight) {
        return this.downscaleSize(measuredHeight) == 0 || this.downscaleSize(measuredWidth) == 0;
    }

    private int roundSize(int value) {
        if (this.noStrideAlignment) {
            return value;
        }
        if (value % 64 == 0) {
            return value;
        }
        return value - value % 64 + 64;
    }

    private int downscaleSize(float value) {
        return (int)Math.ceil(value / this.scaleFactor);
    }

    static class Size {
        final int width;
        final int height;

        Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Size size = (Size)o;
            return this.width == size.width && this.height == size.height;
        }

        public int hashCode() {
            return Objects.hash(this.width, this.height);
        }

        public String toString() {
            return "Size{width=" + this.width + ", height=" + this.height + '}';
        }
    }
}

