/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.RecordingCanvas;
import android.graphics.RenderNode;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

public class BlurTarget
extends FrameLayout {
    static final boolean canUseHardwareRendering = Build.VERSION.SDK_INT >= 31;
    RenderNode renderNode;

    public BlurTarget(@NonNull Context context) {
        super(context);
        if (canUseHardwareRendering) {
            this.renderNode = new RenderNode("BlurViewHost node");
        }
    }

    public BlurTarget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        if (canUseHardwareRendering) {
            this.renderNode = new RenderNode("BlurViewHost node");
        }
    }

    public BlurTarget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (canUseHardwareRendering) {
            this.renderNode = new RenderNode("BlurViewHost node");
        }
    }

    @RequiresApi(api=21)
    public BlurTarget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (canUseHardwareRendering) {
            this.renderNode = new RenderNode("BlurViewHost node");
        }
    }

    protected void dispatchDraw(@NonNull Canvas canvas) {
        if (canUseHardwareRendering && canvas.isHardwareAccelerated()) {
            this.renderNode.setPosition(0, 0, this.getWidth(), this.getHeight());
            RecordingCanvas recordingCanvas = this.renderNode.beginRecording();
            super.dispatchDraw((Canvas)recordingCanvas);
            this.renderNode.endRecording();
            canvas.drawRenderNode(this.renderNode);
        } else {
            super.dispatchDraw(canvas);
        }
    }
}

