/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurController;
import eightbitlab.com.blurview.BlurViewFacade;
import eightbitlab.com.blurview.NoOpController;
import eightbitlab.com.blurview.PreDrawBlurController;
import eightbitlab.com.blurview.R;
import eightbitlab.com.blurview.RenderEffectBlur;
import eightbitlab.com.blurview.RenderScriptBlur;

public class BlurView
extends FrameLayout {
    private static final String TAG = BlurView.class.getSimpleName();
    BlurController blurController = new NoOpController();
    @ColorInt
    private int overlayColor;

    public BlurView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public BlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public BlurView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BlurView, defStyleAttr, 0);
        this.overlayColor = a.getColor(R.styleable.BlurView_blurOverlayColor, 0);
        a.recycle();
    }

    public void draw(Canvas canvas) {
        boolean shouldDraw = this.blurController.draw(canvas);
        if (shouldDraw) {
            super.draw(canvas);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.blurController.updateBlurViewSize();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.blurController.setBlurAutoUpdate(false);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isHardwareAccelerated()) {
            Log.e((String)TAG, (String)"BlurView can't be used in not hardware-accelerated window!");
        } else {
            this.blurController.setBlurAutoUpdate(true);
        }
    }

    public BlurViewFacade setupWith(@NonNull ViewGroup rootView, BlurAlgorithm algorithm) {
        this.blurController.destroy();
        PreDrawBlurController blurController = new PreDrawBlurController((View)this, rootView, this.overlayColor, algorithm);
        this.blurController = blurController;
        return blurController;
    }

    @RequiresApi(api=17)
    public BlurViewFacade setupWith(@NonNull ViewGroup rootView) {
        return this.setupWith(rootView, this.getBlurAlgorithm());
    }

    public BlurViewFacade setBlurRadius(float radius) {
        return this.blurController.setBlurRadius(radius);
    }

    public BlurViewFacade setOverlayColor(@ColorInt int overlayColor) {
        this.overlayColor = overlayColor;
        return this.blurController.setOverlayColor(overlayColor);
    }

    public BlurViewFacade setBlurAutoUpdate(boolean enabled) {
        return this.blurController.setBlurAutoUpdate(enabled);
    }

    public BlurViewFacade setBlurEnabled(boolean enabled) {
        return this.blurController.setBlurEnabled(enabled);
    }

    @NonNull
    @RequiresApi(api=17)
    private BlurAlgorithm getBlurAlgorithm() {
        BlurAlgorithm algorithm = Build.VERSION.SDK_INT >= 31 ? new RenderEffectBlur() : new RenderScriptBlur(this.getContext());
        return algorithm;
    }
}

