/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RecordingCanvas;
import android.graphics.RenderEffect;
import android.graphics.RenderNode;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import eightbitlab.com.blurview.BlurAlgorithm;

@RequiresApi(value=31)
public class RenderEffectBlur
implements BlurAlgorithm {
    private final RenderNode node = new RenderNode("BlurViewNode");
    private int height;
    private int width;

    @Override
    public Bitmap blur(Bitmap bitmap, float blurRadius) {
        if (bitmap.getHeight() != this.height || bitmap.getWidth() != this.width) {
            this.height = bitmap.getHeight();
            this.width = bitmap.getWidth();
            this.node.setPosition(0, 0, this.width, this.height);
        }
        RecordingCanvas canvas = this.node.beginRecording();
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        this.node.endRecording();
        this.node.setRenderEffect(RenderEffect.createBlurEffect((float)blurRadius, (float)blurRadius, (Shader.TileMode)Shader.TileMode.MIRROR));
        return bitmap;
    }

    @Override
    public void destroy() {
        this.node.discardDisplayList();
    }

    @Override
    public boolean canModifyBitmap() {
        return true;
    }

    @Override
    @NonNull
    public Bitmap.Config getSupportedBitmapConfig() {
        return Bitmap.Config.ARGB_8888;
    }

    @Override
    public float scaleFactor() {
        return 6.0f;
    }

    @Override
    public void render(@NonNull Canvas canvas, @NonNull Bitmap ignored) {
        canvas.drawRenderNode(this.node);
    }
}

