/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import eightbitlab.com.blurview.BlurAlgorithm;

public final class StackBlur
implements BlurAlgorithm {
    private boolean canReuseInBitmap;
    private int[] pix;
    private int[] dv;

    public StackBlur(boolean canReuseInBitmap) {
        this.canReuseInBitmap = canReuseInBitmap;
        this.pix = new int[1];
        this.dv = new int[1];
    }

    @Override
    public Bitmap blur(Bitmap sentBitmap, float floatRadius) {
        int stackstart;
        int x;
        int stackpointer;
        int rbs;
        int[] sir;
        int p;
        int rinsum;
        int ginsum;
        int binsum;
        int routsum;
        int goutsum;
        int boutsum;
        int rsum;
        int gsum;
        int bsum;
        int y;
        int i;
        int h;
        int radius = (int)floatRadius;
        Bitmap bitmap = this.canReuseInBitmap ? sentBitmap : sentBitmap.copy(sentBitmap.getConfig(), true);
        if (radius < 1) {
            return null;
        }
        int w = bitmap.getWidth();
        if (this.pix.length != w * (h = bitmap.getHeight())) {
            this.pix = new int[w * h];
        }
        bitmap.getPixels(this.pix, 0, w, 0, 0, w, h);
        int wm = w - 1;
        int hm = h - 1;
        int div = radius + radius + 1;
        int px = 0;
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        if (this.dv.length != 256 * divsum) {
            this.dv = new int[256 * divsum];
        }
        for (i = 0; i < 256 * divsum; ++i) {
            this.dv[i] = i / divsum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (y = 0; y < h; ++y) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            for (i = -radius; i <= radius; ++i) {
                p = this.pix[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = radius;
            for (x = 0; x < w; ++x) {
                this.pix[yi] = 0xFF000000 & this.pix[yi] | this.dv[rsum] << 16 | this.dv[gsum] << 8 | this.dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = this.pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += w;
        }
        for (x = 0; x < w; ++x) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            int yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                px = this.pix[yi];
                sir[0] = (px & 0xFF0000) >> 16;
                sir[1] = (px & 0xFF00) >> 8;
                sir[2] = px & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += w;
            }
            yi = x;
            stackpointer = radius;
            for (y = 0; y < h; ++y) {
                this.pix[yi] = 0xFF000000 & this.pix[yi] | this.dv[rsum] << 16 | this.dv[gsum] << 8 | this.dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                p = x + vmin[y];
                px = this.pix[p];
                sir[0] = (px & 0xFF0000) >> 16;
                sir[1] = (px & 0xFF00) >> 8;
                sir[2] = px & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
            }
        }
        bitmap.setPixels(this.pix, 0, w, 0, 0, w, h);
        return bitmap;
    }

    @Override
    public void destroy() {
        this.pix = null;
        this.dv = null;
    }

    @Override
    public boolean canModifyBitmap() {
        return this.canReuseInBitmap;
    }

    @Override
    @NonNull
    public Bitmap.Config getSupportedBitmapConfig() {
        return Bitmap.Config.RGB_565;
    }
}

