/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.support.v8.renderscript.Type;
import eightbitlab.com.blurview.BlurAlgorithm;

public final class RenderScriptBlur
implements BlurAlgorithm {
    private RenderScript renderScript;
    private ScriptIntrinsicBlur blurScript;
    private Allocation outAllocation;
    private boolean canModifyBitmap;
    private int lastBitmapWidth;
    private int lastBitmapHeight;

    public RenderScriptBlur(Context context, boolean canModifyBitmap) {
        this.canModifyBitmap = canModifyBitmap;
        this.renderScript = RenderScript.create((Context)context);
        this.blurScript = ScriptIntrinsicBlur.create((RenderScript)this.renderScript, (Element)Element.U8_4((RenderScript)this.renderScript));
    }

    private boolean canReuseAllocation(Bitmap bitmap) {
        return bitmap.getHeight() == this.lastBitmapHeight && bitmap.getWidth() == this.lastBitmapWidth;
    }

    @Override
    public final Bitmap blur(Bitmap bitmap, float blurRadius) {
        Allocation inAllocation = Allocation.createFromBitmap((RenderScript)this.renderScript, (Bitmap)bitmap);
        Bitmap outputBitmap = this.canModifyBitmap ? bitmap : Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)bitmap.getConfig());
        if (!this.canReuseAllocation(bitmap)) {
            if (this.outAllocation != null) {
                this.outAllocation.destroy();
            }
            this.outAllocation = Allocation.createTyped((RenderScript)this.renderScript, (Type)inAllocation.getType());
            this.lastBitmapWidth = bitmap.getWidth();
            this.lastBitmapHeight = bitmap.getHeight();
        }
        this.blurScript.setRadius(blurRadius);
        this.blurScript.setInput(inAllocation);
        this.blurScript.forEach(this.outAllocation);
        this.outAllocation.copyTo(outputBitmap);
        inAllocation.destroy();
        return outputBitmap;
    }

    @Override
    public void destroy() {
        this.blurScript.destroy();
        this.renderScript.destroy();
        this.outAllocation.destroy();
    }

    @Override
    public boolean canModifyBitmap() {
        return this.canModifyBitmap;
    }

    @Override
    @NonNull
    public Bitmap.Config getSupportedBitmapConfig() {
        return Bitmap.Config.ARGB_8888;
    }
}

