/*
 * Decompiled with CFR 0.152.
 */
package eightbitlab.com.blurview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurController;
import eightbitlab.com.blurview.StackBlur;

class DefaultBlurController
implements BlurController {
    private static final String TAG = DefaultBlurController.class.getSimpleName();
    private static final int ROUNDING_VALUE = 16;
    private final float scaleFactor = 8.0f;
    private float blurRadius = 16.0f;
    private float roundingWidthScaleFactor;
    private float roundingHeightScaleFactor;
    private BlurAlgorithm blurAlgorithm;
    private Canvas internalCanvas;
    private Bitmap internalBitmap;
    private View blurView;
    private View rootView;
    private ViewTreeObserver.OnPreDrawListener drawListener;
    private boolean isMeDrawingNow;
    private final Runnable onDrawEndTask = new Runnable(){

        @Override
        public void run() {
            DefaultBlurController.this.isMeDrawingNow = false;
        }
    };
    @Nullable
    private Drawable windowBackground;

    public DefaultBlurController(@NonNull View blurView, @NonNull View rootView) {
        this.rootView = rootView;
        this.blurView = blurView;
        this.blurAlgorithm = new StackBlur(true);
        int measuredWidth = blurView.getMeasuredWidth();
        int measuredHeight = blurView.getMeasuredHeight();
        if (this.isZeroSized(measuredWidth, measuredHeight)) {
            this.deferBitmapCreation();
            return;
        }
        this.init(measuredWidth, measuredHeight);
    }

    private int downScaleSize(float value) {
        return (int)Math.ceil(value / 8.0f);
    }

    private int roundSize(int value) {
        if (value % 16 == 0) {
            return value;
        }
        return value - value % 16 + 16;
    }

    private void init(int measuredWidth, int measuredHeight) {
        if (this.isZeroSized(measuredWidth, measuredHeight)) {
            this.blurView.setWillNotDraw(true);
            return;
        }
        this.blurView.setWillNotDraw(false);
        this.allocateBitmap(measuredWidth, measuredHeight);
        this.internalCanvas = new Canvas(this.internalBitmap);
        this.observeDrawCalls();
    }

    private boolean isZeroSized(int measuredWidth, int measuredHeight) {
        return this.downScaleSize(measuredHeight) == 0 || this.downScaleSize(measuredWidth) == 0;
    }

    private void observeDrawCalls() {
        if (this.drawListener != null) {
            return;
        }
        this.drawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                if (!DefaultBlurController.this.isMeDrawingNow) {
                    DefaultBlurController.this.updateBlur();
                }
                return true;
            }
        };
        this.rootView.getViewTreeObserver().addOnPreDrawListener(this.drawListener);
    }

    @Override
    public void stopAutoBlurUpdate() {
        this.rootView.getViewTreeObserver().removeOnPreDrawListener(this.drawListener);
    }

    private void updateBlur() {
        this.isMeDrawingNow = true;
        this.blurView.invalidate();
    }

    private void deferBitmapCreation() {
        this.blurView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    DefaultBlurController.this.blurView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    DefaultBlurController.this.blurView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                int measuredWidth = DefaultBlurController.this.blurView.getMeasuredWidth();
                int measuredHeight = DefaultBlurController.this.blurView.getMeasuredHeight();
                DefaultBlurController.this.init(measuredWidth, measuredHeight);
            }
        });
    }

    private void allocateBitmap(int measuredWidth, int measuredHeight) {
        int nonRoundedScaledWidth = this.downScaleSize(measuredWidth);
        int nonRoundedScaledHeight = this.downScaleSize(measuredHeight);
        int scaledWidth = this.roundSize(nonRoundedScaledWidth);
        int scaledHeight = this.roundSize(nonRoundedScaledHeight);
        this.roundingHeightScaleFactor = (float)scaledHeight / (float)nonRoundedScaledHeight;
        this.roundingWidthScaleFactor = (float)scaledWidth / (float)nonRoundedScaledWidth;
        this.internalBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)this.blurAlgorithm.getSupportedBitmapConfig());
    }

    private void setupInternalCanvasMatrix() {
        float scaleFactorX = 8.0f / this.roundingWidthScaleFactor;
        float scaleFactorY = 8.0f / this.roundingHeightScaleFactor;
        float scaledLeftPosition = (float)(-this.blurView.getLeft()) / scaleFactorX;
        float scaledTopPosition = (float)(-this.blurView.getTop()) / scaleFactorY;
        float scaledTranslationX = this.blurView.getTranslationX() / scaleFactorX;
        float scaledTranslationY = this.blurView.getTranslationY() / scaleFactorY;
        this.internalCanvas.translate(scaledLeftPosition - scaledTranslationX, scaledTopPosition - scaledTranslationY);
        this.internalCanvas.scale(1.0f / scaleFactorX, 1.0f / scaleFactorY);
    }

    @Override
    public boolean isInternalCanvas(Canvas canvas) {
        return this.internalCanvas == canvas;
    }

    private void drawUnderlyingViews() {
        if (this.windowBackground != null) {
            this.windowBackground.draw(this.internalCanvas);
        }
        this.rootView.draw(this.internalCanvas);
    }

    @Override
    public void drawBlurredContent(Canvas canvas) {
        this.isMeDrawingNow = true;
        this.internalCanvas.save();
        this.setupInternalCanvasMatrix();
        this.drawUnderlyingViews();
        this.internalCanvas.restore();
        this.blurAndSave();
        this.draw(canvas);
    }

    private void draw(Canvas canvas) {
        canvas.save();
        canvas.scale(8.0f * this.roundingWidthScaleFactor, 8.0f * this.roundingHeightScaleFactor);
        canvas.drawBitmap(this.internalBitmap, 0.0f, 0.0f, null);
        canvas.restore();
    }

    @Override
    public void onDrawEnd(Canvas canvas) {
        this.blurView.post(this.onDrawEndTask);
    }

    private void blurAndSave() {
        this.internalBitmap = this.blurAlgorithm.blur(this.internalBitmap, this.blurRadius);
    }

    @Override
    public void updateBlurViewSize() {
        int measuredWidth = this.blurView.getMeasuredWidth();
        int measuredHeight = this.blurView.getMeasuredHeight();
        this.init(measuredWidth, measuredHeight);
    }

    @Override
    public void destroy() {
        this.stopAutoBlurUpdate();
        this.drawListener = null;
        this.rootView = null;
        this.blurView = null;
        this.blurAlgorithm.destroy();
        this.internalBitmap.recycle();
    }

    @Override
    public void setBlurRadius(float radius) {
        this.blurRadius = radius;
    }

    @Override
    public void setBlurAlgorithm(BlurAlgorithm algorithm) {
        this.blurAlgorithm = algorithm;
    }

    @Override
    public void setWindowBackground(@Nullable Drawable windowBackground) {
        this.windowBackground = windowBackground;
    }
}

