/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimateringtonepicker;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.AnyRes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.aprildown.ultimateringtonepicker.RingtonePickerFragment;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u0000 \u00032\u00020\u0001:\u0007\u0003\u0004\u0005\u0006\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\n"}, d2={"Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker;", "", "()V", "Companion", "DeviceRingtonePicker", "RingtoneCategoryType", "RingtoneEntry", "RingtonePickerListener", "Settings", "SystemRingtonePicker", "xyz.aprildown.ultimateringtonepicker.library"})
public final class UltimateRingtonePicker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final Uri createAssetRingtoneUri(@NotNull String fileName) {
        return Companion.createAssetRingtoneUri(fileName);
    }

    @JvmStatic
    @NotNull
    public static final Uri createRawRingtoneUri(@NotNull Context context, @AnyRes int resourceId) {
        return Companion.createRawRingtoneUri(context, resourceId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$Companion;", "", "()V", "createAssetRingtoneUri", "Landroid/net/Uri;", "fileName", "", "createRawRingtoneUri", "context", "Landroid/content/Context;", "resourceId", "", "xyz.aprildown.ultimateringtonepicker.library"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Uri createAssetRingtoneUri(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Uri uri = Uri.parse((String)("file:///android_asset/" + fileName));
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(...)");
            return uri;
        }

        @JvmStatic
        @NotNull
        public final Uri createRawRingtoneUri(@NotNull Context context, @AnyRes int resourceId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Uri uri = new Uri.Builder().scheme("android.resource").authority(context.getPackageName()).path(String.valueOf(resourceId)).build();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"build(...)");
            return uri;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$DeviceRingtonePicker;", "Landroid/os/Parcelable;", "deviceRingtoneTypes", "", "Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$RingtoneCategoryType;", "alwaysUseSaf", "", "(Ljava/util/List;Z)V", "getAlwaysUseSaf", "()Z", "getDeviceRingtoneTypes", "()Ljava/util/List;", "component1", "component2", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "xyz.aprildown.ultimateringtonepicker.library"})
    @Parcelize
    public static final class DeviceRingtonePicker
    implements Parcelable {
        @NotNull
        private final List<RingtoneCategoryType> deviceRingtoneTypes;
        private final boolean alwaysUseSaf;
        @NotNull
        public static final Parcelable.Creator<DeviceRingtonePicker> CREATOR;

        public DeviceRingtonePicker(@NotNull List<? extends RingtoneCategoryType> deviceRingtoneTypes, boolean alwaysUseSaf) {
            Intrinsics.checkNotNullParameter(deviceRingtoneTypes, (String)"deviceRingtoneTypes");
            this.deviceRingtoneTypes = deviceRingtoneTypes;
            this.alwaysUseSaf = alwaysUseSaf;
        }

        public /* synthetic */ DeviceRingtonePicker(List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            this(list, bl);
        }

        @NotNull
        public final List<RingtoneCategoryType> getDeviceRingtoneTypes() {
            return this.deviceRingtoneTypes;
        }

        public final boolean getAlwaysUseSaf() {
            return this.alwaysUseSaf;
        }

        @NotNull
        public final List<RingtoneCategoryType> component1() {
            return this.deviceRingtoneTypes;
        }

        public final boolean component2() {
            return this.alwaysUseSaf;
        }

        @NotNull
        public final DeviceRingtonePicker copy(@NotNull List<? extends RingtoneCategoryType> deviceRingtoneTypes, boolean alwaysUseSaf) {
            Intrinsics.checkNotNullParameter(deviceRingtoneTypes, (String)"deviceRingtoneTypes");
            return new DeviceRingtonePicker(deviceRingtoneTypes, alwaysUseSaf);
        }

        public static /* synthetic */ DeviceRingtonePicker copy$default(DeviceRingtonePicker deviceRingtonePicker, List list, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                list = deviceRingtonePicker.deviceRingtoneTypes;
            }
            if ((n & 2) != 0) {
                bl = deviceRingtonePicker.alwaysUseSaf;
            }
            return deviceRingtonePicker.copy(list, bl);
        }

        @NotNull
        public String toString() {
            return "DeviceRingtonePicker(deviceRingtoneTypes=" + this.deviceRingtoneTypes + ", alwaysUseSaf=" + this.alwaysUseSaf + ")";
        }

        public int hashCode() {
            int result = ((Object)this.deviceRingtoneTypes).hashCode();
            result = result * 31 + Boolean.hashCode(this.alwaysUseSaf);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeviceRingtonePicker)) {
                return false;
            }
            DeviceRingtonePicker deviceRingtonePicker = (DeviceRingtonePicker)other;
            if (!Intrinsics.areEqual(this.deviceRingtoneTypes, deviceRingtonePicker.deviceRingtoneTypes)) {
                return false;
            }
            return this.alwaysUseSaf == deviceRingtonePicker.alwaysUseSaf;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            List<RingtoneCategoryType> list = this.deviceRingtoneTypes;
            out.writeInt(list.size());
            Iterator<RingtoneCategoryType> iterator = list.iterator();
            while (iterator.hasNext()) {
                out.writeString(iterator.next().name());
            }
            out.writeInt(this.alwaysUseSaf ? 1 : 0);
        }

        public DeviceRingtonePicker() {
            this(null, false, 3, null);
        }

        static {
            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<DeviceRingtonePicker> {
                @NotNull
                public final DeviceRingtonePicker[] newArray(int size) {
                    return new DeviceRingtonePicker[size];
                }

                @NotNull
                public final DeviceRingtonePicker createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n = parcel.readInt();
                    ArrayList<RingtoneCategoryType> arrayList = new ArrayList<RingtoneCategoryType>(n);
                    for (int i = 0; i != n; ++i) {
                        arrayList.add(RingtoneCategoryType.valueOf(parcel.readString()));
                    }
                    boolean bl = parcel.readInt() != 0;
                    List list = arrayList;
                    return new DeviceRingtonePicker(list, bl);
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$RingtoneCategoryType;", "", "(Ljava/lang/String;I)V", "All", "Artist", "Album", "Folder", "xyz.aprildown.ultimateringtonepicker.library"})
    public static final class RingtoneCategoryType
    extends Enum<RingtoneCategoryType> {
        public static final /* enum */ RingtoneCategoryType All = new RingtoneCategoryType();
        public static final /* enum */ RingtoneCategoryType Artist = new RingtoneCategoryType();
        public static final /* enum */ RingtoneCategoryType Album = new RingtoneCategoryType();
        public static final /* enum */ RingtoneCategoryType Folder = new RingtoneCategoryType();
        private static final /* synthetic */ RingtoneCategoryType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RingtoneCategoryType[] values() {
            return (RingtoneCategoryType[])$VALUES.clone();
        }

        public static RingtoneCategoryType valueOf(String value) {
            return Enum.valueOf(RingtoneCategoryType.class, value);
        }

        @NotNull
        public static EnumEntries<RingtoneCategoryType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = ringtoneCategoryTypeArray = new RingtoneCategoryType[]{RingtoneCategoryType.All, RingtoneCategoryType.Artist, RingtoneCategoryType.Album, RingtoneCategoryType.Folder};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$RingtoneEntry;", "Landroid/os/Parcelable;", "uri", "Landroid/net/Uri;", "name", "", "(Landroid/net/Uri;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getUri", "()Landroid/net/Uri;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "xyz.aprildown.ultimateringtonepicker.library"})
    @Parcelize
    public static final class RingtoneEntry
    implements Parcelable {
        @NotNull
        private final Uri uri;
        @NotNull
        private final String name;
        @NotNull
        public static final Parcelable.Creator<RingtoneEntry> CREATOR;

        public RingtoneEntry(@NotNull Uri uri, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.uri = uri;
            this.name = name;
        }

        @NotNull
        public final Uri getUri() {
            return this.uri;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Uri component1() {
            return this.uri;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final RingtoneEntry copy(@NotNull Uri uri, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new RingtoneEntry(uri, name);
        }

        public static /* synthetic */ RingtoneEntry copy$default(RingtoneEntry ringtoneEntry, Uri uri, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                uri = ringtoneEntry.uri;
            }
            if ((n & 2) != 0) {
                string2 = ringtoneEntry.name;
            }
            return ringtoneEntry.copy(uri, string2);
        }

        @NotNull
        public String toString() {
            return "RingtoneEntry(uri=" + this.uri + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RingtoneEntry)) {
                return false;
            }
            RingtoneEntry ringtoneEntry = (RingtoneEntry)other;
            if (!Intrinsics.areEqual((Object)this.uri, (Object)ringtoneEntry.uri)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)ringtoneEntry.name);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeParcelable((Parcelable)this.uri, flags);
            out.writeString(this.name);
        }

        static {
            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<RingtoneEntry> {
                @NotNull
                public final RingtoneEntry[] newArray(int size) {
                    return new RingtoneEntry[size];
                }

                @NotNull
                public final RingtoneEntry createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new RingtoneEntry((Uri)parcel.readParcelable(RingtoneEntry.class.getClassLoader()), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$RingtonePickerListener;", "", "onRingtonePicked", "", "ringtones", "", "Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$RingtoneEntry;", "xyz.aprildown.ultimateringtonepicker.library"})
    public static interface RingtonePickerListener {
        public void onRingtonePicked(@NotNull List<RingtoneEntry> var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001BK\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\rH\u00c6\u0003JO\u0010 \u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0006\u0010!\u001a\u00020\"J\t\u0010#\u001a\u00020\tH\u00d6\u0001J\u0013\u0010$\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\tH\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001J\u0019\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006/"}, d2={"Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$Settings;", "Landroid/os/Parcelable;", "preSelectUris", "", "Landroid/net/Uri;", "enableMultiSelect", "", "loop", "streamType", "", "systemRingtonePicker", "Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker;", "deviceRingtonePicker", "Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$DeviceRingtonePicker;", "(Ljava/util/List;ZZILxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker;Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$DeviceRingtonePicker;)V", "getDeviceRingtonePicker", "()Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$DeviceRingtonePicker;", "getEnableMultiSelect", "()Z", "getLoop", "getPreSelectUris", "()Ljava/util/List;", "getStreamType", "()I", "getSystemRingtonePicker", "()Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "createFragment", "Lxyz/aprildown/ultimateringtonepicker/RingtonePickerFragment;", "describeContents", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "xyz.aprildown.ultimateringtonepicker.library"})
    @Parcelize
    public static final class Settings
    implements Parcelable {
        @NotNull
        private final List<Uri> preSelectUris;
        private final boolean enableMultiSelect;
        private final boolean loop;
        private final int streamType;
        @Nullable
        private final SystemRingtonePicker systemRingtonePicker;
        @Nullable
        private final DeviceRingtonePicker deviceRingtonePicker;
        @NotNull
        public static final Parcelable.Creator<Settings> CREATOR;

        public Settings(@NotNull List<? extends Uri> preSelectUris, boolean enableMultiSelect, boolean loop, int streamType, @Nullable SystemRingtonePicker systemRingtonePicker, @Nullable DeviceRingtonePicker deviceRingtonePicker) {
            Intrinsics.checkNotNullParameter(preSelectUris, (String)"preSelectUris");
            this.preSelectUris = preSelectUris;
            this.enableMultiSelect = enableMultiSelect;
            this.loop = loop;
            this.streamType = streamType;
            this.systemRingtonePicker = systemRingtonePicker;
            this.deviceRingtonePicker = deviceRingtonePicker;
            if (!(this.systemRingtonePicker != null || this.deviceRingtonePicker != null)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
        }

        public /* synthetic */ Settings(List list, boolean bl, boolean bl2, int n, SystemRingtonePicker systemRingtonePicker, DeviceRingtonePicker deviceRingtonePicker, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n2 & 2) != 0) {
                bl = false;
            }
            if ((n2 & 4) != 0) {
                bl2 = true;
            }
            if ((n2 & 8) != 0) {
                n = 3;
            }
            if ((n2 & 0x10) != 0) {
                systemRingtonePicker = null;
            }
            if ((n2 & 0x20) != 0) {
                deviceRingtonePicker = null;
            }
            this(list, bl, bl2, n, systemRingtonePicker, deviceRingtonePicker);
        }

        @NotNull
        public final List<Uri> getPreSelectUris() {
            return this.preSelectUris;
        }

        public final boolean getEnableMultiSelect() {
            return this.enableMultiSelect;
        }

        public final boolean getLoop() {
            return this.loop;
        }

        public final int getStreamType() {
            return this.streamType;
        }

        @Nullable
        public final SystemRingtonePicker getSystemRingtonePicker() {
            return this.systemRingtonePicker;
        }

        @Nullable
        public final DeviceRingtonePicker getDeviceRingtonePicker() {
            return this.deviceRingtonePicker;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final RingtonePickerFragment createFragment() {
            void $this$createFragment_u24lambda_u241_u24lambda_u240;
            Bundle bundle;
            RingtonePickerFragment ringtonePickerFragment;
            RingtonePickerFragment $this$createFragment_u24lambda_u241 = ringtonePickerFragment = new RingtonePickerFragment();
            boolean bl = false;
            Bundle bundle2 = bundle = new Bundle();
            RingtonePickerFragment ringtonePickerFragment2 = $this$createFragment_u24lambda_u241;
            boolean bl2 = false;
            $this$createFragment_u24lambda_u241_u24lambda_u240.putParcelable("settings", (Parcelable)this);
            ringtonePickerFragment2.setArguments(bundle);
            return ringtonePickerFragment;
        }

        @NotNull
        public final List<Uri> component1() {
            return this.preSelectUris;
        }

        public final boolean component2() {
            return this.enableMultiSelect;
        }

        public final boolean component3() {
            return this.loop;
        }

        public final int component4() {
            return this.streamType;
        }

        @Nullable
        public final SystemRingtonePicker component5() {
            return this.systemRingtonePicker;
        }

        @Nullable
        public final DeviceRingtonePicker component6() {
            return this.deviceRingtonePicker;
        }

        @NotNull
        public final Settings copy(@NotNull List<? extends Uri> preSelectUris, boolean enableMultiSelect, boolean loop, int streamType, @Nullable SystemRingtonePicker systemRingtonePicker, @Nullable DeviceRingtonePicker deviceRingtonePicker) {
            Intrinsics.checkNotNullParameter(preSelectUris, (String)"preSelectUris");
            return new Settings(preSelectUris, enableMultiSelect, loop, streamType, systemRingtonePicker, deviceRingtonePicker);
        }

        public static /* synthetic */ Settings copy$default(Settings settings, List list, boolean bl, boolean bl2, int n, SystemRingtonePicker systemRingtonePicker, DeviceRingtonePicker deviceRingtonePicker, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = settings.preSelectUris;
            }
            if ((n2 & 2) != 0) {
                bl = settings.enableMultiSelect;
            }
            if ((n2 & 4) != 0) {
                bl2 = settings.loop;
            }
            if ((n2 & 8) != 0) {
                n = settings.streamType;
            }
            if ((n2 & 0x10) != 0) {
                systemRingtonePicker = settings.systemRingtonePicker;
            }
            if ((n2 & 0x20) != 0) {
                deviceRingtonePicker = settings.deviceRingtonePicker;
            }
            return settings.copy(list, bl, bl2, n, systemRingtonePicker, deviceRingtonePicker);
        }

        @NotNull
        public String toString() {
            return "Settings(preSelectUris=" + this.preSelectUris + ", enableMultiSelect=" + this.enableMultiSelect + ", loop=" + this.loop + ", streamType=" + this.streamType + ", systemRingtonePicker=" + this.systemRingtonePicker + ", deviceRingtonePicker=" + this.deviceRingtonePicker + ")";
        }

        public int hashCode() {
            int result = ((Object)this.preSelectUris).hashCode();
            result = result * 31 + Boolean.hashCode(this.enableMultiSelect);
            result = result * 31 + Boolean.hashCode(this.loop);
            result = result * 31 + Integer.hashCode(this.streamType);
            result = result * 31 + (this.systemRingtonePicker == null ? 0 : this.systemRingtonePicker.hashCode());
            result = result * 31 + (this.deviceRingtonePicker == null ? 0 : this.deviceRingtonePicker.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Settings)) {
                return false;
            }
            Settings settings = (Settings)other;
            if (!Intrinsics.areEqual(this.preSelectUris, settings.preSelectUris)) {
                return false;
            }
            if (this.enableMultiSelect != settings.enableMultiSelect) {
                return false;
            }
            if (this.loop != settings.loop) {
                return false;
            }
            if (this.streamType != settings.streamType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.systemRingtonePicker, (Object)settings.systemRingtonePicker)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.deviceRingtonePicker, (Object)settings.deviceRingtonePicker);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Object object = this.preSelectUris;
            out.writeInt(object.size());
            Iterator<Uri> iterator = object.iterator();
            while (iterator.hasNext()) {
                out.writeParcelable((Parcelable)iterator.next(), flags);
            }
            out.writeInt(this.enableMultiSelect ? 1 : 0);
            out.writeInt(this.loop ? 1 : 0);
            out.writeInt(this.streamType);
            object = this.systemRingtonePicker;
            if (object == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                ((SystemRingtonePicker)object).writeToParcel(out, flags);
            }
            object = this.deviceRingtonePicker;
            if (object == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                ((DeviceRingtonePicker)object).writeToParcel(out, flags);
            }
        }

        public Settings() {
            this(null, false, false, 0, null, null, 63, null);
        }

        static {
            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Settings> {
                @NotNull
                public final Settings[] newArray(int size) {
                    return new Settings[size];
                }

                @NotNull
                public final Settings createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n = parcel.readInt();
                    ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>(n);
                    for (int i = 0; i != n; ++i) {
                        arrayList.add(parcel.readParcelable(Settings.class.getClassLoader()));
                    }
                    DeviceRingtonePicker deviceRingtonePicker = (DeviceRingtonePicker)(parcel.readInt() == 0 ? null : DeviceRingtonePicker.CREATOR.createFromParcel(parcel));
                    SystemRingtonePicker systemRingtonePicker = (SystemRingtonePicker)(parcel.readInt() == 0 ? null : SystemRingtonePicker.CREATOR.createFromParcel(parcel));
                    int n2 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    List list = arrayList;
                    return new Settings(list, bl2, bl, n2, systemRingtonePicker, deviceRingtonePicker);
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001:\u0002!\"B-\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\t\u0010\u0014\u001a\u00020\bH\u00d6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker;", "Landroid/os/Parcelable;", "customSection", "Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker$CustomSection;", "defaultSection", "Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker$DefaultSection;", "ringtoneTypes", "", "", "(Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker$CustomSection;Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker$DefaultSection;Ljava/util/List;)V", "getCustomSection", "()Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker$CustomSection;", "getDefaultSection", "()Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker$DefaultSection;", "getRingtoneTypes", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "describeContents", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "CustomSection", "DefaultSection", "xyz.aprildown.ultimateringtonepicker.library"})
    @Parcelize
    public static final class SystemRingtonePicker
    implements Parcelable {
        @Nullable
        private final CustomSection customSection;
        @Nullable
        private final DefaultSection defaultSection;
        @NotNull
        private final List<Integer> ringtoneTypes;
        @NotNull
        public static final Parcelable.Creator<SystemRingtonePicker> CREATOR;

        public SystemRingtonePicker(@Nullable CustomSection customSection, @Nullable DefaultSection defaultSection, @NotNull List<Integer> ringtoneTypes) {
            Intrinsics.checkNotNullParameter(ringtoneTypes, (String)"ringtoneTypes");
            this.customSection = customSection;
            this.defaultSection = defaultSection;
            this.ringtoneTypes = ringtoneTypes;
        }

        public /* synthetic */ SystemRingtonePicker(CustomSection customSection, DefaultSection defaultSection, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                customSection = null;
            }
            if ((n & 2) != 0) {
                defaultSection = null;
            }
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(customSection, defaultSection, list);
        }

        @Nullable
        public final CustomSection getCustomSection() {
            return this.customSection;
        }

        @Nullable
        public final DefaultSection getDefaultSection() {
            return this.defaultSection;
        }

        @NotNull
        public final List<Integer> getRingtoneTypes() {
            return this.ringtoneTypes;
        }

        @Nullable
        public final CustomSection component1() {
            return this.customSection;
        }

        @Nullable
        public final DefaultSection component2() {
            return this.defaultSection;
        }

        @NotNull
        public final List<Integer> component3() {
            return this.ringtoneTypes;
        }

        @NotNull
        public final SystemRingtonePicker copy(@Nullable CustomSection customSection, @Nullable DefaultSection defaultSection, @NotNull List<Integer> ringtoneTypes) {
            Intrinsics.checkNotNullParameter(ringtoneTypes, (String)"ringtoneTypes");
            return new SystemRingtonePicker(customSection, defaultSection, ringtoneTypes);
        }

        public static /* synthetic */ SystemRingtonePicker copy$default(SystemRingtonePicker systemRingtonePicker, CustomSection customSection, DefaultSection defaultSection, List list, int n, Object object) {
            if ((n & 1) != 0) {
                customSection = systemRingtonePicker.customSection;
            }
            if ((n & 2) != 0) {
                defaultSection = systemRingtonePicker.defaultSection;
            }
            if ((n & 4) != 0) {
                list = systemRingtonePicker.ringtoneTypes;
            }
            return systemRingtonePicker.copy(customSection, defaultSection, list);
        }

        @NotNull
        public String toString() {
            return "SystemRingtonePicker(customSection=" + this.customSection + ", defaultSection=" + this.defaultSection + ", ringtoneTypes=" + this.ringtoneTypes + ")";
        }

        public int hashCode() {
            int result = this.customSection == null ? 0 : this.customSection.hashCode();
            result = result * 31 + (this.defaultSection == null ? 0 : this.defaultSection.hashCode());
            result = result * 31 + ((Object)this.ringtoneTypes).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SystemRingtonePicker)) {
                return false;
            }
            SystemRingtonePicker systemRingtonePicker = (SystemRingtonePicker)other;
            if (!Intrinsics.areEqual((Object)this.customSection, (Object)systemRingtonePicker.customSection)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultSection, (Object)systemRingtonePicker.defaultSection)) {
                return false;
            }
            return Intrinsics.areEqual(this.ringtoneTypes, systemRingtonePicker.ringtoneTypes);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Object object = this.customSection;
            if (object == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                ((CustomSection)object).writeToParcel(out, flags);
            }
            object = this.defaultSection;
            if (object == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                ((DefaultSection)object).writeToParcel(out, flags);
            }
            object = this.ringtoneTypes;
            out.writeInt(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                out.writeInt(((Number)iterator.next()).intValue());
            }
        }

        public SystemRingtonePicker() {
            this(null, null, null, 7, null);
        }

        static {
            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<SystemRingtonePicker> {
                @NotNull
                public final SystemRingtonePicker[] newArray(int size) {
                    return new SystemRingtonePicker[size];
                }

                @NotNull
                public final SystemRingtonePicker createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n = parcel.readInt();
                    ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
                    DefaultSection defaultSection = (DefaultSection)(parcel.readInt() == 0 ? null : DefaultSection.CREATOR.createFromParcel(parcel));
                    CustomSection customSection = (CustomSection)(parcel.readInt() == 0 ? null : CustomSection.CREATOR.createFromParcel(parcel));
                    for (int i = 0; i != n; ++i) {
                        arrayList.add(parcel.readInt());
                    }
                    List list = arrayList;
                    DefaultSection defaultSection2 = defaultSection;
                    CustomSection customSection2 = customSection;
                    return new SystemRingtonePicker(customSection2, defaultSection2, list);
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001c"}, d2={"Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker$CustomSection;", "Landroid/os/Parcelable;", "useSafSelect", "", "launchSafOnPermissionDenied", "launchSafOnPermissionPermanentlyDenied", "(ZZZ)V", "getLaunchSafOnPermissionDenied", "()Z", "getLaunchSafOnPermissionPermanentlyDenied", "getUseSafSelect", "component1", "component2", "component3", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "xyz.aprildown.ultimateringtonepicker.library"})
        @Parcelize
        public static final class CustomSection
        implements Parcelable {
            private final boolean useSafSelect;
            private final boolean launchSafOnPermissionDenied;
            private final boolean launchSafOnPermissionPermanentlyDenied;
            @NotNull
            public static final Parcelable.Creator<CustomSection> CREATOR;

            public CustomSection(boolean useSafSelect, boolean launchSafOnPermissionDenied, boolean launchSafOnPermissionPermanentlyDenied) {
                this.useSafSelect = useSafSelect;
                this.launchSafOnPermissionDenied = launchSafOnPermissionDenied;
                this.launchSafOnPermissionPermanentlyDenied = launchSafOnPermissionPermanentlyDenied;
            }

            public /* synthetic */ CustomSection(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    bl2 = true;
                }
                if ((n & 4) != 0) {
                    bl3 = true;
                }
                this(bl, bl2, bl3);
            }

            public final boolean getUseSafSelect() {
                return this.useSafSelect;
            }

            public final boolean getLaunchSafOnPermissionDenied() {
                return this.launchSafOnPermissionDenied;
            }

            public final boolean getLaunchSafOnPermissionPermanentlyDenied() {
                return this.launchSafOnPermissionPermanentlyDenied;
            }

            public final boolean component1() {
                return this.useSafSelect;
            }

            public final boolean component2() {
                return this.launchSafOnPermissionDenied;
            }

            public final boolean component3() {
                return this.launchSafOnPermissionPermanentlyDenied;
            }

            @NotNull
            public final CustomSection copy(boolean useSafSelect, boolean launchSafOnPermissionDenied, boolean launchSafOnPermissionPermanentlyDenied) {
                return new CustomSection(useSafSelect, launchSafOnPermissionDenied, launchSafOnPermissionPermanentlyDenied);
            }

            public static /* synthetic */ CustomSection copy$default(CustomSection customSection, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = customSection.useSafSelect;
                }
                if ((n & 2) != 0) {
                    bl2 = customSection.launchSafOnPermissionDenied;
                }
                if ((n & 4) != 0) {
                    bl3 = customSection.launchSafOnPermissionPermanentlyDenied;
                }
                return customSection.copy(bl, bl2, bl3);
            }

            @NotNull
            public String toString() {
                return "CustomSection(useSafSelect=" + this.useSafSelect + ", launchSafOnPermissionDenied=" + this.launchSafOnPermissionDenied + ", launchSafOnPermissionPermanentlyDenied=" + this.launchSafOnPermissionPermanentlyDenied + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.useSafSelect);
                result = result * 31 + Boolean.hashCode(this.launchSafOnPermissionDenied);
                result = result * 31 + Boolean.hashCode(this.launchSafOnPermissionPermanentlyDenied);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CustomSection)) {
                    return false;
                }
                CustomSection customSection = (CustomSection)other;
                if (this.useSafSelect != customSection.useSafSelect) {
                    return false;
                }
                if (this.launchSafOnPermissionDenied != customSection.launchSafOnPermissionDenied) {
                    return false;
                }
                return this.launchSafOnPermissionPermanentlyDenied == customSection.launchSafOnPermissionPermanentlyDenied;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeInt(this.useSafSelect ? 1 : 0);
                out.writeInt(this.launchSafOnPermissionDenied ? 1 : 0);
                out.writeInt(this.launchSafOnPermissionPermanentlyDenied ? 1 : 0);
            }

            public CustomSection() {
                this(false, false, false, 7, null);
            }

            static {
                @Metadata(mv={1, 9, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<CustomSection> {
                    @NotNull
                    public final CustomSection[] newArray(int size) {
                        return new CustomSection[size];
                    }

                    @NotNull
                    public final CustomSection createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new CustomSection(parcel.readInt() != 0, parcel.readInt() != 0, parcel.readInt() != 0);
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0013\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001J\u0019\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$SystemRingtonePicker$DefaultSection;", "Landroid/os/Parcelable;", "showSilent", "", "defaultUri", "Landroid/net/Uri;", "defaultTitle", "", "additionalRingtones", "", "Lxyz/aprildown/ultimateringtonepicker/UltimateRingtonePicker$RingtoneEntry;", "(ZLandroid/net/Uri;Ljava/lang/String;Ljava/util/List;)V", "getAdditionalRingtones", "()Ljava/util/List;", "getDefaultTitle", "()Ljava/lang/String;", "getDefaultUri", "()Landroid/net/Uri;", "getShowSilent", "()Z", "component1", "component2", "component3", "component4", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "xyz.aprildown.ultimateringtonepicker.library"})
        @Parcelize
        public static final class DefaultSection
        implements Parcelable {
            private final boolean showSilent;
            @Nullable
            private final Uri defaultUri;
            @Nullable
            private final String defaultTitle;
            @NotNull
            private final List<RingtoneEntry> additionalRingtones;
            @NotNull
            public static final Parcelable.Creator<DefaultSection> CREATOR;

            public DefaultSection(boolean showSilent, @Nullable Uri defaultUri, @Nullable String defaultTitle, @NotNull List<RingtoneEntry> additionalRingtones) {
                Intrinsics.checkNotNullParameter(additionalRingtones, (String)"additionalRingtones");
                this.showSilent = showSilent;
                this.defaultUri = defaultUri;
                this.defaultTitle = defaultTitle;
                this.additionalRingtones = additionalRingtones;
            }

            public /* synthetic */ DefaultSection(boolean bl, Uri uri, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = true;
                }
                if ((n & 2) != 0) {
                    uri = null;
                }
                if ((n & 4) != 0) {
                    string2 = null;
                }
                if ((n & 8) != 0) {
                    list = CollectionsKt.emptyList();
                }
                this(bl, uri, string2, list);
            }

            public final boolean getShowSilent() {
                return this.showSilent;
            }

            @Nullable
            public final Uri getDefaultUri() {
                return this.defaultUri;
            }

            @Nullable
            public final String getDefaultTitle() {
                return this.defaultTitle;
            }

            @NotNull
            public final List<RingtoneEntry> getAdditionalRingtones() {
                return this.additionalRingtones;
            }

            public final boolean component1() {
                return this.showSilent;
            }

            @Nullable
            public final Uri component2() {
                return this.defaultUri;
            }

            @Nullable
            public final String component3() {
                return this.defaultTitle;
            }

            @NotNull
            public final List<RingtoneEntry> component4() {
                return this.additionalRingtones;
            }

            @NotNull
            public final DefaultSection copy(boolean showSilent, @Nullable Uri defaultUri, @Nullable String defaultTitle, @NotNull List<RingtoneEntry> additionalRingtones) {
                Intrinsics.checkNotNullParameter(additionalRingtones, (String)"additionalRingtones");
                return new DefaultSection(showSilent, defaultUri, defaultTitle, additionalRingtones);
            }

            public static /* synthetic */ DefaultSection copy$default(DefaultSection defaultSection, boolean bl, Uri uri, String string2, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = defaultSection.showSilent;
                }
                if ((n & 2) != 0) {
                    uri = defaultSection.defaultUri;
                }
                if ((n & 4) != 0) {
                    string2 = defaultSection.defaultTitle;
                }
                if ((n & 8) != 0) {
                    list = defaultSection.additionalRingtones;
                }
                return defaultSection.copy(bl, uri, string2, list);
            }

            @NotNull
            public String toString() {
                return "DefaultSection(showSilent=" + this.showSilent + ", defaultUri=" + this.defaultUri + ", defaultTitle=" + this.defaultTitle + ", additionalRingtones=" + this.additionalRingtones + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.showSilent);
                result = result * 31 + (this.defaultUri == null ? 0 : this.defaultUri.hashCode());
                result = result * 31 + (this.defaultTitle == null ? 0 : this.defaultTitle.hashCode());
                result = result * 31 + ((Object)this.additionalRingtones).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DefaultSection)) {
                    return false;
                }
                DefaultSection defaultSection = (DefaultSection)other;
                if (this.showSilent != defaultSection.showSilent) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.defaultUri, (Object)defaultSection.defaultUri)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.defaultTitle, (Object)defaultSection.defaultTitle)) {
                    return false;
                }
                return Intrinsics.areEqual(this.additionalRingtones, defaultSection.additionalRingtones);
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                out.writeInt(this.showSilent ? 1 : 0);
                out.writeParcelable((Parcelable)this.defaultUri, flags);
                out.writeString(this.defaultTitle);
                List<RingtoneEntry> list = this.additionalRingtones;
                out.writeInt(list.size());
                Iterator<RingtoneEntry> iterator = list.iterator();
                while (iterator.hasNext()) {
                    iterator.next().writeToParcel(out, flags);
                }
            }

            public DefaultSection() {
                this(false, null, null, null, 15, null);
            }

            static {
                @Metadata(mv={1, 9, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<DefaultSection> {
                    @NotNull
                    public final DefaultSection[] newArray(int size) {
                        return new DefaultSection[size];
                    }

                    @NotNull
                    public final DefaultSection createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        int n = parcel.readInt();
                        ArrayList<Object> arrayList = new ArrayList<Object>(n);
                        String string2 = parcel.readString();
                        Uri uri = (Uri)parcel.readParcelable(DefaultSection.class.getClassLoader());
                        boolean bl = parcel.readInt() != 0;
                        for (int i = 0; i != n; ++i) {
                            arrayList.add(RingtoneEntry.CREATOR.createFromParcel(parcel));
                        }
                        List list = arrayList;
                        String string3 = string2;
                        Uri uri2 = uri;
                        boolean bl2 = bl;
                        return new DefaultSection(bl2, uri2, string3, list);
                    }
                }
                CREATOR = new Creator();
            }
        }
    }
}

