/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter;

import android.graphics.Bitmap;
import com.dantsu.escposprinter.EscPosCharsetEncoding;
import com.dantsu.escposprinter.barcode.Barcode;
import com.dantsu.escposprinter.connection.DeviceConnection;
import com.dantsu.escposprinter.exceptions.EscPosBarcodeException;
import com.dantsu.escposprinter.exceptions.EscPosConnectionException;
import com.dantsu.escposprinter.exceptions.EscPosEncodingException;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.EnumMap;

public class EscPosPrinterCommands {
    public static final byte LF = 10;
    public static final byte[] RESET_PRINTER = new byte[]{27, 64};
    public static final byte[] TEXT_ALIGN_LEFT = new byte[]{27, 97, 0};
    public static final byte[] TEXT_ALIGN_CENTER = new byte[]{27, 97, 1};
    public static final byte[] TEXT_ALIGN_RIGHT = new byte[]{27, 97, 2};
    public static final byte[] TEXT_WEIGHT_NORMAL = new byte[]{27, 69, 0};
    public static final byte[] TEXT_WEIGHT_BOLD = new byte[]{27, 69, 1};
    public static final byte[] LINE_SPACING_24 = new byte[]{27, 51, 24};
    public static final byte[] LINE_SPACING_30 = new byte[]{27, 51, 30};
    public static final byte[] TEXT_FONT_A = new byte[]{27, 77, 0};
    public static final byte[] TEXT_FONT_B = new byte[]{27, 77, 1};
    public static final byte[] TEXT_FONT_C = new byte[]{27, 77, 2};
    public static final byte[] TEXT_FONT_D = new byte[]{27, 77, 3};
    public static final byte[] TEXT_FONT_E = new byte[]{27, 77, 4};
    public static final byte[] TEXT_SIZE_NORMAL = new byte[]{29, 33, 0};
    public static final byte[] TEXT_SIZE_DOUBLE_HEIGHT = new byte[]{29, 33, 1};
    public static final byte[] TEXT_SIZE_DOUBLE_WIDTH = new byte[]{29, 33, 16};
    public static final byte[] TEXT_SIZE_BIG = new byte[]{29, 33, 17};
    public static final byte[] TEXT_SIZE_BIG_2 = new byte[]{29, 33, 34};
    public static final byte[] TEXT_SIZE_BIG_3 = new byte[]{29, 33, 51};
    public static final byte[] TEXT_SIZE_BIG_4 = new byte[]{29, 33, 68};
    public static final byte[] TEXT_SIZE_BIG_5 = new byte[]{29, 33, 85};
    public static final byte[] TEXT_SIZE_BIG_6 = new byte[]{29, 33, 102};
    public static final byte[] TEXT_UNDERLINE_OFF = new byte[]{27, 45, 0};
    public static final byte[] TEXT_UNDERLINE_ON = new byte[]{27, 45, 1};
    public static final byte[] TEXT_UNDERLINE_LARGE = new byte[]{27, 45, 2};
    public static final byte[] TEXT_DOUBLE_STRIKE_OFF = new byte[]{27, 71, 0};
    public static final byte[] TEXT_DOUBLE_STRIKE_ON = new byte[]{27, 71, 1};
    public static final byte[] TEXT_COLOR_BLACK = new byte[]{27, 114, 0};
    public static final byte[] TEXT_COLOR_RED = new byte[]{27, 114, 1};
    public static final byte[] TEXT_COLOR_REVERSE_OFF = new byte[]{29, 66, 0};
    public static final byte[] TEXT_COLOR_REVERSE_ON = new byte[]{29, 66, 1};
    public static final int BARCODE_TYPE_UPCA = 65;
    public static final int BARCODE_TYPE_UPCE = 66;
    public static final int BARCODE_TYPE_EAN13 = 67;
    public static final int BARCODE_TYPE_EAN8 = 68;
    public static final int BARCODE_TYPE_ITF = 70;
    public static final int BARCODE_TYPE_128 = 73;
    public static final int BARCODE_TEXT_POSITION_NONE = 0;
    public static final int BARCODE_TEXT_POSITION_ABOVE = 1;
    public static final int BARCODE_TEXT_POSITION_BELOW = 2;
    public static final int QRCODE_1 = 49;
    public static final int QRCODE_2 = 50;
    private DeviceConnection printerConnection;
    private EscPosCharsetEncoding charsetEncoding;
    private boolean useEscAsteriskCommand;
    private byte[] currentTextSize = new byte[0];
    private byte[] currentTextColor = new byte[0];
    private byte[] currentTextReverseColor = new byte[0];
    private byte[] currentTextBold = new byte[0];
    private byte[] currentTextUnderline = new byte[0];
    private byte[] currentTextDoubleStrike = new byte[0];

    public static byte[] initGSv0Command(int bytesByLine, int bitmapHeight) {
        int xH = bytesByLine / 256;
        int xL = bytesByLine - xH * 256;
        int yH = bitmapHeight / 256;
        int yL = bitmapHeight - yH * 256;
        byte[] imageBytes = new byte[8 + bytesByLine * bitmapHeight];
        imageBytes[0] = 29;
        imageBytes[1] = 118;
        imageBytes[2] = 48;
        imageBytes[3] = 0;
        imageBytes[4] = (byte)xL;
        imageBytes[5] = (byte)xH;
        imageBytes[6] = (byte)yL;
        imageBytes[7] = (byte)yH;
        return imageBytes;
    }

    public static byte[] bitmapToBytes(Bitmap bitmap, boolean gradient) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int bytesByLine = (int)Math.ceil((float)bitmapWidth / 8.0f);
        byte[] imageBytes = EscPosPrinterCommands.initGSv0Command(bytesByLine, bitmapHeight);
        int i = 8;
        int greyscaleCoefficientInit = 0;
        int gradientStep = 6;
        double colorLevelStep = 765.0 / (double)(15 * gradientStep + gradientStep - 1);
        for (int posY = 0; posY < bitmapHeight; ++posY) {
            int greyscaleCoefficient = greyscaleCoefficientInit;
            int greyscaleLine = posY % gradientStep;
            for (int j = 0; j < bitmapWidth; j += 8) {
                int b = 0;
                for (int k = 0; k < 8; ++k) {
                    int posX = j + k;
                    if (posX >= bitmapWidth) continue;
                    int color = bitmap.getPixel(posX, posY);
                    int red = color >> 16 & 0xFF;
                    int green = color >> 8 & 0xFF;
                    int blue = color & 0xFF;
                    if (gradient && (double)(red + green + blue) < (double)(greyscaleCoefficient * gradientStep + greyscaleLine) * colorLevelStep || !gradient && (red < 160 || green < 160 || blue < 160)) {
                        b |= 1 << 7 - k;
                    }
                    if ((greyscaleCoefficient += 5) <= 15) continue;
                    greyscaleCoefficient -= 16;
                }
                imageBytes[i++] = (byte)b;
            }
            if ((greyscaleCoefficientInit += 2) <= 15) continue;
            greyscaleCoefficientInit = 0;
        }
        return imageBytes;
    }

    public static byte[][] convertGSv0ToEscAsterisk(byte[] bytes) {
        int xL = bytes[4] & 0xFF;
        int xH = bytes[5] & 0xFF;
        int yL = bytes[6] & 0xFF;
        int yH = bytes[7] & 0xFF;
        int bytesByLine = xH * 256 + xL;
        int dotsByLine = bytesByLine * 8;
        int nH = dotsByLine / 256;
        int nL = dotsByLine % 256;
        int imageHeight = yH * 256 + yL;
        int imageLineHeightCount = (int)Math.ceil((double)imageHeight / 24.0);
        int imageBytesSize = 6 + bytesByLine * 24;
        byte[][] returnedBytes = new byte[imageLineHeightCount + 2][];
        returnedBytes[0] = LINE_SPACING_24;
        for (int i = 0; i < imageLineHeightCount; ++i) {
            int pxBaseRow = i * 24;
            byte[] imageBytes = new byte[imageBytesSize];
            imageBytes[0] = 27;
            imageBytes[1] = 42;
            imageBytes[2] = 33;
            imageBytes[3] = (byte)nL;
            imageBytes[4] = (byte)nH;
            for (int j = 5; j < imageBytes.length; ++j) {
                int indexBytes;
                int imgByte = j - 5;
                int byteRow = imgByte % 3;
                int pxColumn = imgByte / 3;
                int bitColumn = 1 << 7 - pxColumn % 8;
                int pxRow = pxBaseRow + byteRow * 8;
                for (int k = 0; k < 8 && (indexBytes = bytesByLine * (pxRow + k) + pxColumn / 8 + 8) < bytes.length; ++k) {
                    boolean isBlack;
                    boolean bl = isBlack = (bytes[indexBytes] & bitColumn) == bitColumn;
                    if (!isBlack) continue;
                    int n = j;
                    imageBytes[n] = (byte)(imageBytes[n] | 1 << 7 - k);
                }
            }
            imageBytes[imageBytes.length - 1] = 10;
            returnedBytes[i + 1] = imageBytes;
        }
        returnedBytes[returnedBytes.length - 1] = LINE_SPACING_30;
        return returnedBytes;
    }

    public static byte[] QRCodeDataToBytes(String data, int size) throws EscPosBarcodeException {
        ByteMatrix byteMatrix = null;
        try {
            EnumMap<EncodeHintType, String> hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            QRCode code = Encoder.encode((String)data, (ErrorCorrectionLevel)ErrorCorrectionLevel.L, hints);
            byteMatrix = code.getMatrix();
        }
        catch (WriterException e) {
            e.printStackTrace();
            throw new EscPosBarcodeException("Unable to encode QR code");
        }
        if (byteMatrix == null) {
            return EscPosPrinterCommands.initGSv0Command(0, 0);
        }
        int width = byteMatrix.getWidth();
        int height = byteMatrix.getHeight();
        int coefficient = Math.round((float)size / (float)width);
        int imageWidth = width * coefficient;
        int imageHeight = height * coefficient;
        int bytesByLine = (int)Math.ceil((float)imageWidth / 8.0f);
        int i = 8;
        if (coefficient < 1) {
            return EscPosPrinterCommands.initGSv0Command(0, 0);
        }
        byte[] imageBytes = EscPosPrinterCommands.initGSv0Command(bytesByLine, imageHeight);
        for (int y = 0; y < height; ++y) {
            byte[] lineBytes = new byte[bytesByLine];
            int x = -1;
            int multipleX = coefficient;
            boolean isBlack = false;
            for (int j = 0; j < bytesByLine; ++j) {
                int b = 0;
                for (int k = 0; k < 8; ++k) {
                    if (multipleX == coefficient) {
                        isBlack = ++x < width && byteMatrix.get(x, y) == 1;
                        multipleX = 0;
                    }
                    if (isBlack) {
                        b |= 1 << 7 - k;
                    }
                    ++multipleX;
                }
                lineBytes[j] = (byte)b;
            }
            for (int multipleY = 0; multipleY < coefficient; ++multipleY) {
                System.arraycopy(lineBytes, 0, imageBytes, i, lineBytes.length);
                i += lineBytes.length;
            }
        }
        return imageBytes;
    }

    public EscPosPrinterCommands(DeviceConnection printerConnection) {
        this(printerConnection, null);
    }

    public EscPosPrinterCommands(DeviceConnection printerConnection, EscPosCharsetEncoding charsetEncoding) {
        this.printerConnection = printerConnection;
        this.charsetEncoding = charsetEncoding != null ? charsetEncoding : new EscPosCharsetEncoding("windows-1252", 6);
    }

    public EscPosPrinterCommands connect() throws EscPosConnectionException {
        this.printerConnection.connect();
        return this;
    }

    public void disconnect() {
        this.printerConnection.disconnect();
    }

    public EscPosPrinterCommands reset() {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(RESET_PRINTER);
        return this;
    }

    public EscPosPrinterCommands setAlign(byte[] align) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(align);
        return this;
    }

    public EscPosPrinterCommands printText(String text) throws EscPosEncodingException {
        return this.printText(text, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize) throws EscPosEncodingException {
        return this.printText(text, textSize, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textColor) throws EscPosEncodingException {
        return this.printText(text, textSize, textColor, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textColor, byte[] textReverseColor) throws EscPosEncodingException {
        return this.printText(text, textSize, textColor, textReverseColor, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textColor, byte[] textReverseColor, byte[] textBold) throws EscPosEncodingException {
        return this.printText(text, textSize, textColor, textReverseColor, textBold, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textColor, byte[] textReverseColor, byte[] textBold, byte[] textUnderline) throws EscPosEncodingException {
        return this.printText(text, textSize, textColor, textReverseColor, textBold, textUnderline, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textColor, byte[] textReverseColor, byte[] textBold, byte[] textUnderline, byte[] textDoubleStrike) throws EscPosEncodingException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        if (textSize == null) {
            textSize = TEXT_SIZE_NORMAL;
        }
        if (textColor == null) {
            textColor = TEXT_COLOR_BLACK;
        }
        if (textReverseColor == null) {
            textReverseColor = TEXT_COLOR_REVERSE_OFF;
        }
        if (textBold == null) {
            textBold = TEXT_WEIGHT_NORMAL;
        }
        if (textUnderline == null) {
            textUnderline = TEXT_UNDERLINE_OFF;
        }
        if (textDoubleStrike == null) {
            textDoubleStrike = TEXT_DOUBLE_STRIKE_OFF;
        }
        try {
            byte[] textBytes = text.getBytes(this.charsetEncoding.getName());
            this.printerConnection.write(this.charsetEncoding.getCommand());
            if (!Arrays.equals(this.currentTextSize, textSize)) {
                this.printerConnection.write(textSize);
                this.currentTextSize = textSize;
            }
            if (!Arrays.equals(this.currentTextDoubleStrike, textDoubleStrike)) {
                this.printerConnection.write(textDoubleStrike);
                this.currentTextDoubleStrike = textDoubleStrike;
            }
            if (!Arrays.equals(this.currentTextUnderline, textUnderline)) {
                this.printerConnection.write(textUnderline);
                this.currentTextUnderline = textUnderline;
            }
            if (!Arrays.equals(this.currentTextBold, textBold)) {
                this.printerConnection.write(textBold);
                this.currentTextBold = textBold;
            }
            if (!Arrays.equals(this.currentTextColor, textColor)) {
                this.printerConnection.write(textColor);
                this.currentTextColor = textColor;
            }
            if (!Arrays.equals(this.currentTextReverseColor, textReverseColor)) {
                this.printerConnection.write(textReverseColor);
                this.currentTextReverseColor = textReverseColor;
            }
            this.printerConnection.write(textBytes);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new EscPosEncodingException(e.getMessage());
        }
        return this;
    }

    public EscPosPrinterCommands printAllCharsetsEncodingCharacters() {
        for (int charsetId = 0; charsetId < 256; ++charsetId) {
            this.printCharsetEncodingCharacters(charsetId);
        }
        return this;
    }

    public EscPosPrinterCommands printCharsetsEncodingCharacters(int[] charsetsId) {
        for (int charsetId : charsetsId) {
            this.printCharsetEncodingCharacters(charsetId);
        }
        return this;
    }

    public EscPosPrinterCommands printCharsetEncodingCharacters(int charsetId) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        try {
            this.printerConnection.write(new byte[]{27, 116, (byte)charsetId});
            this.printerConnection.write(TEXT_SIZE_NORMAL);
            this.printerConnection.write(TEXT_COLOR_BLACK);
            this.printerConnection.write(TEXT_COLOR_REVERSE_OFF);
            this.printerConnection.write(TEXT_WEIGHT_NORMAL);
            this.printerConnection.write(TEXT_UNDERLINE_OFF);
            this.printerConnection.write(TEXT_DOUBLE_STRIKE_OFF);
            this.printerConnection.write((":::: Charset n\u00b0" + charsetId + " : ").getBytes());
            this.printerConnection.write(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1});
            this.printerConnection.write(new byte[]{10, 10, 10, 10});
            this.printerConnection.send();
        }
        catch (EscPosConnectionException e) {
            e.printStackTrace();
        }
        return this;
    }

    public EscPosPrinterCommands useEscAsteriskCommand(boolean enable) {
        this.useEscAsteriskCommand = enable;
        return this;
    }

    public EscPosPrinterCommands printImage(byte[] image) throws EscPosConnectionException {
        Object bytesToPrint;
        Object object;
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        if (this.useEscAsteriskCommand) {
            object = EscPosPrinterCommands.convertGSv0ToEscAsterisk(image);
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = image;
        }
        for (byte[] bytes : bytesToPrint = object) {
            this.printerConnection.write(bytes);
            this.printerConnection.send();
        }
        return this;
    }

    public EscPosPrinterCommands printBarcode(Barcode barcode) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        String code = barcode.getCode();
        int barcodeLength = barcode.getCodeLength();
        byte[] barcodeCommand = new byte[barcodeLength + 4];
        System.arraycopy(new byte[]{29, 107, (byte)barcode.getBarcodeType(), (byte)barcodeLength}, 0, barcodeCommand, 0, 4);
        for (int i = 0; i < barcodeLength; ++i) {
            barcodeCommand[i + 4] = (byte)code.charAt(i);
        }
        this.printerConnection.write(new byte[]{29, 72, (byte)barcode.getTextPosition()});
        this.printerConnection.write(new byte[]{29, 119, (byte)barcode.getColWidth()});
        this.printerConnection.write(new byte[]{29, 104, (byte)barcode.getHeight()});
        this.printerConnection.write(barcodeCommand);
        return this;
    }

    public EscPosPrinterCommands printQRCode(int qrCodeType, String text, int size) throws EscPosEncodingException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        if (size < 1) {
            size = 1;
        } else if (size > 16) {
            size = 16;
        }
        try {
            byte[] textBytes = text.getBytes("UTF-8");
            int commandLength = textBytes.length + 3;
            int pL = commandLength % 256;
            int pH = commandLength / 256;
            this.printerConnection.write(new byte[]{29, 40, 107, 4, 0, 49, 65, (byte)qrCodeType, 0});
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 67, (byte)size});
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 69, 48});
            byte[] qrCodeCommand = new byte[textBytes.length + 8];
            System.arraycopy(new byte[]{29, 40, 107, (byte)pL, (byte)pH, 49, 80, 48}, 0, qrCodeCommand, 0, 8);
            System.arraycopy(textBytes, 0, qrCodeCommand, 8, textBytes.length);
            this.printerConnection.write(qrCodeCommand);
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 81, 48});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new EscPosEncodingException(e.getMessage());
        }
        return this;
    }

    public EscPosPrinterCommands newLine() throws EscPosConnectionException {
        return this.newLine(null);
    }

    public EscPosPrinterCommands newLine(byte[] align) throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(new byte[]{10});
        this.printerConnection.send();
        if (align != null) {
            this.printerConnection.write(align);
        }
        return this;
    }

    public EscPosPrinterCommands feedPaper(int dots) throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        if (dots > 0) {
            this.printerConnection.write(new byte[]{27, 74, (byte)dots});
            this.printerConnection.send(dots);
        }
        return this;
    }

    public EscPosPrinterCommands cutPaper() throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(new byte[]{29, 86, 1});
        this.printerConnection.send(100);
        return this;
    }

    public EscPosPrinterCommands openCashBox() throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(new byte[]{27, 112, 0, 60, -1});
        this.printerConnection.send(100);
        return this;
    }

    public EscPosCharsetEncoding getCharsetEncoding() {
        return this.charsetEncoding;
    }
}

