/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter.connection.usb;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import androidx.annotation.Nullable;
import com.dantsu.escposprinter.connection.usb.UsbConnection;
import com.dantsu.escposprinter.connection.usb.UsbConnections;
import com.dantsu.escposprinter.connection.usb.UsbDeviceHelper;

public class UsbPrintersConnections
extends UsbConnections {
    public UsbPrintersConnections(Context context) {
        super(context);
    }

    @Nullable
    public static UsbConnection selectFirstConnected(Context context) {
        UsbPrintersConnections printers = new UsbPrintersConnections(context);
        UsbConnection[] bluetoothPrinters = printers.getList();
        if (bluetoothPrinters == null || bluetoothPrinters.length == 0) {
            return null;
        }
        return bluetoothPrinters[0];
    }

    @Override
    @Nullable
    public UsbConnection[] getList() {
        UsbConnection[] usbConnections = super.getList();
        if (usbConnections == null) {
            return null;
        }
        int i = 0;
        UsbConnection[] printersTmp = new UsbConnection[usbConnections.length];
        for (UsbConnection usbConnection : usbConnections) {
            UsbDevice device = usbConnection.getDevice();
            int usbClass = device.getDeviceClass();
            if (usbClass == 0 && UsbDeviceHelper.findPrinterInterface(device) != null) {
                usbClass = 7;
            }
            if (usbClass != 7) continue;
            printersTmp[i++] = new UsbConnection(this.usbManager, device);
        }
        UsbConnection[] usbPrinters = new UsbConnection[i];
        System.arraycopy(printersTmp, 0, usbPrinters, 0, i);
        return usbPrinters;
    }
}

