/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter.textparser;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.dantsu.escposprinter.EscPosPrinter;
import com.dantsu.escposprinter.EscPosPrinterCommands;
import com.dantsu.escposprinter.EscPosPrinterSize;
import com.dantsu.escposprinter.textparser.IPrinterTextParserElement;
import com.dantsu.escposprinter.textparser.PrinterTextParserColumn;

public class PrinterTextParserImg
implements IPrinterTextParserElement {
    private int length;
    private byte[] image;

    public static String bitmapToHexadecimalString(EscPosPrinterSize printerSize, Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return PrinterTextParserImg.bitmapToHexadecimalString(printerSize, (BitmapDrawable)drawable);
        }
        return "";
    }

    public static String bitmapToHexadecimalString(EscPosPrinterSize printerSize, BitmapDrawable bitmapDrawable) {
        return PrinterTextParserImg.bitmapToHexadecimalString(printerSize, bitmapDrawable.getBitmap());
    }

    public static String bitmapToHexadecimalString(EscPosPrinterSize printerSize, Bitmap bitmap) {
        return PrinterTextParserImg.bytesToHexadecimalString(printerSize.bitmapToBytes(bitmap));
    }

    public static String bytesToHexadecimalString(byte[] bytes) {
        StringBuilder imageHexString = new StringBuilder();
        for (byte aByte : bytes) {
            String hexString = Integer.toHexString(aByte & 0xFF);
            if (hexString.length() == 1) {
                hexString = "0" + hexString;
            }
            imageHexString.append(hexString);
        }
        return imageHexString.toString();
    }

    public static byte[] hexadecimalStringToBytes(String hexString) throws NumberFormatException {
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int pos = i * 2;
            bytes[i] = (byte)Integer.parseInt(hexString.substring(pos, pos + 2), 16);
        }
        return bytes;
    }

    public PrinterTextParserImg(PrinterTextParserColumn printerTextParserColumn, String textAlign, String hexadecimalString) {
        this(printerTextParserColumn, textAlign, PrinterTextParserImg.hexadecimalStringToBytes(hexadecimalString));
    }

    public PrinterTextParserImg(PrinterTextParserColumn printerTextParserColumn, String textAlign, byte[] image) {
        EscPosPrinter printer = printerTextParserColumn.getLine().getTextParser().getPrinter();
        int byteWidth = (image[4] & 0xFF) + (image[5] & 0xFF) * 256;
        int width = byteWidth * 8;
        int height = (image[6] & 0xFF) + (image[7] & 0xFF) * 256;
        int nbrByteDiff = (int)Math.floor((float)(printer.getPrinterWidthPx() - width) / 8.0f);
        int nbrWhiteByteToInsert = 0;
        switch (textAlign) {
            case "C": {
                nbrWhiteByteToInsert = Math.round((float)nbrByteDiff / 2.0f);
                break;
            }
            case "R": {
                nbrWhiteByteToInsert = nbrByteDiff;
            }
        }
        if (nbrWhiteByteToInsert > 0) {
            int newByteWidth = byteWidth + nbrWhiteByteToInsert;
            byte[] newImage = EscPosPrinterCommands.initImageCommand(newByteWidth, height);
            for (int i = 0; i < height; ++i) {
                System.arraycopy(image, byteWidth * i + 8, newImage, newByteWidth * i + nbrWhiteByteToInsert + 8, byteWidth);
            }
            image = newImage;
        }
        this.length = (int)Math.ceil((float)byteWidth * 8.0f / (float)printer.getPrinterCharSizeWidthPx());
        this.image = image;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public PrinterTextParserImg print(EscPosPrinterCommands printerSocket) {
        printerSocket.printImage(this.image);
        return this;
    }
}

