/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter.textparser;

import com.dantsu.escposprinter.EscPosPrinter;
import com.dantsu.escposprinter.EscPosPrinterCommands;
import com.dantsu.escposprinter.exceptions.EscPosBarcodeException;
import com.dantsu.escposprinter.exceptions.EscPosParserException;
import com.dantsu.escposprinter.textparser.PrinterTextParserColumn;
import com.dantsu.escposprinter.textparser.PrinterTextParserImg;
import java.util.Hashtable;

public class PrinterTextParserQRCode
extends PrinterTextParserImg {
    private static byte[] initConstructor(PrinterTextParserColumn printerTextParserColumn, Hashtable<String, String> qrCodeAttributes, String data) throws EscPosParserException, EscPosBarcodeException {
        EscPosPrinter printer = printerTextParserColumn.getLine().getTextParser().getPrinter();
        data = data.trim();
        int size = printer.mmToPx(20.0f);
        if (qrCodeAttributes.containsKey("size")) {
            String qrCodeAttribute = qrCodeAttributes.get("size");
            if (qrCodeAttribute == null) {
                throw new EscPosParserException("Invalid QR code attribute : size");
            }
            try {
                size = printer.mmToPx(Float.parseFloat(qrCodeAttribute));
            }
            catch (NumberFormatException nfe) {
                throw new EscPosParserException("Invalid QR code size value");
            }
        }
        return EscPosPrinterCommands.QRCodeDataToBytes(data, size);
    }

    public PrinterTextParserQRCode(PrinterTextParserColumn printerTextParserColumn, String textAlign, Hashtable<String, String> qrCodeAttributes, String data) throws EscPosParserException, EscPosBarcodeException {
        super(printerTextParserColumn, textAlign, PrinterTextParserQRCode.initConstructor(printerTextParserColumn, qrCodeAttributes, data));
    }
}

