/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter;

import android.graphics.Bitmap;
import com.dantsu.escposprinter.EscPosCharsetEncoding;
import com.dantsu.escposprinter.barcode.Barcode;
import com.dantsu.escposprinter.connection.DeviceConnection;
import com.dantsu.escposprinter.exceptions.EscPosBarcodeException;
import com.dantsu.escposprinter.exceptions.EscPosConnectionException;
import com.dantsu.escposprinter.exceptions.EscPosEncodingException;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.EnumMap;

public class EscPosPrinterCommands {
    public static final byte LF = 10;
    public static final byte[] RESET_PRINTER = new byte[]{27, 64};
    public static final byte[] TEXT_ALIGN_LEFT = new byte[]{27, 97, 0};
    public static final byte[] TEXT_ALIGN_CENTER = new byte[]{27, 97, 1};
    public static final byte[] TEXT_ALIGN_RIGHT = new byte[]{27, 97, 2};
    public static final byte[] TEXT_WEIGHT_NORMAL = new byte[]{27, 69, 0};
    public static final byte[] TEXT_WEIGHT_BOLD = new byte[]{27, 69, 1};
    public static final byte[] TEXT_FONT_A = new byte[]{27, 77, 0};
    public static final byte[] TEXT_FONT_B = new byte[]{27, 77, 1};
    public static final byte[] TEXT_FONT_C = new byte[]{27, 77, 2};
    public static final byte[] TEXT_FONT_D = new byte[]{27, 77, 3};
    public static final byte[] TEXT_FONT_E = new byte[]{27, 77, 4};
    public static final byte[] TEXT_SIZE_NORMAL = new byte[]{29, 33, 0};
    public static final byte[] TEXT_SIZE_DOUBLE_HEIGHT = new byte[]{29, 33, 1};
    public static final byte[] TEXT_SIZE_DOUBLE_WIDTH = new byte[]{29, 33, 16};
    public static final byte[] TEXT_SIZE_BIG = new byte[]{29, 33, 17};
    public static final byte[] TEXT_UNDERLINE_OFF = new byte[]{27, 45, 0};
    public static final byte[] TEXT_UNDERLINE_ON = new byte[]{27, 45, 1};
    public static final byte[] TEXT_UNDERLINE_LARGE = new byte[]{27, 45, 2};
    public static final byte[] TEXT_DOUBLE_STRIKE_OFF = new byte[]{27, 71, 0};
    public static final byte[] TEXT_DOUBLE_STRIKE_ON = new byte[]{27, 71, 1};
    public static final byte[] TEXT_COLOR_BLACK = new byte[]{27, 114, 0};
    public static final byte[] TEXT_COLOR_RED = new byte[]{27, 114, 1};
    public static final byte[] TEXT_COLOR_REVERSE_OFF = new byte[]{29, 66, 0};
    public static final byte[] TEXT_COLOR_REVERSE_ON = new byte[]{29, 66, 1};
    public static final int BARCODE_TYPE_UPCA = 65;
    public static final int BARCODE_TYPE_UPCE = 66;
    public static final int BARCODE_TYPE_EAN13 = 67;
    public static final int BARCODE_TYPE_EAN8 = 68;
    public static final int BARCODE_TYPE_ITF = 70;
    public static final int BARCODE_TYPE_128 = 73;
    public static final int BARCODE_TEXT_POSITION_NONE = 0;
    public static final int BARCODE_TEXT_POSITION_ABOVE = 1;
    public static final int BARCODE_TEXT_POSITION_BELOW = 2;
    public static final int QRCODE_1 = 49;
    public static final int QRCODE_2 = 50;
    private DeviceConnection printerConnection;
    private EscPosCharsetEncoding charsetEncoding;
    private byte[] currentTextSize = new byte[0];
    private byte[] currentTextColor = new byte[0];
    private byte[] currentTextReverseColor = new byte[0];
    private byte[] currentTextBold = new byte[0];
    private byte[] currentTextUnderline = new byte[0];
    private byte[] currentTextDoubleStrike = new byte[0];

    public static byte[] initImageCommand(int bytesByLine, int bitmapHeight) {
        int xH = bytesByLine / 256;
        int xL = bytesByLine - xH * 256;
        int yH = bitmapHeight / 256;
        int yL = bitmapHeight - yH * 256;
        byte[] imageBytes = new byte[8 + bytesByLine * bitmapHeight];
        System.arraycopy(new byte[]{29, 118, 48, 0, (byte)xL, (byte)xH, (byte)yL, (byte)yH}, 0, imageBytes, 0, 8);
        return imageBytes;
    }

    public static byte[] bitmapToBytes(Bitmap bitmap) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int bytesByLine = (int)Math.ceil((float)bitmapWidth / 8.0f);
        byte[] imageBytes = EscPosPrinterCommands.initImageCommand(bytesByLine, bitmapHeight);
        int i = 8;
        for (int posY = 0; posY < bitmapHeight; ++posY) {
            for (int j = 0; j < bitmapWidth; j += 8) {
                StringBuilder stringBinary = new StringBuilder();
                for (int k = 0; k < 8; ++k) {
                    int posX = j + k;
                    if (posX < bitmapWidth) {
                        int color = bitmap.getPixel(posX, posY);
                        int r = color >> 16 & 0xFF;
                        int g = color >> 8 & 0xFF;
                        int b = color & 0xFF;
                        if (r > 160 && g > 160 && b > 160) {
                            stringBinary.append("0");
                            continue;
                        }
                        stringBinary.append("1");
                        continue;
                    }
                    stringBinary.append("0");
                }
                imageBytes[i++] = (byte)Integer.parseInt(stringBinary.toString(), 2);
            }
        }
        return imageBytes;
    }

    public static byte[] QRCodeDataToBytes(String data, int size) throws EscPosBarcodeException {
        ByteMatrix byteMatrix = null;
        try {
            EnumMap<EncodeHintType, String> hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            QRCode code = Encoder.encode((String)data, (ErrorCorrectionLevel)ErrorCorrectionLevel.L, hints);
            byteMatrix = code.getMatrix();
        }
        catch (WriterException e) {
            e.printStackTrace();
            throw new EscPosBarcodeException("Unable to encode QR code");
        }
        if (byteMatrix == null) {
            return EscPosPrinterCommands.initImageCommand(0, 0);
        }
        int width = byteMatrix.getWidth();
        int height = byteMatrix.getHeight();
        int coefficient = Math.round((float)size / (float)width);
        int imageWidth = width * coefficient;
        int imageHeight = height * coefficient;
        int bytesByLine = (int)Math.ceil((float)imageWidth / 8.0f);
        int i = 8;
        if (coefficient < 1) {
            return EscPosPrinterCommands.initImageCommand(0, 0);
        }
        byte[] imageBytes = EscPosPrinterCommands.initImageCommand(bytesByLine, imageHeight);
        for (int y = 0; y < height; ++y) {
            byte[] lineBytes = new byte[bytesByLine];
            int x = -1;
            int multipleX = coefficient;
            boolean isBlack = false;
            for (int j = 0; j < bytesByLine; ++j) {
                StringBuilder stringBinary = new StringBuilder();
                for (int k = 0; k < 8; ++k) {
                    if (multipleX == coefficient) {
                        isBlack = ++x < width && byteMatrix.get(x, y) == 1;
                        multipleX = 0;
                    }
                    stringBinary.append(isBlack ? "1" : "0");
                    ++multipleX;
                }
                lineBytes[j] = (byte)Integer.parseInt(stringBinary.toString(), 2);
            }
            for (int multipleY = 0; multipleY < coefficient; ++multipleY) {
                System.arraycopy(lineBytes, 0, imageBytes, i, lineBytes.length);
                i += lineBytes.length;
            }
        }
        return imageBytes;
    }

    public EscPosPrinterCommands(DeviceConnection printerConnection) {
        this(printerConnection, null);
    }

    public EscPosPrinterCommands(DeviceConnection printerConnection, EscPosCharsetEncoding charsetEncoding) {
        this.printerConnection = printerConnection;
        this.charsetEncoding = charsetEncoding != null ? charsetEncoding : new EscPosCharsetEncoding("windows-1252", 6);
    }

    public EscPosPrinterCommands connect() throws EscPosConnectionException {
        this.printerConnection.connect();
        return this;
    }

    public void disconnect() {
        this.printerConnection.disconnect();
    }

    public void reset() {
        this.printerConnection.write(RESET_PRINTER);
    }

    public EscPosPrinterCommands setAlign(byte[] align) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(align);
        return this;
    }

    public EscPosPrinterCommands printText(String text) throws EscPosEncodingException {
        return this.printText(text, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize) throws EscPosEncodingException {
        return this.printText(text, textSize, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textColor) throws EscPosEncodingException {
        return this.printText(text, textSize, textColor, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textColor, byte[] textReverseColor) throws EscPosEncodingException {
        return this.printText(text, textSize, textColor, textReverseColor, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textColor, byte[] textReverseColor, byte[] textBold) throws EscPosEncodingException {
        return this.printText(text, textSize, textColor, textReverseColor, textBold, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textColor, byte[] textReverseColor, byte[] textBold, byte[] textUnderline) throws EscPosEncodingException {
        return this.printText(text, textSize, textColor, textReverseColor, textBold, textUnderline, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textColor, byte[] textReverseColor, byte[] textBold, byte[] textUnderline, byte[] textDoubleStrike) throws EscPosEncodingException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        if (textSize == null) {
            textSize = TEXT_SIZE_NORMAL;
        }
        if (textColor == null) {
            textColor = TEXT_COLOR_BLACK;
        }
        if (textReverseColor == null) {
            textReverseColor = TEXT_COLOR_REVERSE_OFF;
        }
        if (textBold == null) {
            textBold = TEXT_WEIGHT_NORMAL;
        }
        if (textUnderline == null) {
            textUnderline = TEXT_UNDERLINE_OFF;
        }
        if (textDoubleStrike == null) {
            textDoubleStrike = TEXT_DOUBLE_STRIKE_OFF;
        }
        try {
            byte[] textBytes = text.getBytes(this.charsetEncoding.getName());
            this.printerConnection.write(this.charsetEncoding.getCommand());
            if (!Arrays.equals(this.currentTextSize, textSize)) {
                this.printerConnection.write(textSize);
                this.currentTextSize = textSize;
            }
            if (!Arrays.equals(this.currentTextDoubleStrike, textDoubleStrike)) {
                this.printerConnection.write(textDoubleStrike);
                this.currentTextDoubleStrike = textDoubleStrike;
            }
            if (!Arrays.equals(this.currentTextUnderline, textUnderline)) {
                this.printerConnection.write(textUnderline);
                this.currentTextUnderline = textUnderline;
            }
            if (!Arrays.equals(this.currentTextBold, textBold)) {
                this.printerConnection.write(textBold);
                this.currentTextBold = textBold;
            }
            if (!Arrays.equals(this.currentTextColor, textColor)) {
                this.printerConnection.write(textColor);
                this.currentTextColor = textColor;
            }
            if (!Arrays.equals(this.currentTextReverseColor, textReverseColor)) {
                this.printerConnection.write(textReverseColor);
                this.currentTextReverseColor = textReverseColor;
            }
            this.printerConnection.write(textBytes);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new EscPosEncodingException(e.getMessage());
        }
        return this;
    }

    public EscPosPrinterCommands printImage(byte[] image) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(image);
        return this;
    }

    public EscPosPrinterCommands printBarcode(Barcode barcode) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        String code = barcode.getCode();
        int barcodeLength = barcode.getCodeLength();
        byte[] barcodeCommand = new byte[barcodeLength + 4];
        System.arraycopy(new byte[]{29, 107, (byte)barcode.getBarcodeType(), (byte)barcodeLength}, 0, barcodeCommand, 0, 4);
        for (int i = 0; i < barcodeLength; ++i) {
            barcodeCommand[i + 4] = (byte)code.charAt(i);
        }
        this.printerConnection.write(new byte[]{29, 72, (byte)barcode.getTextPosition()});
        this.printerConnection.write(new byte[]{29, 119, (byte)barcode.getColWidth()});
        this.printerConnection.write(new byte[]{29, 104, (byte)barcode.getHeight()});
        this.printerConnection.write(barcodeCommand);
        return this;
    }

    public EscPosPrinterCommands printQRCode(int qrCodeType, String text, int size) throws EscPosEncodingException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        if (size < 1) {
            size = 1;
        } else if (size > 16) {
            size = 16;
        }
        try {
            byte[] textBytes = text.getBytes("UTF-8");
            int commandLength = textBytes.length + 3;
            int pL = commandLength % 256;
            int pH = commandLength / 256;
            this.printerConnection.write(new byte[]{29, 40, 107, 4, 0, 49, 65, (byte)qrCodeType, 0});
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 67, (byte)size});
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 69, 48});
            byte[] qrCodeCommand = new byte[textBytes.length + 8];
            System.arraycopy(new byte[]{29, 40, 107, (byte)pL, (byte)pH, 49, 80, 48}, 0, qrCodeCommand, 0, 8);
            System.arraycopy(textBytes, 0, qrCodeCommand, 8, textBytes.length);
            this.printerConnection.write(qrCodeCommand);
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 81, 48});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new EscPosEncodingException(e.getMessage());
        }
        return this;
    }

    public EscPosPrinterCommands newLine() throws EscPosConnectionException {
        return this.newLine(null);
    }

    public EscPosPrinterCommands newLine(byte[] align) throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(new byte[]{10});
        this.printerConnection.send();
        if (align != null) {
            this.printerConnection.write(align);
        }
        return this;
    }

    public EscPosPrinterCommands feedPaper(int dots) throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        if (dots > 0) {
            this.printerConnection.write(new byte[]{27, 74, (byte)dots});
            this.printerConnection.send(dots);
        }
        return this;
    }

    public EscPosPrinterCommands cutPaper() throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(new byte[]{29, 86, 1});
        this.printerConnection.send(100);
        return this;
    }

    public EscPosPrinterCommands openCashBox() throws EscPosConnectionException {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(new byte[]{27, 112, 0, 60, -1});
        this.printerConnection.send(100);
        return this;
    }

    public EscPosCharsetEncoding getCharsetEncoding() {
        return this.charsetEncoding;
    }
}

