/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter.connection.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import com.dantsu.escposprinter.connection.DeviceConnection;
import java.io.IOException;

public class BluetoothConnection
extends DeviceConnection {
    private BluetoothDevice device;
    private BluetoothSocket socket = null;

    public BluetoothConnection(BluetoothDevice device) {
        this.device = device;
    }

    public BluetoothDevice getDevice() {
        return this.device;
    }

    @Override
    public boolean connect() {
        if (this.isConnected()) {
            return true;
        }
        try {
            this.socket = this.device.createRfcommSocketToServiceRecord(this.device.getUuids()[0].getUuid());
            this.socket.connect();
            this.stream = this.socket.getOutputStream();
            this.data = new byte[0];
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.disconnect();
            this.socket = null;
            this.stream = null;
            return false;
        }
    }

    @Override
    public boolean disconnect() {
        this.data = new byte[0];
        if (this.stream != null) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

