/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter;

import android.graphics.Bitmap;
import com.dantsu.escposprinter.connection.DeviceConnection;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.EnumMap;

public class EscPosPrinterCommands {
    public static final byte[] WESTERN_EUROPE_ENCODING = new byte[]{27, 116, 6};
    public static final byte LF = 10;
    public static final byte[] TEXT_ALIGN_LEFT = new byte[]{27, 97, 0};
    public static final byte[] TEXT_ALIGN_CENTER = new byte[]{27, 97, 1};
    public static final byte[] TEXT_ALIGN_RIGHT = new byte[]{27, 97, 2};
    public static final byte[] TEXT_WEIGHT_NORMAL = new byte[]{27, 69, 0};
    public static final byte[] TEXT_WEIGHT_BOLD = new byte[]{27, 69, 1};
    public static final byte[] TEXT_SIZE_NORMAL = new byte[]{27, 33, 3};
    public static final byte[] TEXT_SIZE_MEDIUM = new byte[]{27, 33, 8};
    public static final byte[] TEXT_SIZE_DOUBLE_HEIGHT = new byte[]{27, 33, 16};
    public static final byte[] TEXT_SIZE_DOUBLE_WIDTH = new byte[]{27, 33, 32};
    public static final byte[] TEXT_SIZE_BIG = new byte[]{27, 33, 48};
    public static final byte[] TEXT_UNDERLINE_OFF = new byte[]{27, 45, 0};
    public static final byte[] TEXT_UNDERLINE_ON = new byte[]{27, 45, 1};
    public static final byte[] TEXT_UNDERLINE_LARGE = new byte[]{27, 45, 2};
    public static final byte[] TEXT_DOUBLE_STRIKE_OFF = new byte[]{27, 71, 0};
    public static final byte[] TEXT_DOUBLE_STRIKE_ON = new byte[]{27, 71, 1};
    public static final int BARCODE_UPCA = 0;
    public static final int BARCODE_UPCE = 1;
    public static final int BARCODE_EAN13 = 2;
    public static final int BARCODE_EAN8 = 3;
    public static final int BARCODE_ITF = 5;
    public static final int QRCODE_1 = 49;
    public static final int QRCODE_2 = 50;
    private DeviceConnection printerConnection;

    private static byte[] initImageCommand(int bytesByLine, int bitmapHeight) {
        byte[] imageBytes = new byte[8 + bytesByLine * bitmapHeight];
        System.arraycopy(new byte[]{29, 118, 48, 0, (byte)bytesByLine, 0, (byte)bitmapHeight, 0}, 0, imageBytes, 0, 8);
        return imageBytes;
    }

    public static byte[] bitmapToBytes(Bitmap bitmap) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int bytesByLine = (int)Math.ceil((float)bitmapWidth / 8.0f);
        byte[] imageBytes = EscPosPrinterCommands.initImageCommand(bytesByLine, bitmapHeight);
        int i = 8;
        for (int posY = 0; posY < bitmapHeight; ++posY) {
            for (int j = 0; j < bitmapWidth; j += 8) {
                StringBuilder stringBinary = new StringBuilder();
                for (int k = 0; k < 8; ++k) {
                    int posX = j + k;
                    if (posX < bitmapWidth) {
                        int color = bitmap.getPixel(posX, posY);
                        int r = color >> 16 & 0xFF;
                        int g = color >> 8 & 0xFF;
                        int b = color & 0xFF;
                        if (r > 160 && g > 160 && b > 160) {
                            stringBinary.append("0");
                            continue;
                        }
                        stringBinary.append("1");
                        continue;
                    }
                    stringBinary.append("0");
                }
                imageBytes[i++] = (byte)Integer.parseInt(stringBinary.toString(), 2);
            }
        }
        return imageBytes;
    }

    public static byte[] QRCodeDataToBytes(String data, int size) {
        ByteMatrix byteMatrix = null;
        try {
            EnumMap<EncodeHintType, String> hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            QRCode code = Encoder.encode((String)data, (ErrorCorrectionLevel)ErrorCorrectionLevel.L, hints);
            byteMatrix = code.getMatrix();
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        if (byteMatrix == null) {
            return EscPosPrinterCommands.initImageCommand(0, 0);
        }
        int width = byteMatrix.getWidth();
        int height = byteMatrix.getHeight();
        int coefficient = Math.round((float)size / (float)width);
        int imageWidth = width * coefficient;
        int imageHeight = height * coefficient;
        int bytesByLine = (int)Math.ceil((float)imageWidth / 8.0f);
        int i = 8;
        if (coefficient < 1) {
            return EscPosPrinterCommands.initImageCommand(0, 0);
        }
        byte[] imageBytes = EscPosPrinterCommands.initImageCommand(bytesByLine, imageHeight);
        for (int y = 0; y < height; ++y) {
            byte[] lineBytes = new byte[bytesByLine];
            int j = 0;
            int multipleX = coefficient;
            boolean isBlack = false;
            int x = -1;
            while (x < width) {
                StringBuilder stringBinary = new StringBuilder();
                for (int k = 0; k < 8; ++k) {
                    if (multipleX == coefficient) {
                        isBlack = ++x < width && byteMatrix.get(x, y) == 1;
                        multipleX = 0;
                    }
                    stringBinary.append(isBlack ? "1" : "0");
                    ++multipleX;
                }
                lineBytes[j++] = (byte)Integer.parseInt(stringBinary.toString(), 2);
            }
            for (int multipleY = 0; multipleY < coefficient; ++multipleY) {
                System.arraycopy(lineBytes, 0, imageBytes, i, lineBytes.length);
                i += lineBytes.length;
            }
        }
        return imageBytes;
    }

    public EscPosPrinterCommands(DeviceConnection printerConnection) {
        this.printerConnection = printerConnection;
    }

    public boolean connect() {
        if (this.printerConnection.isConnected()) {
            return true;
        }
        return this.printerConnection.connect();
    }

    public boolean disconnect() {
        return this.printerConnection.disconnect();
    }

    public EscPosPrinterCommands setAlign(byte[] align) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(align);
        return this;
    }

    public EscPosPrinterCommands printText(String text) {
        return this.printText(text, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize) {
        return this.printText(text, textSize, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textBold) {
        return this.printText(text, textSize, textBold, null);
    }

    public EscPosPrinterCommands printText(String text, byte[] textSize, byte[] textBold, byte[] textUnderline) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        try {
            byte[] textBytes = text.getBytes("ISO-8859-1");
            this.printerConnection.write(WESTERN_EUROPE_ENCODING);
            this.printerConnection.write(TEXT_SIZE_NORMAL);
            this.printerConnection.write(TEXT_WEIGHT_NORMAL);
            this.printerConnection.write(TEXT_UNDERLINE_OFF);
            if (textSize != null) {
                this.printerConnection.write(textSize);
            }
            if (textBold != null) {
                this.printerConnection.write(textBold);
            }
            if (textUnderline != null) {
                this.printerConnection.write(textUnderline);
            }
            this.printerConnection.write(textBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public EscPosPrinterCommands printImage(byte[] image) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(image);
        return this;
    }

    public EscPosPrinterCommands printBarcode(int barcodeType, String barcode, int heightPx) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        int barcodeLength = 0;
        switch (barcodeType) {
            case 0: {
                barcodeLength = 11;
                break;
            }
            case 1: {
                barcodeLength = 6;
                break;
            }
            case 2: {
                barcodeLength = 12;
                break;
            }
            case 3: {
                barcodeLength = 7;
            }
        }
        if (barcodeLength == 0 || barcode.length() < barcodeLength) {
            return this;
        }
        barcode = barcode.substring(0, barcodeLength);
        try {
            switch (barcodeType) {
                case 1: {
                    String firstChar = barcode.substring(0, 1);
                    if (firstChar.equals("0") || firstChar.equals("1")) break;
                    barcode = "0" + barcode.substring(0, 5);
                    break;
                }
                case 0: 
                case 2: 
                case 3: {
                    int stringBarcodeLength = barcode.length();
                    int totalBarcodeKey = 0;
                    for (int i = 0; i < stringBarcodeLength; ++i) {
                        int pos = stringBarcodeLength - 1 - i;
                        int intCode = Integer.parseInt(barcode.substring(pos, pos + 1), 10);
                        if (i % 2 == 0) {
                            intCode = 3 * intCode;
                        }
                        totalBarcodeKey += intCode;
                    }
                    String barcodeKey = String.valueOf(10 - totalBarcodeKey % 10);
                    if (barcodeKey.length() == 2) {
                        barcodeKey = "0";
                    }
                    barcode = barcode + barcodeKey;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return this;
        }
        barcodeLength = barcode.length();
        byte[] barcodeCommand = new byte[barcodeLength + 4];
        System.arraycopy(new byte[]{29, 107, (byte)barcodeType}, 0, barcodeCommand, 0, 3);
        for (int i = 0; i < barcodeLength; ++i) {
            barcodeCommand[i + 3] = (byte)(Integer.parseInt(barcode.substring(i, i + 1), 10) + 48);
        }
        this.printerConnection.write(new byte[]{29, 104, (byte)heightPx});
        this.printerConnection.write(barcodeCommand);
        return this;
    }

    public EscPosPrinterCommands printQRCode(int qrCodeType, String text, int size) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        if (size < 1) {
            size = 1;
        } else if (size > 16) {
            size = 16;
        }
        try {
            this.printerConnection.write(WESTERN_EUROPE_ENCODING);
            byte[] textBytes = text.getBytes("ISO-8859-1");
            int commandLength = textBytes.length + 3;
            int pL = commandLength % 256;
            int pH = (int)Math.floor(commandLength / 256);
            this.printerConnection.write(new byte[]{29, 40, 107, 4, 0, 49, 65, (byte)qrCodeType, 0});
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 67, (byte)size});
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 69, 48});
            byte[] qrCodeCommand = new byte[textBytes.length + 8];
            System.arraycopy(new byte[]{29, 40, 107, (byte)pL, (byte)pH, 49, 80, 48}, 0, qrCodeCommand, 0, 8);
            System.arraycopy(textBytes, 0, qrCodeCommand, 8, textBytes.length);
            this.printerConnection.write(qrCodeCommand);
            this.printerConnection.write(new byte[]{29, 40, 107, 3, 0, 49, 81, 48});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this;
    }

    public EscPosPrinterCommands newLine() {
        return this.newLine(null);
    }

    public EscPosPrinterCommands newLine(byte[] align) {
        if (!this.printerConnection.isConnected()) {
            return this;
        }
        this.printerConnection.write(new byte[]{10});
        this.printerConnection.send();
        if (align != null) {
            this.printerConnection.write(align);
        }
        return this;
    }
}

