/*
 * Decompiled with CFR 0.152.
 */
package com.dantsu.escposprinter;

import android.graphics.Bitmap;
import com.dantsu.escposprinter.EscPosPrinterCommands;
import com.dantsu.escposprinter.connection.DeviceConnection;
import com.dantsu.escposprinter.textparser.IPrinterTextParserElement;
import com.dantsu.escposprinter.textparser.PrinterTextParser;
import com.dantsu.escposprinter.textparser.PrinterTextParserColumn;
import com.dantsu.escposprinter.textparser.PrinterTextParserLine;

public class EscPosPrinter {
    public static final float INCH_TO_MM = 25.4f;
    private int printerDpi;
    private float printingWidthMM;
    private int nbrCharactersPerLine;
    private int printingWidthPx;
    private int charSizeWidthPx;
    private EscPosPrinterCommands printer = null;

    public EscPosPrinter(DeviceConnection printerConnection, int printerDpi, float printingWidthMM, int nbrCharactersPerLine) {
        this(printerConnection != null ? new EscPosPrinterCommands(printerConnection) : null, printerDpi, printingWidthMM, nbrCharactersPerLine);
    }

    public EscPosPrinter(EscPosPrinterCommands printer, int printerDpi, float printingWidthMM, int nbrCharactersPerLine) {
        if (printer != null && printer.connect()) {
            this.printer = printer;
        }
        this.printerDpi = printerDpi;
        this.printingWidthMM = printingWidthMM;
        this.nbrCharactersPerLine = nbrCharactersPerLine;
        int printingWidthPx = this.mmToPx(this.printingWidthMM);
        this.printingWidthPx = printingWidthPx + printingWidthPx % 8;
        this.charSizeWidthPx = printingWidthPx / this.nbrCharactersPerLine;
    }

    public EscPosPrinter disconnectPrinter() {
        if (this.printer != null) {
            this.printer.disconnect();
            this.printer = null;
        }
        return this;
    }

    public int getNbrCharactersPerLine() {
        return this.nbrCharactersPerLine;
    }

    public float getPrintingWidthMM() {
        return this.printingWidthMM;
    }

    public int getPrinterDpi() {
        return this.printerDpi;
    }

    public int getPrintingWidthPx() {
        return this.printingWidthPx;
    }

    public int getCharSizeWidthPx() {
        return this.charSizeWidthPx;
    }

    public int mmToPx(float mmSize) {
        return Math.round(mmSize * (float)this.printerDpi / 25.4f);
    }

    public EscPosPrinter printFormattedText(String text) {
        PrinterTextParserLine[] linesParsed;
        if (this.printer == null || this.nbrCharactersPerLine == 0) {
            return this;
        }
        PrinterTextParser textParser = new PrinterTextParser(this);
        for (PrinterTextParserLine line : linesParsed = textParser.setFormattedText(text).parse()) {
            PrinterTextParserColumn[] columns;
            for (PrinterTextParserColumn column : columns = line.getColumns()) {
                IPrinterTextParserElement[] elements;
                for (IPrinterTextParserElement element : elements = column.getElements()) {
                    element.print(this.printer);
                }
            }
            this.printer.newLine();
        }
        this.printer.newLine().newLine().newLine().newLine();
        return this;
    }

    public byte[] bitmapToBytes(Bitmap bitmap) {
        boolean isSizeEdit = false;
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int maxWidth = this.getPrintingWidthPx();
        int maxHeight = 256;
        if (bitmapWidth > maxWidth) {
            bitmapHeight = Math.round((float)bitmapHeight * (float)maxWidth / (float)bitmapWidth);
            bitmapWidth = maxWidth;
            isSizeEdit = true;
        }
        if (bitmapHeight > maxHeight) {
            bitmapWidth = Math.round((float)bitmapWidth * (float)maxHeight / (float)bitmapHeight);
            bitmapHeight = maxHeight;
            isSizeEdit = true;
        }
        if (isSizeEdit) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmapWidth, (int)bitmapHeight, (boolean)false);
        }
        return EscPosPrinterCommands.bitmapToBytes(bitmap);
    }
}

