/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.PointF;
import android.view.animation.DecelerateInterpolator;
import android.widget.Scroller;
import com.github.barteksc.pdfviewer.PDFView;

class AnimationManager {
    private PDFView pdfView;
    private ValueAnimator animation;
    private Scroller scroller;
    private ValueAnimator flingAnimation;

    public AnimationManager(PDFView pdfView) {
        this.pdfView = pdfView;
        this.scroller = new Scroller(pdfView.getContext(), null, true);
    }

    public void startXAnimation(float xFrom, float xTo) {
        this.stopAll();
        this.animation = ValueAnimator.ofFloat((float[])new float[]{xFrom, xTo});
        this.animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new XAnimation());
        this.animation.setDuration(400L);
        this.animation.start();
    }

    public void startYAnimation(float yFrom, float yTo) {
        this.stopAll();
        this.animation = ValueAnimator.ofFloat((float[])new float[]{yFrom, yTo});
        this.animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new YAnimation());
        this.animation.setDuration(400L);
        this.animation.start();
    }

    public void startZoomAnimation(float centerX, float centerY, float zoomFrom, float zoomTo) {
        this.stopAll();
        this.animation = ValueAnimator.ofFloat((float[])new float[]{zoomFrom, zoomTo});
        this.animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        ZoomAnimation zoomAnim = new ZoomAnimation(centerX, centerY);
        this.animation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)zoomAnim);
        this.animation.addListener((Animator.AnimatorListener)zoomAnim);
        this.animation.setDuration(400L);
        this.animation.start();
    }

    public void startFlingAnimation(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        this.stopAll();
        this.flingAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        FlingAnimation flingAnim = new FlingAnimation();
        this.flingAnimation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)flingAnim);
        this.flingAnimation.addListener((Animator.AnimatorListener)flingAnim);
        this.scroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
        this.flingAnimation.setDuration((long)this.scroller.getDuration());
        this.flingAnimation.start();
    }

    public void stopAll() {
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        this.stopFling();
    }

    public void stopFling() {
        if (this.flingAnimation != null) {
            this.scroller.forceFinished(true);
            this.flingAnimation.cancel();
            this.flingAnimation = null;
        }
    }

    private void hideHandle() {
        if (this.pdfView.getScrollHandle() != null) {
            this.pdfView.getScrollHandle().hideDelayed();
        }
    }

    class FlingAnimation
    implements ValueAnimator.AnimatorUpdateListener,
    Animator.AnimatorListener {
        FlingAnimation() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            if (!AnimationManager.this.scroller.isFinished()) {
                AnimationManager.this.scroller.computeScrollOffset();
                AnimationManager.this.pdfView.moveTo(AnimationManager.this.scroller.getCurrX(), AnimationManager.this.scroller.getCurrY());
                AnimationManager.this.pdfView.loadPageByOffset();
            }
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            AnimationManager.this.pdfView.loadPages();
            AnimationManager.this.hideHandle();
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    class ZoomAnimation
    implements ValueAnimator.AnimatorUpdateListener,
    Animator.AnimatorListener {
        private final float centerX;
        private final float centerY;

        public ZoomAnimation(float centerX, float centerY) {
            this.centerX = centerX;
            this.centerY = centerY;
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float zoom = ((Float)animation.getAnimatedValue()).floatValue();
            AnimationManager.this.pdfView.zoomCenteredTo(zoom, new PointF(this.centerX, this.centerY));
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            AnimationManager.this.pdfView.loadPages();
            AnimationManager.this.hideHandle();
        }

        public void onAnimationRepeat(Animator animation) {
        }

        public void onAnimationStart(Animator animation) {
        }
    }

    class YAnimation
    implements ValueAnimator.AnimatorUpdateListener {
        YAnimation() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float offset = ((Float)animation.getAnimatedValue()).floatValue();
            AnimationManager.this.pdfView.moveTo(AnimationManager.this.pdfView.getCurrentXOffset(), offset);
        }
    }

    class XAnimation
    implements ValueAnimator.AnimatorUpdateListener {
        XAnimation() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float offset = ((Float)animation.getAnimatedValue()).floatValue();
            AnimationManager.this.pdfView.moveTo(offset, AnimationManager.this.pdfView.getCurrentYOffset());
        }
    }
}

