/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.support.annotation.LayoutRes;
import android.util.SparseArray;
import android.view.ViewGroup;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import java.util.List;

public abstract class BaseMultiItemQuickAdapter<T extends MultiItemEntity, K extends BaseViewHolder>
extends BaseQuickAdapter<T, K> {
    private SparseArray<Integer> layouts;
    private static final int DEFAULT_VIEW_TYPE = -255;

    public BaseMultiItemQuickAdapter(List<T> data) {
        super(data);
    }

    @Override
    protected int getDefItemViewType(int position) {
        Object item = this.mData.get(position);
        if (item instanceof MultiItemEntity) {
            return ((MultiItemEntity)item).getItemType();
        }
        return -255;
    }

    protected void setDefaultViewTypeLayout(@LayoutRes int layoutResId) {
        this.addItemType(-255, layoutResId);
    }

    @Override
    protected K onCreateDefViewHolder(ViewGroup parent, int viewType) {
        return this.createBaseViewHolder(parent, this.getLayoutId(viewType));
    }

    private int getLayoutId(int viewType) {
        return (Integer)this.layouts.get(viewType);
    }

    protected void addItemType(int type, @LayoutRes int layoutResId) {
        if (this.layouts == null) {
            this.layouts = new SparseArray();
        }
        this.layouts.put(type, (Object)layoutResId);
    }
}

