/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.MotionEvent;
import android.view.View;
import com.chad.library.R;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.listener.OnItemDragListener;
import com.chad.library.adapter.base.listener.OnItemSwipeListener;
import java.util.Collections;
import java.util.List;

public abstract class BaseItemDraggableAdapter<T>
extends BaseQuickAdapter<T> {
    private static final int NO_TOGGLE_VIEW = 0;
    protected int mToggleViewId = 0;
    protected ItemTouchHelper mItemTouchHelper;
    protected boolean itemDragEnabled = false;
    protected boolean itemSwipeEnabled = false;
    protected OnItemDragListener mOnItemDragListener;
    protected OnItemSwipeListener mOnItemSwipeListener;
    protected boolean mDragOnLongPress = true;
    protected View.OnTouchListener mOnToggleViewTouchListener;
    protected View.OnLongClickListener mOnToggleViewLongClickListener;
    private static final String ERROR_NOT_SAME_ITEMTOUCHHELPER = "Item drag and item swipe should pass the same ItemTouchHelper";

    public BaseItemDraggableAdapter(View contentView, List<T> data) {
        super(contentView, data);
    }

    public BaseItemDraggableAdapter(List<T> data) {
        super(data);
    }

    public BaseItemDraggableAdapter(int layoutResId, List<T> data) {
        super(layoutResId, data);
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int positions) {
        super.onBindViewHolder(holder, positions);
        int viewType = holder.getItemViewType();
        if (this.mItemTouchHelper != null && this.itemDragEnabled && viewType != 546 && viewType != 273 && viewType != 1365 && viewType != 819) {
            if (this.mToggleViewId != 0) {
                Object toggleView = ((BaseViewHolder)holder).getView(this.mToggleViewId);
                if (toggleView != null) {
                    toggleView.setTag(R.id.BaseQuickAdapter_viewholder_support, (Object)holder);
                    if (this.mDragOnLongPress) {
                        toggleView.setOnLongClickListener(this.mOnToggleViewLongClickListener);
                    } else {
                        toggleView.setOnTouchListener(this.mOnToggleViewTouchListener);
                    }
                }
            } else {
                holder.itemView.setTag(R.id.BaseQuickAdapter_viewholder_support, (Object)holder);
                holder.itemView.setOnLongClickListener(this.mOnToggleViewLongClickListener);
            }
        }
    }

    public void setToggleViewId(int toggleViewId) {
        this.mToggleViewId = toggleViewId;
    }

    public void setToggleDragOnLongPress(boolean longPress) {
        this.mDragOnLongPress = longPress;
        if (this.mDragOnLongPress) {
            this.mOnToggleViewTouchListener = null;
            this.mOnToggleViewLongClickListener = new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (BaseItemDraggableAdapter.this.mItemTouchHelper != null && BaseItemDraggableAdapter.this.itemDragEnabled) {
                        BaseItemDraggableAdapter.this.mItemTouchHelper.startDrag((RecyclerView.ViewHolder)v.getTag(R.id.BaseQuickAdapter_viewholder_support));
                    }
                    return true;
                }
            };
        } else {
            this.mOnToggleViewTouchListener = new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (MotionEventCompat.getActionMasked((MotionEvent)event) == 0 && !BaseItemDraggableAdapter.this.mDragOnLongPress) {
                        if (BaseItemDraggableAdapter.this.mItemTouchHelper != null && BaseItemDraggableAdapter.this.itemDragEnabled) {
                            BaseItemDraggableAdapter.this.mItemTouchHelper.startDrag((RecyclerView.ViewHolder)v.getTag(R.id.BaseQuickAdapter_viewholder_support));
                        }
                        return true;
                    }
                    return false;
                }
            };
            this.mOnToggleViewLongClickListener = null;
        }
    }

    public void enableDragItem(@NonNull ItemTouchHelper itemTouchHelper) {
        this.enableDragItem(itemTouchHelper, 0, true);
    }

    public void enableDragItem(@NonNull ItemTouchHelper itemTouchHelper, int toggleViewId, boolean dragOnLongPress) {
        this.itemDragEnabled = true;
        this.mItemTouchHelper = itemTouchHelper;
        this.setToggleViewId(toggleViewId);
        this.setToggleDragOnLongPress(dragOnLongPress);
    }

    public void disableDragItem() {
        this.itemDragEnabled = false;
        this.mItemTouchHelper = null;
    }

    public boolean isItemDraggable() {
        return this.itemDragEnabled;
    }

    public void enableSwipeItem() {
        this.itemSwipeEnabled = true;
    }

    public void disableSwipeItem() {
        this.itemSwipeEnabled = false;
    }

    public boolean isItemSwipeEnable() {
        return this.itemSwipeEnabled;
    }

    public void setOnItemDragListener(OnItemDragListener onItemDragListener) {
        this.mOnItemDragListener = onItemDragListener;
    }

    public int getViewHolderPosition(RecyclerView.ViewHolder viewHolder) {
        return viewHolder.getAdapterPosition() - this.getHeaderLayoutCount();
    }

    public void onItemDragStart(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemDragListener != null && this.itemDragEnabled) {
            this.mOnItemDragListener.onItemDragStart(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    public void onItemDragMoving(RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
        int to;
        int from = this.getViewHolderPosition(source);
        if (from < (to = this.getViewHolderPosition(target))) {
            for (int i = from; i < to; ++i) {
                Collections.swap(this.mData, i, i + 1);
            }
        } else {
            for (int i = from; i > to; --i) {
                Collections.swap(this.mData, i, i - 1);
            }
        }
        this.notifyItemMoved(source.getAdapterPosition(), target.getAdapterPosition());
        if (this.mOnItemDragListener != null && this.itemDragEnabled) {
            this.mOnItemDragListener.onItemDragMoving(source, from, target, to);
        }
    }

    public void onItemDragEnd(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemDragListener != null && this.itemDragEnabled) {
            this.mOnItemDragListener.onItemDragEnd(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    public void setOnItemSwipeListener(OnItemSwipeListener listener) {
        this.mOnItemSwipeListener = listener;
    }

    public void onItemSwipeStart(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.onItemSwipeStart(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    public void onItemSwipeClear(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.clearView(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    public void onItemSwiped(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.onItemSwiped(viewHolder, this.getViewHolderPosition(viewHolder));
        }
        int pos = this.getViewHolderPosition(viewHolder);
        this.mData.remove(pos);
        this.notifyItemRemoved(viewHolder.getAdapterPosition());
    }

    public void onItemSwiping(Canvas canvas, RecyclerView.ViewHolder viewHolder, float dX, float dY, boolean isCurrentlyActive) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.onItemSwipeMoving(canvas, viewHolder, dX, dY, isCurrentlyActive);
        }
    }
}

