/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import com.chad.library.R;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.animation.AlphaInAnimation;
import com.chad.library.adapter.base.animation.BaseAnimation;
import com.chad.library.adapter.base.animation.ScaleInAnimation;
import com.chad.library.adapter.base.animation.SlideInBottomAnimation;
import com.chad.library.adapter.base.animation.SlideInLeftAnimation;
import com.chad.library.adapter.base.animation.SlideInRightAnimation;
import com.chad.library.adapter.base.entity.IExpandable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseQuickAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private boolean mNextLoadEnable = false;
    private boolean mLoadingMoreEnable = false;
    private boolean mFirstOnlyEnable = true;
    private boolean mOpenAnimationEnable = false;
    private boolean mEmptyEnable;
    private boolean mHeadAndEmptyEnable;
    private boolean mFootAndEmptyEnable;
    private Interpolator mInterpolator = new LinearInterpolator();
    private int mDuration = 300;
    private int mLastPosition = -1;
    private RequestLoadMoreListener mRequestLoadMoreListener;
    private BaseAnimation mCustomAnimation;
    private BaseAnimation mSelectAnimation = new AlphaInAnimation();
    private LinearLayout mHeaderLayout;
    private LinearLayout mFooterLayout;
    private LinearLayout mCopyHeaderLayout = null;
    private LinearLayout mCopyFooterLayout = null;
    private int pageSize = -1;
    private View mContentView;
    private View mEmptyView;
    private View mCopyEmptyLayout;
    private View loadMoreFailedView;
    protected static final String TAG = BaseQuickAdapter.class.getSimpleName();
    protected Context mContext;
    protected int mLayoutResId;
    protected LayoutInflater mLayoutInflater;
    protected List<T> mData;
    public static final int HEADER_VIEW = 273;
    public static final int LOADING_VIEW = 546;
    public static final int FOOTER_VIEW = 819;
    public static final int EMPTY_VIEW = 1365;
    private View mLoadingView;
    public static final int ALPHAIN = 1;
    public static final int SCALEIN = 2;
    public static final int SLIDEIN_BOTTOM = 3;
    public static final int SLIDEIN_LEFT = 4;
    public static final int SLIDEIN_RIGHT = 5;
    private boolean flag = true;
    private SpanSizeLookup mSpanSizeLookup;

    public void setOnLoadMoreListener(RequestLoadMoreListener requestLoadMoreListener) {
        this.mRequestLoadMoreListener = requestLoadMoreListener;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public void openLoadMore(int pageSize) {
        this.pageSize = pageSize;
        this.mNextLoadEnable = true;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public BaseQuickAdapter(int layoutResId, List<T> data) {
        ArrayList arrayList = this.mData = data == null ? new ArrayList() : data;
        if (layoutResId != 0) {
            this.mLayoutResId = layoutResId;
        }
    }

    public BaseQuickAdapter(List<T> data) {
        this(0, data);
    }

    public BaseQuickAdapter(View contentView, List<T> data) {
        this(0, data);
        this.mContentView = contentView;
    }

    public void remove(int position) {
        this.mData.remove(position);
        this.notifyItemRemoved(position + this.getHeaderLayoutCount());
    }

    public void add(int position, T item) {
        this.mData.add(position, item);
        this.notifyItemInserted(position);
    }

    public void setNewData(List<T> data) {
        ArrayList arrayList = this.mData = data == null ? new ArrayList() : data;
        if (this.mRequestLoadMoreListener != null) {
            this.mNextLoadEnable = true;
        }
        if (this.loadMoreFailedView != null) {
            this.removeFooterView(this.loadMoreFailedView);
        }
        this.mLastPosition = -1;
        this.notifyDataSetChanged();
    }

    public void addData(int position, T data) {
        if (0 > position || position >= this.mData.size()) {
            throw new ArrayIndexOutOfBoundsException("inserted position most greater than 0 and less than data size");
        }
        this.mData.add(position, data);
        this.notifyItemInserted(position);
        this.notifyItemRangeChanged(position, this.mData.size() - position);
    }

    public void addData(T data) {
        this.mData.add(data);
        this.notifyItemInserted(this.mData.size() - 1);
    }

    public void addData(int position, List<T> data) {
        if (0 > position || position >= this.mData.size()) {
            throw new ArrayIndexOutOfBoundsException("inserted position most greater than 0 and less than data size");
        }
        this.mData.addAll(position, data);
        this.notifyItemInserted(position);
        this.notifyItemRangeChanged(position, this.mData.size() - position - data.size());
    }

    public void addData(List<T> newData) {
        this.mData.addAll(newData);
        if (this.mNextLoadEnable) {
            this.mLoadingMoreEnable = false;
        }
        this.notifyItemRangeChanged(this.mData.size() - newData.size() + this.getHeaderLayoutCount(), newData.size());
    }

    public boolean isLoading() {
        return this.mLoadingMoreEnable;
    }

    public void dataAdded() {
        if (this.mNextLoadEnable) {
            this.mLoadingMoreEnable = false;
        }
        this.notifyDataSetChanged();
    }

    public void nextData() {
        if (this.mNextLoadEnable) {
            this.mLoadingMoreEnable = false;
        }
    }

    public void setLoadingView(View loadingView) {
        this.mLoadingView = loadingView;
    }

    public List<T> getData() {
        return this.mData;
    }

    public T getItem(int position) {
        return this.mData.get(position);
    }

    @Deprecated
    public int getHeaderViewsCount() {
        return this.mHeaderLayout == null ? 0 : 1;
    }

    @Deprecated
    public int getFooterViewsCount() {
        return this.mFooterLayout == null ? 0 : 1;
    }

    public int getHeaderLayoutCount() {
        return this.mHeaderLayout == null ? 0 : 1;
    }

    public int getFooterLayoutCount() {
        return this.mFooterLayout == null ? 0 : 1;
    }

    public int getmEmptyViewCount() {
        return this.mEmptyView == null ? 0 : 1;
    }

    public int getItemCount() {
        int i = this.isLoadMore() ? 1 : 0;
        int count = this.mData.size() + i + this.getHeaderLayoutCount() + this.getFooterLayoutCount();
        if (this.mData.size() == 0 && this.mEmptyView != null) {
            if (!(count != 0 || this.mHeadAndEmptyEnable && this.mFootAndEmptyEnable)) {
                count += this.getmEmptyViewCount();
            } else if (this.mHeadAndEmptyEnable || this.mFootAndEmptyEnable) {
                count += this.getmEmptyViewCount();
            }
            if (this.mHeadAndEmptyEnable && this.getHeaderLayoutCount() == 1 && count == 1 || count == 0) {
                this.mEmptyEnable = true;
                count += this.getmEmptyViewCount();
            }
        }
        return count;
    }

    public int getItemViewType(int position) {
        if (this.mHeaderLayout != null && position == 0) {
            return 273;
        }
        if (this.mData.size() == 0 && this.mEmptyEnable && this.mEmptyView != null && position <= 2) {
            if ((this.mHeadAndEmptyEnable || this.mFootAndEmptyEnable) && position == 1) {
                if (this.mHeaderLayout == null && this.mFooterLayout != null) {
                    return 819;
                }
                if (this.mHeaderLayout != null) {
                    return 1365;
                }
            } else if (position == 0) {
                if (this.mHeaderLayout == null) {
                    return 1365;
                }
                if (this.mFooterLayout != null) {
                    return 1365;
                }
            } else {
                if (position == 2 && (this.mFootAndEmptyEnable || this.mHeadAndEmptyEnable) && this.mHeaderLayout != null && this.mEmptyView != null) {
                    return 819;
                }
                if (!(this.mFootAndEmptyEnable && this.mHeadAndEmptyEnable || position != 1 || this.mFooterLayout == null)) {
                    return 819;
                }
            }
        } else {
            if (this.mData.size() == 0 && this.mEmptyView != null && this.getItemCount() == (this.mHeadAndEmptyEnable ? 2 : 1) && this.mEmptyEnable) {
                return 1365;
            }
            if (position == this.mData.size() + this.getHeaderLayoutCount()) {
                if (this.mNextLoadEnable) {
                    return 546;
                }
                return 819;
            }
            if (position > this.mData.size() + this.getHeaderLayoutCount()) {
                return 819;
            }
        }
        return this.getDefItemViewType(position - this.getHeaderLayoutCount());
    }

    protected int getDefItemViewType(int position) {
        return super.getItemViewType(position);
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        BaseViewHolder baseViewHolder = null;
        this.mContext = parent.getContext();
        this.mLayoutInflater = LayoutInflater.from((Context)this.mContext);
        switch (viewType) {
            case 546: {
                baseViewHolder = this.getLoadingView(parent);
                break;
            }
            case 273: {
                baseViewHolder = new BaseViewHolder((View)this.mHeaderLayout);
                break;
            }
            case 1365: {
                baseViewHolder = new BaseViewHolder(this.mEmptyView == this.mCopyEmptyLayout ? this.mCopyEmptyLayout : this.mEmptyView);
                break;
            }
            case 819: {
                baseViewHolder = new BaseViewHolder((View)this.mFooterLayout);
                break;
            }
            default: {
                baseViewHolder = this.onCreateDefViewHolder(parent, viewType);
            }
        }
        return baseViewHolder;
    }

    private BaseViewHolder getLoadingView(ViewGroup parent) {
        if (this.mLoadingView == null) {
            return this.createBaseViewHolder(parent, R.layout.def_loading);
        }
        return new BaseViewHolder(this.mLoadingView);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        int type = holder.getItemViewType();
        if (type == 1365 || type == 273 || type == 819 || type == 546) {
            this.setFullSpan(holder);
        } else {
            this.addAnimation(holder);
        }
    }

    protected void setFullSpan(RecyclerView.ViewHolder holder) {
        if (holder.itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams();
            params.setFullSpan(true);
        }
    }

    public void onAttachedToRecyclerView(final RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    int type = BaseQuickAdapter.this.getItemViewType(position);
                    if (BaseQuickAdapter.this.mSpanSizeLookup == null) {
                        return type == 1365 || type == 273 || type == 819 || type == 546 ? gridManager.getSpanCount() : 1;
                    }
                    return type == 1365 || type == 273 || type == 819 || type == 546 ? gridManager.getSpanCount() : BaseQuickAdapter.this.mSpanSizeLookup.getSpanSize(gridManager, position - BaseQuickAdapter.this.getHeaderLayoutCount());
                }
            });
        }
        recyclerView.post(new Runnable(){

            @Override
            public void run() {
                if (BaseQuickAdapter.this.mRequestLoadMoreListener != null && BaseQuickAdapter.this.pageSize == -1) {
                    RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                    int visibleItemCount = layoutManager.getChildCount();
                    Log.e((String)"visibleItemCount", (String)(visibleItemCount + ""));
                    BaseQuickAdapter.this.openLoadMore(visibleItemCount);
                }
            }
        });
    }

    public void setSpanSizeLookup(SpanSizeLookup spanSizeLookup) {
        this.mSpanSizeLookup = spanSizeLookup;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int positions) {
        int viewType = holder.getItemViewType();
        switch (viewType) {
            case 0: {
                this.convert((BaseViewHolder)holder, this.mData.get(holder.getLayoutPosition() - this.getHeaderLayoutCount()));
                break;
            }
            case 546: {
                this.addLoadMore(holder);
                break;
            }
            case 273: {
                break;
            }
            case 1365: {
                break;
            }
            case 819: {
                break;
            }
            default: {
                this.convert((BaseViewHolder)holder, this.mData.get(holder.getLayoutPosition() - this.getHeaderLayoutCount()));
                this.onBindDefViewHolder((BaseViewHolder)holder, this.mData.get(holder.getLayoutPosition() - this.getHeaderLayoutCount()));
            }
        }
    }

    protected BaseViewHolder onCreateDefViewHolder(ViewGroup parent, int viewType) {
        return this.createBaseViewHolder(parent, this.mLayoutResId);
    }

    protected BaseViewHolder createBaseViewHolder(ViewGroup parent, int layoutResId) {
        if (this.mContentView == null) {
            return new BaseViewHolder(this.getItemView(layoutResId, parent));
        }
        return new BaseViewHolder(this.mContentView);
    }

    public LinearLayout getHeaderLayout() {
        return this.mHeaderLayout;
    }

    public LinearLayout getFooterLayout() {
        return this.mFooterLayout;
    }

    public void addHeaderView(View header) {
        this.addHeaderView(header, -1);
    }

    public void addHeaderView(View header, int index) {
        if (this.mHeaderLayout == null) {
            if (this.mCopyHeaderLayout == null) {
                this.mHeaderLayout = new LinearLayout(header.getContext());
                this.mHeaderLayout.setOrientation(1);
                this.mHeaderLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
                this.mCopyHeaderLayout = this.mHeaderLayout;
            } else {
                this.mHeaderLayout = this.mCopyHeaderLayout;
            }
        }
        index = index >= this.mHeaderLayout.getChildCount() ? -1 : index;
        this.mHeaderLayout.addView(header, index);
        this.notifyDataSetChanged();
    }

    public void addFooterView(View footer) {
        this.addFooterView(footer, -1);
    }

    public void addFooterView(View footer, int index) {
        this.mNextLoadEnable = false;
        if (this.mFooterLayout == null) {
            if (this.mCopyFooterLayout == null) {
                this.mFooterLayout = new LinearLayout(footer.getContext());
                this.mFooterLayout.setOrientation(1);
                this.mFooterLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
                this.mCopyFooterLayout = this.mFooterLayout;
            } else {
                this.mFooterLayout = this.mCopyFooterLayout;
            }
        }
        index = index >= this.mFooterLayout.getChildCount() ? -1 : index;
        this.mFooterLayout.addView(footer, index);
        this.notifyItemChanged(this.getItemCount());
    }

    public void removeHeaderView(View header) {
        if (this.mHeaderLayout == null) {
            return;
        }
        this.mHeaderLayout.removeView(header);
        if (this.mHeaderLayout.getChildCount() == 0) {
            this.mHeaderLayout = null;
        }
        this.notifyDataSetChanged();
    }

    public void removeFooterView(View footer) {
        if (this.mFooterLayout == null) {
            return;
        }
        this.mFooterLayout.removeView(footer);
        if (this.mFooterLayout.getChildCount() == 0) {
            this.mFooterLayout = null;
        }
        this.notifyDataSetChanged();
    }

    public void removeAllHeaderView() {
        if (this.mHeaderLayout == null) {
            return;
        }
        this.mHeaderLayout.removeAllViews();
        this.mHeaderLayout = null;
    }

    public void removeAllFooterView() {
        if (this.mFooterLayout == null) {
            return;
        }
        this.mFooterLayout.removeAllViews();
        this.mFooterLayout = null;
    }

    public void setLoadMoreFailedView(View view) {
        this.loadMoreFailedView = view;
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseQuickAdapter.this.removeFooterView(BaseQuickAdapter.this.loadMoreFailedView);
                BaseQuickAdapter.this.openLoadMore(BaseQuickAdapter.this.pageSize);
            }
        });
    }

    public void showLoadMoreFailedView() {
        this.loadComplete();
        if (this.loadMoreFailedView == null) {
            this.loadMoreFailedView = this.mLayoutInflater.inflate(R.layout.def_load_more_failed, null);
            this.loadMoreFailedView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseQuickAdapter.this.removeFooterView(BaseQuickAdapter.this.loadMoreFailedView);
                    BaseQuickAdapter.this.openLoadMore(BaseQuickAdapter.this.pageSize);
                }
            });
        }
        this.addFooterView(this.loadMoreFailedView);
    }

    public void setEmptyView(View emptyView) {
        this.setEmptyView(false, false, emptyView);
    }

    public void setEmptyView(boolean isHeadAndEmpty, View emptyView) {
        this.setEmptyView(isHeadAndEmpty, false, emptyView);
    }

    public void setEmptyView(boolean isHeadAndEmpty, boolean isFootAndEmpty, View emptyView) {
        this.mHeadAndEmptyEnable = isHeadAndEmpty;
        this.mFootAndEmptyEnable = isFootAndEmpty;
        this.mEmptyView = emptyView;
        if (this.mCopyEmptyLayout == null) {
            this.mCopyEmptyLayout = emptyView;
        }
        this.mEmptyEnable = true;
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public void loadComplete() {
        this.mNextLoadEnable = false;
        this.mLoadingMoreEnable = false;
        this.notifyItemChanged(this.getItemCount());
    }

    private void addLoadMore(RecyclerView.ViewHolder holder) {
        if (this.isLoadMore() && !this.mLoadingMoreEnable) {
            this.mLoadingMoreEnable = true;
            this.mRequestLoadMoreListener.onLoadMoreRequested();
        }
    }

    private void addAnimation(RecyclerView.ViewHolder holder) {
        if (this.mOpenAnimationEnable && (!this.mFirstOnlyEnable || holder.getLayoutPosition() > this.mLastPosition)) {
            BaseAnimation animation = null;
            animation = this.mCustomAnimation != null ? this.mCustomAnimation : this.mSelectAnimation;
            for (Animator anim : animation.getAnimators(holder.itemView)) {
                this.startAnim(anim, holder.getLayoutPosition());
            }
            this.mLastPosition = holder.getLayoutPosition();
        }
    }

    protected void startAnim(Animator anim, int index) {
        anim.setDuration((long)this.mDuration).start();
        anim.setInterpolator((TimeInterpolator)this.mInterpolator);
    }

    private boolean isLoadMore() {
        return this.mNextLoadEnable && this.pageSize != -1 && this.mRequestLoadMoreListener != null && this.mData.size() >= this.pageSize;
    }

    protected View getItemView(int layoutResId, ViewGroup parent) {
        return this.mLayoutInflater.inflate(layoutResId, parent, false);
    }

    @Deprecated
    protected void onBindDefViewHolder(BaseViewHolder holder, T item) {
    }

    public void openLoadAnimation(int animationType) {
        this.mOpenAnimationEnable = true;
        this.mCustomAnimation = null;
        switch (animationType) {
            case 1: {
                this.mSelectAnimation = new AlphaInAnimation();
                break;
            }
            case 2: {
                this.mSelectAnimation = new ScaleInAnimation();
                break;
            }
            case 3: {
                this.mSelectAnimation = new SlideInBottomAnimation();
                break;
            }
            case 4: {
                this.mSelectAnimation = new SlideInLeftAnimation();
                break;
            }
            case 5: {
                this.mSelectAnimation = new SlideInRightAnimation();
                break;
            }
        }
    }

    public void openLoadAnimation(BaseAnimation animation) {
        this.mOpenAnimationEnable = true;
        this.mCustomAnimation = animation;
    }

    public void openLoadAnimation() {
        this.mOpenAnimationEnable = true;
    }

    public void isFirstOnly(boolean firstOnly) {
        this.mFirstOnlyEnable = firstOnly;
    }

    protected abstract void convert(BaseViewHolder var1, T var2);

    public long getItemId(int position) {
        return position;
    }

    private int recursiveExpand(int position, @NonNull List list) {
        int count = 0;
        int pos = position + list.size() - 1;
        int i = list.size() - 1;
        while (i >= 0) {
            IExpandable item;
            if (list.get(i) instanceof IExpandable && (item = (IExpandable)list.get(i)).isExpanded() && this.hasSubItems(item)) {
                List subList = item.getSubItems();
                this.mData.addAll(pos + 1, subList);
                int subItemCount = this.recursiveExpand(pos + 1, subList);
                count += subItemCount;
            }
            --i;
            --pos;
        }
        return count;
    }

    public int expand(@IntRange(from=0L) int position, boolean animate, boolean shouldNotify) {
        IExpandable expandable = this.getExpandableItem(position -= this.getHeaderLayoutCount());
        if (expandable == null) {
            return 0;
        }
        if (!this.hasSubItems(expandable)) {
            expandable.setExpanded(false);
            return 0;
        }
        int subItemCount = 0;
        if (!expandable.isExpanded()) {
            List list = expandable.getSubItems();
            this.mData.addAll(position + 1, list);
            subItemCount += this.recursiveExpand(position + 1, list);
            expandable.setExpanded(true);
            subItemCount += list.size();
        }
        int parentPos = position + this.getHeaderLayoutCount();
        if (shouldNotify) {
            if (animate) {
                this.notifyItemChanged(parentPos);
                this.notifyItemRangeInserted(parentPos + 1, subItemCount);
            } else {
                this.notifyDataSetChanged();
            }
        }
        return subItemCount;
    }

    public int expand(@IntRange(from=0L) int position, boolean animate) {
        return this.expand(position, animate, true);
    }

    public int expand(@IntRange(from=0L) int position) {
        return this.expand(position, true, true);
    }

    public int expandAll(int position, boolean animate, boolean notify) {
        T item;
        IExpandable expandable;
        Object endItem = null;
        if ((position -= this.getHeaderLayoutCount()) + 1 < this.mData.size()) {
            endItem = this.getItem(position + 1);
        }
        if (!this.hasSubItems(expandable = this.getExpandableItem(position))) {
            return 0;
        }
        int count = this.expand(position + this.getHeaderLayoutCount(), false, false);
        for (int i = position + 1; i < this.mData.size() && (item = this.getItem(i)) != endItem; ++i) {
            if (!this.isExpandable(item)) continue;
            count += this.expand(i + this.getHeaderLayoutCount(), false, false);
        }
        if (notify) {
            if (animate) {
                this.notifyItemRangeInserted(position + this.getHeaderLayoutCount() + 1, count);
            } else {
                this.notifyDataSetChanged();
            }
        }
        return count;
    }

    public int expandAll(int position, boolean init) {
        return this.expandAll(position, true, !init);
    }

    private int recursiveCollapse(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (!this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        int subItemCount = 0;
        if (expandable.isExpanded()) {
            List subItems = expandable.getSubItems();
            for (int i = subItems.size() - 1; i >= 0; --i) {
                Object subItem = subItems.get(i);
                int pos = this.getItemPosition(subItem);
                if (pos < 0) continue;
                if (subItem instanceof IExpandable) {
                    subItemCount += this.recursiveCollapse(pos);
                }
                this.mData.remove(pos);
                ++subItemCount;
            }
        }
        return subItemCount;
    }

    public int collapse(@IntRange(from=0L) int position, boolean animate, boolean notify) {
        IExpandable expandable = this.getExpandableItem(position -= this.getHeaderLayoutCount());
        if (expandable == null) {
            return 0;
        }
        int subItemCount = this.recursiveCollapse(position);
        expandable.setExpanded(false);
        int parentPos = position + this.getHeaderLayoutCount();
        if (notify) {
            if (animate) {
                this.notifyItemChanged(parentPos);
                this.notifyItemRangeRemoved(parentPos + 1, subItemCount);
            } else {
                this.notifyDataSetChanged();
            }
        }
        return subItemCount;
    }

    public int collapse(@IntRange(from=0L) int position) {
        return this.collapse(position, true, true);
    }

    public int collapse(@IntRange(from=0L) int position, boolean animate) {
        return this.collapse(position, animate, true);
    }

    private int getItemPosition(T item) {
        return item != null && this.mData != null && !this.mData.isEmpty() ? this.mData.indexOf(item) : -1;
    }

    private boolean hasSubItems(IExpandable item) {
        List list = item.getSubItems();
        return list != null && list.size() > 0;
    }

    private boolean isExpandable(T item) {
        return item != null && item instanceof IExpandable;
    }

    private IExpandable getExpandableItem(int position) {
        T item = this.getItem(position);
        if (this.isExpandable(item)) {
            return (IExpandable)item;
        }
        return null;
    }

    public int getParentPosition(@NonNull T item) {
        int position = this.getItemPosition(item);
        if (position == -1) {
            return -1;
        }
        int level = item instanceof IExpandable ? ((IExpandable)item).getLevel() : Integer.MAX_VALUE;
        if (level == 0) {
            return position;
        }
        if (level == -1) {
            return -1;
        }
        for (int i = position; i >= 0; --i) {
            IExpandable expandable;
            T temp = this.mData.get(i);
            if (!(temp instanceof IExpandable) || (expandable = (IExpandable)temp).getLevel() < 0 || expandable.getLevel() >= level) continue;
            return i;
        }
        return -1;
    }

    public static interface RequestLoadMoreListener {
        public void onLoadMoreRequested();
    }

    public static interface SpanSizeLookup {
        public int getSpanSize(GridLayoutManager var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnimationType {
    }
}

