/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.diff;

import android.os.Handler;
import android.os.Looper;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.diff.BrvahAsyncDifferConfig;
import com.chad.library.adapter.base.diff.BrvahListUpdateCallback;
import com.chad.library.adapter.base.diff.DifferImp;
import com.chad.library.adapter.base.diff.ListChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001/B%\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00132\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J%\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00028\u00002\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\u0013J(\u0010\"\u001a\u00020\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J \u0010(\u001a\u00020\u00132\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0013\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010,\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000eJ\u0014\u0010-\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ$\u0010.\u001a\u00020\u00132\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\t2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0007R\u0018\u0010\u0003\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/chad/library/adapter/base/diff/BrvahAsyncDiffer;", "T", "Lcom/chad/library/adapter/base/diff/DifferImp;", "adapter", "Lcom/chad/library/adapter/base/BaseQuickAdapter;", "config", "Lcom/chad/library/adapter/base/diff/BrvahAsyncDifferConfig;", "(Lcom/chad/library/adapter/base/BaseQuickAdapter;Lcom/chad/library/adapter/base/diff/BrvahAsyncDifferConfig;)V", "mListeners", "", "Lcom/chad/library/adapter/base/diff/ListChangeListener;", "mMainThreadExecutor", "Ljava/util/concurrent/Executor;", "mMaxScheduledGeneration", "", "mUpdateCallback", "Landroidx/recyclerview/widget/ListUpdateCallback;", "sMainThreadExecutor", "addData", "", "data", "(Ljava/lang/Object;)V", "index", "(ILjava/lang/Object;)V", "addList", "list", "", "addListListener", "listener", "changeData", "newData", "payload", "(ILjava/lang/Object;Ljava/lang/Object;)V", "clearAllListListener", "latchList", "newList", "diffResult", "Landroidx/recyclerview/widget/DiffUtil$DiffResult;", "commitCallback", "Ljava/lang/Runnable;", "onCurrentListChanged", "previousList", "remove", "t", "removeAt", "removeListListener", "submitList", "MainThreadExecutor", "com.github.CymChad.brvah"})
public final class BrvahAsyncDiffer<T>
implements DifferImp<T> {
    @NotNull
    private final BaseQuickAdapter<T, ?> adapter;
    @NotNull
    private final BrvahAsyncDifferConfig<T> config;
    @NotNull
    private final ListUpdateCallback mUpdateCallback;
    @NotNull
    private Executor mMainThreadExecutor;
    @NotNull
    private final Executor sMainThreadExecutor;
    @NotNull
    private final List<ListChangeListener<T>> mListeners;
    private int mMaxScheduledGeneration;

    public BrvahAsyncDiffer(@NotNull BaseQuickAdapter<T, ?> adapter, @NotNull BrvahAsyncDifferConfig<T> config) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.adapter = adapter;
        this.config = config;
        this.mUpdateCallback = new BrvahListUpdateCallback(this.adapter);
        this.sMainThreadExecutor = new MainThreadExecutor();
        Executor executor = this.config.getMainThreadExecutor();
        if (executor == null) {
            executor = this.sMainThreadExecutor;
        }
        this.mMainThreadExecutor = executor;
        this.mListeners = new CopyOnWriteArrayList();
    }

    public final void addData(int index, T data) {
        List<T> previousList = this.adapter.getData();
        this.adapter.getData().add(index, data);
        this.mUpdateCallback.onInserted(index, 1);
        this.onCurrentListChanged(previousList, null);
    }

    public final void addData(T data) {
        List<T> previousList = this.adapter.getData();
        this.adapter.getData().add(data);
        this.mUpdateCallback.onInserted(previousList.size(), 1);
        this.onCurrentListChanged(previousList, null);
    }

    public final void addList(@Nullable List<? extends T> list) {
        if (list == null) {
            return;
        }
        List<T> previousList = this.adapter.getData();
        this.adapter.getData().addAll((Collection)list);
        this.mUpdateCallback.onInserted(previousList.size(), list.size());
        this.onCurrentListChanged(previousList, null);
    }

    public final void changeData(int index, T newData, @Nullable T payload) {
        List<T> previousList = this.adapter.getData();
        this.adapter.getData().set(index, newData);
        this.mUpdateCallback.onChanged(index, 1, payload);
        this.onCurrentListChanged(previousList, null);
    }

    public final void removeAt(int index) {
        List<T> previousList = this.adapter.getData();
        this.adapter.getData().remove(index);
        this.mUpdateCallback.onRemoved(index, 1);
        this.onCurrentListChanged(previousList, null);
    }

    public final void remove(T t) {
        List<T> previousList = this.adapter.getData();
        int index = this.adapter.getData().indexOf(t);
        if (index == -1) {
            return;
        }
        this.adapter.getData().remove(index);
        this.mUpdateCallback.onRemoved(index, 1);
        this.onCurrentListChanged(previousList, null);
    }

    @JvmOverloads
    public final void submitList(@Nullable List<T> newList, @Nullable Runnable commitCallback) {
        ++this.mMaxScheduledGeneration;
        int runGeneration = this.mMaxScheduledGeneration;
        if (newList == this.adapter.getData()) {
            Runnable runnable = commitCallback;
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        List<T> oldList = this.adapter.getData();
        if (newList == null) {
            int countRemoved = this.adapter.getData().size();
            this.adapter.setData$com_github_CymChad_brvah(new ArrayList());
            this.mUpdateCallback.onRemoved(0, countRemoved);
            this.onCurrentListChanged(oldList, commitCallback);
            return;
        }
        if (this.adapter.getData().isEmpty()) {
            this.adapter.setData$com_github_CymChad_brvah(newList);
            this.mUpdateCallback.onInserted(0, newList.size());
            this.onCurrentListChanged(oldList, commitCallback);
            return;
        }
        this.config.getBackgroundThreadExecutor().execute(() -> BrvahAsyncDiffer.submitList$lambda-1(this, oldList, newList, runGeneration, commitCallback));
    }

    public static /* synthetic */ void submitList$default(BrvahAsyncDiffer brvahAsyncDiffer, List list, Runnable runnable, int n, Object object) {
        if ((n & 2) != 0) {
            runnable = null;
        }
        brvahAsyncDiffer.submitList(list, runnable);
    }

    private final void latchList(List<T> newList, DiffUtil.DiffResult diffResult, Runnable commitCallback) {
        List<T> previousList = this.adapter.getData();
        this.adapter.setData$com_github_CymChad_brvah(newList);
        diffResult.dispatchUpdatesTo(this.mUpdateCallback);
        this.onCurrentListChanged(previousList, commitCallback);
    }

    private final void onCurrentListChanged(List<? extends T> previousList, Runnable commitCallback) {
        block1: {
            for (ListChangeListener<? extends T> listChangeListener : this.mListeners) {
                listChangeListener.onCurrentListChanged(previousList, this.adapter.getData());
            }
            Runnable runnable = commitCallback;
            if (runnable == null) break block1;
            runnable.run();
        }
    }

    @Override
    public void addListListener(@NotNull ListChangeListener<T> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.mListeners.add(listener);
    }

    public final void removeListListener(@NotNull ListChangeListener<T> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.mListeners.remove(listener);
    }

    public final void clearAllListListener() {
        this.mListeners.clear();
    }

    @JvmOverloads
    public final void submitList(@Nullable List<T> newList) {
        BrvahAsyncDiffer.submitList$default(this, newList, null, 2, null);
    }

    private static final void submitList$lambda-1$lambda-0(BrvahAsyncDiffer this$0, int $runGeneration, List $newList, DiffUtil.DiffResult $result, Runnable $commitCallback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        if (this$0.mMaxScheduledGeneration == $runGeneration) {
            this$0.latchList($newList, $result, $commitCallback);
        }
    }

    private static final void submitList$lambda-1(BrvahAsyncDiffer this$0, List $oldList, List $newList, int $runGeneration, Runnable $commitCallback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$oldList, (String)"$oldList");
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtil.Callback($oldList, $newList, this$0){
            final /* synthetic */ List<T> $oldList;
            final /* synthetic */ List<T> $newList;
            final /* synthetic */ BrvahAsyncDiffer<T> this$0;
            {
                this.$oldList = $oldList;
                this.$newList = $newList;
                this.this$0 = $receiver;
            }

            public int getOldListSize() {
                return this.$oldList.size();
            }

            public int getNewListSize() {
                return this.$newList.size();
            }

            public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
                T oldItem = this.$oldList.get(oldItemPosition);
                T newItem = this.$newList.get(newItemPosition);
                return oldItem != null && newItem != null ? BrvahAsyncDiffer.access$getConfig$p(this.this$0).getDiffCallback().areItemsTheSame(oldItem, newItem) : oldItem == null && newItem == null;
            }

            public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
                T oldItem = this.$oldList.get(oldItemPosition);
                T newItem = this.$newList.get(newItemPosition);
                if (oldItem != null && newItem != null) {
                    return BrvahAsyncDiffer.access$getConfig$p(this.this$0).getDiffCallback().areContentsTheSame(oldItem, newItem);
                }
                if (oldItem == null && newItem == null) {
                    return true;
                }
                throw new AssertionError();
            }

            @Nullable
            public Object getChangePayload(int oldItemPosition, int newItemPosition) {
                T oldItem = this.$oldList.get(oldItemPosition);
                T newItem = this.$newList.get(newItemPosition);
                if (oldItem != null && newItem != null) {
                    return BrvahAsyncDiffer.access$getConfig$p(this.this$0).getDiffCallback().getChangePayload(oldItem, newItem);
                }
                throw new AssertionError();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)diffResult, (String)"@JvmOverloads\n    fun su\u2026        }\n        }\n    }");
        DiffUtil.DiffResult result2 = diffResult;
        this$0.mMainThreadExecutor.execute(() -> BrvahAsyncDiffer.submitList$lambda-1$lambda-0(this$0, $runGeneration, $newList, result2, $commitCallback));
    }

    public static final /* synthetic */ BrvahAsyncDifferConfig access$getConfig$p(BrvahAsyncDiffer $this) {
        return $this.config;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/chad/library/adapter/base/diff/BrvahAsyncDiffer$MainThreadExecutor;", "Ljava/util/concurrent/Executor;", "()V", "mHandler", "Landroid/os/Handler;", "getMHandler", "()Landroid/os/Handler;", "execute", "", "command", "Ljava/lang/Runnable;", "com.github.CymChad.brvah"})
    private static final class MainThreadExecutor
    implements Executor {
        @NotNull
        private final Handler mHandler = new Handler(Looper.getMainLooper());

        @NotNull
        public final Handler getMHandler() {
            return this.mHandler;
        }

        @Override
        public void execute(@NotNull Runnable command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            this.mHandler.post(command);
        }
    }
}

