/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.callback;

import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.View;
import com.chad.library.R;
import com.chad.library.adapter.base.BaseItemDraggableAdapter;
import com.chad.library.adapter.base.DraggableController;
import com.chad.library.adapter.base.listener.IDraggableListener;

public class ItemDragAndSwipeCallback
extends ItemTouchHelper.Callback {
    private IDraggableListener mDraggableListener;
    private BaseItemDraggableAdapter mBaseItemDraggableAdapter;
    private float mMoveThreshold = 0.1f;
    private float mSwipeThreshold = 0.7f;
    private int mDragMoveFlags = 15;
    private int mSwipeMoveFlags = 32;

    public ItemDragAndSwipeCallback(BaseItemDraggableAdapter adapter) {
        this.mBaseItemDraggableAdapter = adapter;
    }

    public ItemDragAndSwipeCallback(DraggableController draggableController) {
        this.mDraggableListener = draggableController;
    }

    public boolean isLongPressDragEnabled() {
        if (this.mBaseItemDraggableAdapter != null) {
            return this.mBaseItemDraggableAdapter.isItemDraggable() && !this.mBaseItemDraggableAdapter.hasToggleView();
        }
        if (this.mDraggableListener != null) {
            return this.mDraggableListener.isItemDraggable() && !this.mDraggableListener.hasToggleView();
        }
        return false;
    }

    public boolean isItemViewSwipeEnabled() {
        if (this.mBaseItemDraggableAdapter != null) {
            return this.mBaseItemDraggableAdapter.isItemSwipeEnable();
        }
        if (this.mDraggableListener != null) {
            return this.mDraggableListener.isItemSwipeEnable();
        }
        return false;
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState == 2 && !this.isViewCreateByAdapter(viewHolder)) {
            if (this.mBaseItemDraggableAdapter != null) {
                this.mBaseItemDraggableAdapter.onItemDragStart(viewHolder);
            } else if (this.mDraggableListener != null) {
                this.mDraggableListener.onItemDragStart(viewHolder);
            }
            viewHolder.itemView.setTag(R.id.BaseQuickAdapter_dragging_support, (Object)true);
        } else if (actionState == 1 && !this.isViewCreateByAdapter(viewHolder)) {
            if (this.mBaseItemDraggableAdapter != null) {
                this.mBaseItemDraggableAdapter.onItemSwipeStart(viewHolder);
            } else if (this.mDraggableListener != null) {
                this.mDraggableListener.onItemSwipeStart(viewHolder);
            }
            viewHolder.itemView.setTag(R.id.BaseQuickAdapter_swiping_support, (Object)true);
        }
        super.onSelectedChanged(viewHolder, actionState);
    }

    public void clearView(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        if (this.isViewCreateByAdapter(viewHolder)) {
            return;
        }
        if (viewHolder.itemView.getTag(R.id.BaseQuickAdapter_dragging_support) != null && ((Boolean)viewHolder.itemView.getTag(R.id.BaseQuickAdapter_dragging_support)).booleanValue()) {
            if (this.mBaseItemDraggableAdapter != null) {
                this.mBaseItemDraggableAdapter.onItemDragEnd(viewHolder);
            } else if (this.mDraggableListener != null) {
                this.mDraggableListener.onItemDragEnd(viewHolder);
            }
            viewHolder.itemView.setTag(R.id.BaseQuickAdapter_dragging_support, (Object)false);
        }
        if (viewHolder.itemView.getTag(R.id.BaseQuickAdapter_swiping_support) != null && ((Boolean)viewHolder.itemView.getTag(R.id.BaseQuickAdapter_swiping_support)).booleanValue()) {
            if (this.mBaseItemDraggableAdapter != null) {
                this.mBaseItemDraggableAdapter.onItemSwipeClear(viewHolder);
            } else if (this.mDraggableListener != null) {
                this.mDraggableListener.onItemSwipeClear(viewHolder);
            }
            viewHolder.itemView.setTag(R.id.BaseQuickAdapter_swiping_support, (Object)false);
        }
    }

    public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
        if (this.isViewCreateByAdapter(viewHolder)) {
            return ItemDragAndSwipeCallback.makeMovementFlags((int)0, (int)0);
        }
        return ItemDragAndSwipeCallback.makeMovementFlags((int)this.mDragMoveFlags, (int)this.mSwipeMoveFlags);
    }

    public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder source, @NonNull RecyclerView.ViewHolder target) {
        return source.getItemViewType() == target.getItemViewType();
    }

    public void onMoved(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder source, int fromPos, @NonNull RecyclerView.ViewHolder target, int toPos, int x, int y) {
        super.onMoved(recyclerView, source, fromPos, target, toPos, x, y);
        if (this.mBaseItemDraggableAdapter != null) {
            this.mBaseItemDraggableAdapter.onItemDragMoving(source, target);
        } else if (this.mDraggableListener != null) {
            this.mDraggableListener.onItemDragMoving(source, target);
        }
    }

    public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
        if (!this.isViewCreateByAdapter(viewHolder)) {
            if (this.mBaseItemDraggableAdapter != null) {
                this.mBaseItemDraggableAdapter.onItemSwiped(viewHolder);
            } else if (this.mDraggableListener != null) {
                this.mDraggableListener.onItemSwiped(viewHolder);
            }
        }
    }

    public float getMoveThreshold(@NonNull RecyclerView.ViewHolder viewHolder) {
        return this.mMoveThreshold;
    }

    public float getSwipeThreshold(@NonNull RecyclerView.ViewHolder viewHolder) {
        return this.mSwipeThreshold;
    }

    public void setSwipeThreshold(float swipeThreshold) {
        this.mSwipeThreshold = swipeThreshold;
    }

    public void setMoveThreshold(float moveThreshold) {
        this.mMoveThreshold = moveThreshold;
    }

    public void setDragMoveFlags(int dragMoveFlags) {
        this.mDragMoveFlags = dragMoveFlags;
    }

    public void setSwipeMoveFlags(int swipeMoveFlags) {
        this.mSwipeMoveFlags = swipeMoveFlags;
    }

    public void onChildDrawOver(@NonNull Canvas c, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        super.onChildDrawOver(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        if (actionState == 1 && !this.isViewCreateByAdapter(viewHolder)) {
            View itemView = viewHolder.itemView;
            c.save();
            if (dX > 0.0f) {
                c.clipRect((float)itemView.getLeft(), (float)itemView.getTop(), (float)itemView.getLeft() + dX, (float)itemView.getBottom());
                c.translate((float)itemView.getLeft(), (float)itemView.getTop());
            } else {
                c.clipRect((float)itemView.getRight() + dX, (float)itemView.getTop(), (float)itemView.getRight(), (float)itemView.getBottom());
                c.translate((float)itemView.getRight() + dX, (float)itemView.getTop());
            }
            if (this.mBaseItemDraggableAdapter != null) {
                this.mBaseItemDraggableAdapter.onItemSwiping(c, viewHolder, dX, dY, isCurrentlyActive);
            } else if (this.mDraggableListener != null) {
                this.mDraggableListener.onItemSwiping(c, viewHolder, dX, dY, isCurrentlyActive);
            }
            c.restore();
        }
    }

    private boolean isViewCreateByAdapter(@NonNull RecyclerView.ViewHolder viewHolder) {
        int type = viewHolder.getItemViewType();
        return type == 273 || type == 546 || type == 819 || type == 1365;
    }
}

