/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.util.MultiTypeDelegate;
import com.chad.library.adapter.base.util.ProviderDelegate;
import java.util.List;

public abstract class MultipleItemRvAdapter<T, V extends BaseViewHolder>
extends BaseQuickAdapter<T, V> {
    private SparseArray<BaseItemProvider> mItemProviders;
    protected ProviderDelegate mProviderDelegate;
    private MultiTypeDelegate<T> mMultiTypeDelegate;

    public MultipleItemRvAdapter(@Nullable List<T> data) {
        super(data);
    }

    public void finishInitialize() {
        this.mProviderDelegate = new ProviderDelegate();
        this.setMultiTypeDelegate(new MultiTypeDelegate<T>(){

            @Override
            protected int getItemType(T t) {
                return MultipleItemRvAdapter.this.getViewType(t);
            }
        });
        this.registerItemProvider();
        this.mItemProviders = this.mProviderDelegate.getItemProviders();
        for (int i = 0; i < this.mItemProviders.size(); ++i) {
            int key = this.mItemProviders.keyAt(i);
            BaseItemProvider provider = (BaseItemProvider)this.mItemProviders.get(key);
            provider.mData = this.mData;
            this.getMultiTypeDelegate().registerItemType(key, provider.layout());
        }
    }

    protected abstract int getViewType(T var1);

    public abstract void registerItemProvider();

    @Override
    protected void bindViewClickListener(V baseViewHolder) {
        if (baseViewHolder == null) {
            return;
        }
        this.bindClick(baseViewHolder);
        super.bindViewClickListener(baseViewHolder);
    }

    @Override
    protected V onCreateDefViewHolder(ViewGroup parent, int viewType) {
        if (this.getMultiTypeDelegate() == null) {
            throw new IllegalStateException("please use setMultiTypeDelegate first!");
        }
        int layoutId = this.getMultiTypeDelegate().getLayoutId(viewType);
        return (V)this.createBaseViewHolder(parent, layoutId);
    }

    @Override
    protected int getDefItemViewType(int position) {
        if (this.getMultiTypeDelegate() == null) {
            throw new IllegalStateException("please use setMultiTypeDelegate first!");
        }
        return this.getMultiTypeDelegate().getDefItemViewType(this.mData, position);
    }

    @Override
    protected void convert(@NonNull V helper, T item) {
        int itemViewType = helper.getItemViewType();
        BaseItemProvider provider = (BaseItemProvider)this.mItemProviders.get(itemViewType);
        provider.mContext = ((BaseViewHolder)((Object)helper)).itemView.getContext();
        int position = helper.getLayoutPosition() - this.getHeaderLayoutCount();
        provider.convert(helper, item, position);
    }

    @Override
    protected void convertPayloads(@NonNull V helper, T item, @NonNull List<Object> payloads) {
        int itemViewType = helper.getItemViewType();
        BaseItemProvider provider = (BaseItemProvider)this.mItemProviders.get(itemViewType);
        int position = helper.getLayoutPosition() - this.getHeaderLayoutCount();
        provider.convertPayloads(helper, item, position, payloads);
    }

    private void bindClick(V helper) {
        BaseQuickAdapter.OnItemClickListener clickListener = this.getOnItemClickListener();
        BaseQuickAdapter.OnItemLongClickListener longClickListener = this.getOnItemLongClickListener();
        if (clickListener != null && longClickListener != null) {
            return;
        }
        if (clickListener == null) {
            ((BaseViewHolder)((Object)helper)).itemView.setOnClickListener(new View.OnClickListener((BaseViewHolder)((Object)helper)){
                final /* synthetic */ BaseViewHolder val$helper;
                {
                    this.val$helper = baseViewHolder;
                }

                public void onClick(View v) {
                    int position = this.val$helper.getAdapterPosition();
                    if (position == -1) {
                        return;
                    }
                    int itemViewType = this.val$helper.getItemViewType();
                    BaseItemProvider provider = (BaseItemProvider)MultipleItemRvAdapter.this.mItemProviders.get(itemViewType);
                    provider.onClick(this.val$helper, MultipleItemRvAdapter.this.mData.get(position -= MultipleItemRvAdapter.this.getHeaderLayoutCount()), position);
                }
            });
        }
        if (longClickListener == null) {
            ((BaseViewHolder)((Object)helper)).itemView.setOnLongClickListener(new View.OnLongClickListener((BaseViewHolder)((Object)helper)){
                final /* synthetic */ BaseViewHolder val$helper;
                {
                    this.val$helper = baseViewHolder;
                }

                public boolean onLongClick(View v) {
                    int position = this.val$helper.getAdapterPosition();
                    if (position == -1) {
                        return false;
                    }
                    int itemViewType = this.val$helper.getItemViewType();
                    BaseItemProvider provider = (BaseItemProvider)MultipleItemRvAdapter.this.mItemProviders.get(itemViewType);
                    return provider.onLongClick(this.val$helper, MultipleItemRvAdapter.this.mData.get(position -= MultipleItemRvAdapter.this.getHeaderLayoutCount()), position);
                }
            });
        }
    }

    public void setMultiTypeDelegate(MultiTypeDelegate<T> multiTypeDelegate) {
        this.mMultiTypeDelegate = multiTypeDelegate;
    }

    public MultiTypeDelegate<T> getMultiTypeDelegate() {
        return this.mMultiTypeDelegate;
    }
}

