/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.util.SparseIntArray;
import android.view.ViewGroup;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.entity.IExpandable;
import com.chad.library.adapter.base.entity.SectionMultiEntity;
import java.util.List;

public abstract class BaseSectionMultiItemQuickAdapter<T extends SectionMultiEntity, K extends BaseViewHolder>
extends BaseQuickAdapter<T, K> {
    private SparseIntArray layouts;
    private static final int DEFAULT_VIEW_TYPE = -255;
    public static final int TYPE_NOT_FOUND = -404;
    protected int mSectionHeadResId;
    protected static final int SECTION_HEADER_VIEW = 1092;

    public BaseSectionMultiItemQuickAdapter(int sectionHeadResId, List<T> data) {
        super(data);
        this.mSectionHeadResId = sectionHeadResId;
    }

    @Override
    protected int getDefItemViewType(int position) {
        SectionMultiEntity item = (SectionMultiEntity)this.mData.get(position);
        if (item != null) {
            return item.isHeader ? 1092 : item.getItemType();
        }
        return -255;
    }

    protected void setDefaultViewTypeLayout(@LayoutRes int layoutResId) {
        this.addItemType(-255, layoutResId);
    }

    @Override
    protected K onCreateDefViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1092) {
            return this.createBaseViewHolder(this.getItemView(this.mSectionHeadResId, parent));
        }
        return this.createBaseViewHolder(parent, this.getLayoutId(viewType));
    }

    private int getLayoutId(int viewType) {
        return this.layouts.get(viewType, -404);
    }

    protected void addItemType(int type, @LayoutRes int layoutResId) {
        if (this.layouts == null) {
            this.layouts = new SparseIntArray();
        }
        this.layouts.put(type, layoutResId);
    }

    @Override
    protected boolean isFixedViewType(int type) {
        return super.isFixedViewType(type) || type == 1092;
    }

    @Override
    public void onBindViewHolder(@NonNull K holder, int position) {
        switch (holder.getItemViewType()) {
            case 1092: {
                this.setFullSpan((RecyclerView.ViewHolder)holder);
                this.convertHead(holder, (SectionMultiEntity)this.getItem(position - this.getHeaderLayoutCount()));
                break;
            }
            default: {
                super.onBindViewHolder(holder, position);
            }
        }
    }

    protected abstract void convertHead(K var1, T var2);

    @Override
    public void remove(@IntRange(from=0L) int position) {
        if (this.mData == null || position < 0 || position >= this.mData.size()) {
            return;
        }
        SectionMultiEntity entity = (SectionMultiEntity)this.mData.get(position);
        if (entity instanceof IExpandable) {
            this.removeAllChild((IExpandable)((Object)entity), position);
        }
        this.removeDataFromParent(entity);
        super.remove(position);
    }

    protected void removeAllChild(IExpandable parent, int parentPosition) {
        if (parent.isExpanded()) {
            List chidChilds = parent.getSubItems();
            if (chidChilds == null || chidChilds.size() == 0) {
                return;
            }
            int childSize = chidChilds.size();
            for (int i = 0; i < childSize; ++i) {
                this.remove(parentPosition + 1);
            }
        }
    }

    protected void removeDataFromParent(T child) {
        int position = this.getParentPosition(child);
        if (position >= 0) {
            IExpandable parent = (IExpandable)this.mData.get(position);
            parent.getSubItems().remove(child);
        }
    }
}

