/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.loadmore;

import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import com.chad.library.adapter.base.BaseViewHolder;

public abstract class LoadMoreView {
    public static final int STATUS_DEFAULT = 1;
    public static final int STATUS_LOADING = 2;
    public static final int STATUS_FAIL = 3;
    public static final int STATUS_END = 4;
    private int mLoadMoreStatus = 1;
    private boolean mLoadMoreEndGone = false;

    public void setLoadMoreStatus(int loadMoreStatus) {
        this.mLoadMoreStatus = loadMoreStatus;
    }

    public int getLoadMoreStatus() {
        return this.mLoadMoreStatus;
    }

    public void convert(BaseViewHolder holder) {
        switch (this.mLoadMoreStatus) {
            case 2: {
                this.visibleLoading(holder, true);
                this.visibleLoadFail(holder, false);
                this.visibleLoadEnd(holder, false);
                break;
            }
            case 3: {
                this.visibleLoading(holder, false);
                this.visibleLoadFail(holder, true);
                this.visibleLoadEnd(holder, false);
                break;
            }
            case 4: {
                this.visibleLoading(holder, false);
                this.visibleLoadFail(holder, false);
                this.visibleLoadEnd(holder, true);
            }
        }
    }

    private void visibleLoading(BaseViewHolder holder, boolean visible) {
        holder.setVisible(this.getLoadingViewId(), visible);
    }

    private void visibleLoadFail(BaseViewHolder holder, boolean visible) {
        holder.setVisible(this.getLoadFailViewId(), visible);
    }

    private void visibleLoadEnd(BaseViewHolder holder, boolean visible) {
        int loadEndViewId = this.getLoadEndViewId();
        if (loadEndViewId != 0) {
            holder.setVisible(loadEndViewId, visible);
        }
    }

    public final void setLoadMoreEndGone(boolean loadMoreEndGone) {
        this.mLoadMoreEndGone = loadMoreEndGone;
    }

    public final boolean isLoadEndMoreGone() {
        if (this.getLoadEndViewId() == 0) {
            return true;
        }
        return this.mLoadMoreEndGone;
    }

    @Deprecated
    public boolean isLoadEndGone() {
        return this.mLoadMoreEndGone;
    }

    @LayoutRes
    public abstract int getLayoutId();

    @IdRes
    protected abstract int getLoadingViewId();

    @IdRes
    protected abstract int getLoadFailViewId();

    @IdRes
    protected abstract int getLoadEndViewId();
}

