/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.animation.AlphaInAnimation;
import com.chad.library.adapter.base.animation.BaseAnimation;
import com.chad.library.adapter.base.animation.ScaleInAnimation;
import com.chad.library.adapter.base.animation.SlideInBottomAnimation;
import com.chad.library.adapter.base.animation.SlideInLeftAnimation;
import com.chad.library.adapter.base.animation.SlideInRightAnimation;
import com.chad.library.adapter.base.entity.IExpandable;
import com.chad.library.adapter.base.loadmore.LoadMoreView;
import com.chad.library.adapter.base.loadmore.SimpleLoadMoreView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseQuickAdapter<T, K extends BaseViewHolder>
extends RecyclerView.Adapter<K> {
    private boolean mOpenLoadMore = false;
    private boolean mNextLoadEnable = false;
    private boolean mLoadMoreEnable = false;
    private boolean mLoading = false;
    private LoadMoreView mLoadMoreView = new SimpleLoadMoreView();
    private RequestLoadMoreListener mRequestLoadMoreListener;
    public static final int ALPHAIN = 1;
    public static final int SCALEIN = 2;
    public static final int SLIDEIN_BOTTOM = 3;
    public static final int SLIDEIN_LEFT = 4;
    public static final int SLIDEIN_RIGHT = 5;
    private boolean mFirstOnlyEnable = true;
    private boolean mOpenAnimationEnable = false;
    private Interpolator mInterpolator = new LinearInterpolator();
    private int mDuration = 300;
    private int mLastPosition = -1;
    private BaseAnimation mCustomAnimation;
    private BaseAnimation mSelectAnimation = new AlphaInAnimation();
    private LinearLayout mHeaderLayout;
    private LinearLayout mFooterLayout;
    private boolean mOpenEmpty = false;
    private FrameLayout mEmptyLayout;
    private boolean mIsUseEmpty = true;
    private boolean mHeadAndEmptyEnable;
    private boolean mFootAndEmptyEnable;
    protected static final String TAG = BaseQuickAdapter.class.getSimpleName();
    protected Context mContext;
    protected int mLayoutResId;
    protected LayoutInflater mLayoutInflater;
    protected List<T> mData;
    public static final int HEADER_VIEW = 273;
    public static final int LOADING_VIEW = 546;
    public static final int FOOTER_VIEW = 819;
    public static final int EMPTY_VIEW = 1365;
    private boolean flag = true;
    private SpanSizeLookup mSpanSizeLookup;
    private int mAutoLoadMoreSize = 1;

    public void setOnLoadMoreListener(RequestLoadMoreListener requestLoadMoreListener) {
        this.mRequestLoadMoreListener = requestLoadMoreListener;
        this.mNextLoadEnable = true;
        this.mLoadMoreEnable = true;
        this.mLoading = false;
    }

    public void setLoadMoreView(LoadMoreView loadingView) {
        this.mLoadMoreView = loadingView;
    }

    private int getLoadMoreViewCount() {
        if (this.mRequestLoadMoreListener == null || !this.mLoadMoreEnable) {
            return 0;
        }
        if (!this.mNextLoadEnable && this.mLoadMoreView.isLoadEndMoreGone()) {
            return 0;
        }
        if (!this.mOpenLoadMore) {
            return 0;
        }
        return 1;
    }

    public boolean isLoading() {
        return this.mLoading;
    }

    public void loadMoreEnd() {
        this.loadMoreEnd(false);
    }

    public void loadMoreEnd(boolean gone) {
        if (this.getLoadMoreViewCount() == 0) {
            return;
        }
        this.mLoading = false;
        this.mNextLoadEnable = false;
        this.mLoadMoreView.setLoadMoreEndGone(gone);
        if (gone) {
            this.notifyItemRemoved(this.getHeaderLayoutCount() + this.mData.size() + this.getFooterLayoutCount());
        } else {
            this.mLoadMoreView.setLoadMoreStatus(4);
            this.notifyItemChanged(this.getHeaderLayoutCount() + this.mData.size() + this.getFooterLayoutCount());
        }
    }

    public void loadMoreComplete() {
        if (this.getLoadMoreViewCount() == 0) {
            return;
        }
        this.mLoading = false;
        this.mLoadMoreView.setLoadMoreStatus(1);
        this.notifyItemChanged(this.getHeaderLayoutCount() + this.mData.size() + this.getFooterLayoutCount());
    }

    public void loadMoreFail() {
        if (this.getLoadMoreViewCount() == 0) {
            return;
        }
        this.mLoading = false;
        this.mLoadMoreView.setLoadMoreStatus(3);
        this.notifyItemChanged(this.getHeaderLayoutCount() + this.mData.size() + this.getFooterLayoutCount());
    }

    public void setEnableLoadMore(boolean enable) {
        int oldLoadMoreCount = this.getLoadMoreViewCount();
        this.mLoadMoreEnable = enable;
        int newLoadMoreCount = this.getLoadMoreViewCount();
        if (oldLoadMoreCount == 1) {
            if (newLoadMoreCount == 0) {
                this.notifyItemRemoved(this.getHeaderLayoutCount() + this.mData.size() + this.getFooterLayoutCount());
            }
        } else if (newLoadMoreCount == 1) {
            this.mLoadMoreView.setLoadMoreStatus(1);
            this.notifyItemInserted(this.getHeaderLayoutCount() + this.mData.size() + this.getFooterLayoutCount());
        }
    }

    public boolean isLoadMoreEnable() {
        return this.mLoadMoreEnable;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public BaseQuickAdapter(int layoutResId, List<T> data) {
        ArrayList arrayList = this.mData = data == null ? new ArrayList() : data;
        if (layoutResId != 0) {
            this.mLayoutResId = layoutResId;
        }
        this.openEmptyAndLoadMore();
    }

    public BaseQuickAdapter(List<T> data) {
        this(0, data);
    }

    private void openEmptyAndLoadMore() {
        if (this.mData == null || this.mData.size() == 0) {
            this.mOpenEmpty = true;
            this.mOpenLoadMore = false;
        } else {
            this.mOpenEmpty = false;
            this.mOpenLoadMore = true;
        }
    }

    public void remove(int position) {
        this.mData.remove(position);
        this.notifyItemRemoved(position + this.getHeaderLayoutCount());
    }

    public void add(int position, T item) {
        this.mData.add(position, item);
        this.notifyItemInserted(position + this.getHeaderLayoutCount());
    }

    public void setNewData(List<T> data) {
        this.mData = data == null ? new ArrayList() : data;
        this.openEmptyAndLoadMore();
        if (this.mRequestLoadMoreListener != null) {
            this.mNextLoadEnable = true;
            this.mLoadMoreEnable = true;
            this.mLoading = false;
            this.mLoadMoreView.setLoadMoreStatus(1);
        }
        this.mLastPosition = -1;
        this.notifyDataSetChanged();
    }

    public void addData(int position, T data) {
        this.mData.add(position, data);
        this.notifyItemInserted(position + this.getHeaderLayoutCount());
    }

    public void addData(T data) {
        this.mData.add(data);
        this.notifyItemInserted(this.mData.size() + this.getHeaderLayoutCount());
    }

    public void addData(int position, List<T> data) {
        this.mData.addAll(position, data);
        this.notifyItemRangeInserted(position + this.getHeaderLayoutCount(), data.size());
    }

    public void addData(List<T> newData) {
        this.mData.addAll(newData);
        this.notifyItemRangeInserted(this.mData.size() - newData.size() + this.getHeaderLayoutCount(), newData.size());
    }

    public List<T> getData() {
        return this.mData;
    }

    public T getItem(int position) {
        return this.mData.get(position);
    }

    @Deprecated
    public int getHeaderViewsCount() {
        return this.getHeaderLayoutCount();
    }

    @Deprecated
    public int getFooterViewsCount() {
        return this.getFooterLayoutCount();
    }

    public int getHeaderLayoutCount() {
        if (this.mHeaderLayout == null || this.mHeaderLayout.getChildCount() == 0) {
            return 0;
        }
        return 1;
    }

    public int getFooterLayoutCount() {
        if (this.mFooterLayout == null || this.mFooterLayout.getChildCount() == 0) {
            return 0;
        }
        return 1;
    }

    public int getEmptyViewCount() {
        if (this.mEmptyLayout == null || this.mEmptyLayout.getChildCount() == 0) {
            return 0;
        }
        if (!this.mIsUseEmpty) {
            return 0;
        }
        if (!this.mOpenEmpty) {
            return 0;
        }
        return 1;
    }

    public int getItemCount() {
        int count;
        if (this.getEmptyViewCount() == 1) {
            count = 1;
            if (this.mHeadAndEmptyEnable && this.getHeaderLayoutCount() != 0) {
                ++count;
            }
            if (this.mFootAndEmptyEnable && this.getFooterLayoutCount() != 0) {
                ++count;
            }
        } else {
            count = this.getHeaderLayoutCount() + this.mData.size() + this.getFooterLayoutCount() + this.getLoadMoreViewCount();
        }
        return count;
    }

    public int getItemViewType(int position) {
        if (this.getEmptyViewCount() == 1) {
            boolean header = this.mHeadAndEmptyEnable && this.getHeaderLayoutCount() != 0;
            switch (position) {
                case 0: {
                    if (header) {
                        return 273;
                    }
                    return 1365;
                }
                case 1: {
                    if (header) {
                        return 1365;
                    }
                    return 819;
                }
                case 2: {
                    return 819;
                }
            }
            return 1365;
        }
        this.autoLoadMore(position);
        int numHeaders = this.getHeaderLayoutCount();
        if (position < numHeaders) {
            return 273;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = this.mData.size();
        if (adjPosition < adapterCount) {
            return this.getDefItemViewType(adjPosition);
        }
        int numFooters = this.getFooterLayoutCount();
        if ((adjPosition -= adapterCount) < numFooters) {
            return 819;
        }
        return 546;
    }

    protected int getDefItemViewType(int position) {
        return super.getItemViewType(position);
    }

    public K onCreateViewHolder(ViewGroup parent, int viewType) {
        K baseViewHolder = null;
        this.mContext = parent.getContext();
        this.mLayoutInflater = LayoutInflater.from((Context)this.mContext);
        switch (viewType) {
            case 546: {
                baseViewHolder = this.getLoadingView(parent);
                break;
            }
            case 273: {
                baseViewHolder = this.createBaseViewHolder((View)this.mHeaderLayout);
                break;
            }
            case 1365: {
                baseViewHolder = this.createBaseViewHolder((View)this.mEmptyLayout);
                break;
            }
            case 819: {
                baseViewHolder = this.createBaseViewHolder((View)this.mFooterLayout);
                break;
            }
            default: {
                baseViewHolder = this.onCreateDefViewHolder(parent, viewType);
            }
        }
        return baseViewHolder;
    }

    private K getLoadingView(ViewGroup parent) {
        View view = this.getItemView(this.mLoadMoreView.getLayoutId(), parent);
        K holder = this.createBaseViewHolder(view);
        ((BaseViewHolder)((Object)holder)).itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseQuickAdapter.this.mLoadMoreView.getLoadMoreStatus() == 3) {
                    BaseQuickAdapter.this.mLoadMoreView.setLoadMoreStatus(1);
                    BaseQuickAdapter.this.notifyItemChanged(BaseQuickAdapter.this.getHeaderLayoutCount() + BaseQuickAdapter.this.mData.size() + BaseQuickAdapter.this.getFooterLayoutCount());
                }
            }
        });
        return holder;
    }

    public void onViewAttachedToWindow(K holder) {
        super.onViewAttachedToWindow(holder);
        int type = holder.getItemViewType();
        if (type == 1365 || type == 273 || type == 819 || type == 546) {
            this.setFullSpan((RecyclerView.ViewHolder)holder);
        } else {
            this.addAnimation((RecyclerView.ViewHolder)holder);
        }
    }

    protected void setFullSpan(RecyclerView.ViewHolder holder) {
        if (holder.itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams();
            params.setFullSpan(true);
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    int type = BaseQuickAdapter.this.getItemViewType(position);
                    if (BaseQuickAdapter.this.mSpanSizeLookup == null) {
                        return type == 1365 || type == 273 || type == 819 || type == 546 ? gridManager.getSpanCount() : 1;
                    }
                    return type == 1365 || type == 273 || type == 819 || type == 546 ? gridManager.getSpanCount() : BaseQuickAdapter.this.mSpanSizeLookup.getSpanSize(gridManager, position - BaseQuickAdapter.this.getHeaderLayoutCount());
                }
            });
        }
    }

    public void setSpanSizeLookup(SpanSizeLookup spanSizeLookup) {
        this.mSpanSizeLookup = spanSizeLookup;
    }

    public void onBindViewHolder(K holder, int positions) {
        int viewType = holder.getItemViewType();
        switch (viewType) {
            case 0: {
                this.convert(holder, this.mData.get(holder.getLayoutPosition() - this.getHeaderLayoutCount()));
                break;
            }
            case 546: {
                this.mLoadMoreView.convert((BaseViewHolder)((Object)holder));
                break;
            }
            case 273: {
                break;
            }
            case 1365: {
                break;
            }
            case 819: {
                break;
            }
            default: {
                this.convert(holder, this.mData.get(holder.getLayoutPosition() - this.getHeaderLayoutCount()));
            }
        }
    }

    protected K onCreateDefViewHolder(ViewGroup parent, int viewType) {
        return this.createBaseViewHolder(parent, this.mLayoutResId);
    }

    protected K createBaseViewHolder(ViewGroup parent, int layoutResId) {
        return this.createBaseViewHolder(this.getItemView(layoutResId, parent));
    }

    protected K createBaseViewHolder(View view) {
        return (K)((Object)new BaseViewHolder(view));
    }

    public LinearLayout getHeaderLayout() {
        return this.mHeaderLayout;
    }

    public LinearLayout getFooterLayout() {
        return this.mFooterLayout;
    }

    public void addHeaderView(View header) {
        this.addHeaderView(header, -1);
    }

    public void addHeaderView(View header, int index) {
        this.addHeaderView(header, index, 1);
    }

    public void addHeaderView(View header, int index, int orientation) {
        int position;
        if (this.mHeaderLayout == null) {
            this.mHeaderLayout = new LinearLayout(header.getContext());
            if (orientation == 1) {
                this.mHeaderLayout.setOrientation(1);
                this.mHeaderLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
            } else {
                this.mHeaderLayout.setOrientation(0);
                this.mHeaderLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-2, -1));
            }
        }
        index = index >= this.mHeaderLayout.getChildCount() ? -1 : index;
        this.mHeaderLayout.addView(header, index);
        if (this.mHeaderLayout.getChildCount() == 1 && (position = this.getHeaderViewPosition()) != -1) {
            this.notifyItemInserted(position);
        }
    }

    public void addFooterView(View footer) {
        this.addFooterView(footer, -1, 1);
    }

    public void addFooterView(View footer, int index) {
        this.addFooterView(footer, index, 1);
    }

    public void addFooterView(View footer, int index, int orientation) {
        int position;
        if (this.mFooterLayout == null) {
            this.mFooterLayout = new LinearLayout(footer.getContext());
            if (orientation == 1) {
                this.mFooterLayout.setOrientation(1);
                this.mFooterLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
            } else {
                this.mFooterLayout.setOrientation(0);
                this.mFooterLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-2, -1));
            }
        }
        index = index >= this.mFooterLayout.getChildCount() ? -1 : index;
        this.mFooterLayout.addView(footer, index);
        if (this.mFooterLayout.getChildCount() == 1 && (position = this.getFooterViewPosition()) != -1) {
            this.notifyItemInserted(position);
        }
    }

    public void removeHeaderView(View header) {
        int position;
        if (this.getHeaderLayoutCount() == 0) {
            return;
        }
        this.mHeaderLayout.removeView(header);
        if (this.mHeaderLayout.getChildCount() == 0 && (position = this.getHeaderViewPosition()) != -1) {
            this.notifyItemRemoved(position);
        }
    }

    public void removeFooterView(View footer) {
        int position;
        if (this.getFooterLayoutCount() == 0) {
            return;
        }
        this.mFooterLayout.removeView(footer);
        if (this.mFooterLayout.getChildCount() == 0 && (position = this.getFooterViewPosition()) != -1) {
            this.notifyItemRemoved(position);
        }
    }

    public void removeAllHeaderView() {
        if (this.getHeaderLayoutCount() == 0) {
            return;
        }
        this.mHeaderLayout.removeAllViews();
        int position = this.getHeaderViewPosition();
        if (position != -1) {
            this.notifyItemRemoved(position);
        }
    }

    public void removeAllFooterView() {
        if (this.getFooterLayoutCount() == 0) {
            return;
        }
        this.mFooterLayout.removeAllViews();
        int position = this.getFooterViewPosition();
        if (position != -1) {
            this.notifyItemRemoved(position);
        }
    }

    private int getHeaderViewPosition() {
        if (this.getEmptyViewCount() == 1) {
            if (this.mHeadAndEmptyEnable) {
                return 0;
            }
        } else {
            return 0;
        }
        return -1;
    }

    private int getFooterViewPosition() {
        if (this.getEmptyViewCount() == 1) {
            int position = 1;
            if (this.mHeadAndEmptyEnable && this.getHeaderLayoutCount() != 0) {
                ++position;
            }
            if (this.mFootAndEmptyEnable) {
                return position;
            }
        } else {
            return this.getHeaderLayoutCount() + this.mData.size();
        }
        return -1;
    }

    public void setEmptyView(View emptyView) {
        boolean insert = false;
        if (this.mEmptyLayout == null) {
            this.mEmptyLayout = new FrameLayout(emptyView.getContext());
            RecyclerView.LayoutParams layoutParams = new RecyclerView.LayoutParams(-1, -1);
            ViewGroup.LayoutParams lp = emptyView.getLayoutParams();
            if (lp != null) {
                layoutParams.width = lp.width;
                layoutParams.height = lp.height;
            }
            this.mEmptyLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            insert = true;
        }
        this.mEmptyLayout.removeAllViews();
        this.mEmptyLayout.addView(emptyView);
        this.mIsUseEmpty = true;
        if (insert && this.getEmptyViewCount() == 1) {
            int position = 0;
            if (this.mHeadAndEmptyEnable && this.getHeaderLayoutCount() != 0) {
                ++position;
            }
            this.notifyItemInserted(position);
        }
    }

    public void setHeaderAndEmpty(boolean isHeadAndEmpty) {
        this.setHeaderFooterEmpty(isHeadAndEmpty, false);
    }

    public void setHeaderFooterEmpty(boolean isHeadAndEmpty, boolean isFootAndEmpty) {
        this.mHeadAndEmptyEnable = isHeadAndEmpty;
        this.mFootAndEmptyEnable = isFootAndEmpty;
    }

    public void isUseEmpty(boolean isUseEmpty) {
        this.mIsUseEmpty = isUseEmpty;
    }

    public View getEmptyView() {
        return this.mEmptyLayout;
    }

    public void setAutoLoadMoreSize(int autoLoadMoreSize) {
        if (autoLoadMoreSize > 1) {
            this.mAutoLoadMoreSize = autoLoadMoreSize;
        }
    }

    private void autoLoadMore(int position) {
        if (this.getLoadMoreViewCount() == 0) {
            return;
        }
        if (position < this.getItemCount() - this.mAutoLoadMoreSize) {
            return;
        }
        if (this.mLoadMoreView.getLoadMoreStatus() != 1) {
            return;
        }
        this.mLoadMoreView.setLoadMoreStatus(2);
        if (!this.mLoading) {
            this.mLoading = true;
            this.mRequestLoadMoreListener.onLoadMoreRequested();
        }
    }

    private void addAnimation(RecyclerView.ViewHolder holder) {
        if (this.mOpenAnimationEnable && (!this.mFirstOnlyEnable || holder.getLayoutPosition() > this.mLastPosition)) {
            BaseAnimation animation = null;
            animation = this.mCustomAnimation != null ? this.mCustomAnimation : this.mSelectAnimation;
            for (Animator anim : animation.getAnimators(holder.itemView)) {
                this.startAnim(anim, holder.getLayoutPosition());
            }
            this.mLastPosition = holder.getLayoutPosition();
        }
    }

    protected void startAnim(Animator anim, int index) {
        anim.setDuration((long)this.mDuration).start();
        anim.setInterpolator((TimeInterpolator)this.mInterpolator);
    }

    protected View getItemView(int layoutResId, ViewGroup parent) {
        return this.mLayoutInflater.inflate(layoutResId, parent, false);
    }

    public void openLoadAnimation(int animationType) {
        this.mOpenAnimationEnable = true;
        this.mCustomAnimation = null;
        switch (animationType) {
            case 1: {
                this.mSelectAnimation = new AlphaInAnimation();
                break;
            }
            case 2: {
                this.mSelectAnimation = new ScaleInAnimation();
                break;
            }
            case 3: {
                this.mSelectAnimation = new SlideInBottomAnimation();
                break;
            }
            case 4: {
                this.mSelectAnimation = new SlideInLeftAnimation();
                break;
            }
            case 5: {
                this.mSelectAnimation = new SlideInRightAnimation();
                break;
            }
        }
    }

    public void openLoadAnimation(BaseAnimation animation) {
        this.mOpenAnimationEnable = true;
        this.mCustomAnimation = animation;
    }

    public void openLoadAnimation() {
        this.mOpenAnimationEnable = true;
    }

    public void isFirstOnly(boolean firstOnly) {
        this.mFirstOnlyEnable = firstOnly;
    }

    protected abstract void convert(K var1, T var2);

    public long getItemId(int position) {
        return position;
    }

    private int recursiveExpand(int position, @NonNull List list) {
        int count = 0;
        int pos = position + list.size() - 1;
        int i = list.size() - 1;
        while (i >= 0) {
            IExpandable item;
            if (list.get(i) instanceof IExpandable && (item = (IExpandable)list.get(i)).isExpanded() && this.hasSubItems(item)) {
                List subList = item.getSubItems();
                this.mData.addAll(pos + 1, subList);
                int subItemCount = this.recursiveExpand(pos + 1, subList);
                count += subItemCount;
            }
            --i;
            --pos;
        }
        return count;
    }

    public int expand(@IntRange(from=0L) int position, boolean animate, boolean shouldNotify) {
        IExpandable expandable = this.getExpandableItem(position -= this.getHeaderLayoutCount());
        if (expandable == null) {
            return 0;
        }
        if (!this.hasSubItems(expandable)) {
            expandable.setExpanded(false);
            return 0;
        }
        int subItemCount = 0;
        if (!expandable.isExpanded()) {
            List list = expandable.getSubItems();
            this.mData.addAll(position + 1, list);
            subItemCount += this.recursiveExpand(position + 1, list);
            expandable.setExpanded(true);
            subItemCount += list.size();
        }
        int parentPos = position + this.getHeaderLayoutCount();
        if (shouldNotify) {
            if (animate) {
                this.notifyItemChanged(parentPos);
                this.notifyItemRangeInserted(parentPos + 1, subItemCount);
            } else {
                this.notifyDataSetChanged();
            }
        }
        return subItemCount;
    }

    public int expand(@IntRange(from=0L) int position, boolean animate) {
        return this.expand(position, animate, true);
    }

    public int expand(@IntRange(from=0L) int position) {
        return this.expand(position, true, true);
    }

    public int expandAll(int position, boolean animate, boolean notify) {
        T item;
        IExpandable expandable;
        Object endItem = null;
        if ((position -= this.getHeaderLayoutCount()) + 1 < this.mData.size()) {
            endItem = this.getItem(position + 1);
        }
        if (!this.hasSubItems(expandable = this.getExpandableItem(position))) {
            return 0;
        }
        int count = this.expand(position + this.getHeaderLayoutCount(), false, false);
        for (int i = position + 1; i < this.mData.size() && (item = this.getItem(i)) != endItem; ++i) {
            if (!this.isExpandable(item)) continue;
            count += this.expand(i + this.getHeaderLayoutCount(), false, false);
        }
        if (notify) {
            if (animate) {
                this.notifyItemRangeInserted(position + this.getHeaderLayoutCount() + 1, count);
            } else {
                this.notifyDataSetChanged();
            }
        }
        return count;
    }

    public int expandAll(int position, boolean init) {
        return this.expandAll(position, true, !init);
    }

    private int recursiveCollapse(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (!this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        int subItemCount = 0;
        if (expandable.isExpanded()) {
            List subItems = expandable.getSubItems();
            for (int i = subItems.size() - 1; i >= 0; --i) {
                Object subItem = subItems.get(i);
                int pos = this.getItemPosition(subItem);
                if (pos < 0) continue;
                if (subItem instanceof IExpandable) {
                    subItemCount += this.recursiveCollapse(pos);
                }
                this.mData.remove(pos);
                ++subItemCount;
            }
        }
        return subItemCount;
    }

    public int collapse(@IntRange(from=0L) int position, boolean animate, boolean notify) {
        IExpandable expandable = this.getExpandableItem(position -= this.getHeaderLayoutCount());
        if (expandable == null) {
            return 0;
        }
        int subItemCount = this.recursiveCollapse(position);
        expandable.setExpanded(false);
        int parentPos = position + this.getHeaderLayoutCount();
        if (notify) {
            if (animate) {
                this.notifyItemChanged(parentPos);
                this.notifyItemRangeRemoved(parentPos + 1, subItemCount);
            } else {
                this.notifyDataSetChanged();
            }
        }
        return subItemCount;
    }

    public int collapse(@IntRange(from=0L) int position) {
        return this.collapse(position, true, true);
    }

    public int collapse(@IntRange(from=0L) int position, boolean animate) {
        return this.collapse(position, animate, true);
    }

    private int getItemPosition(T item) {
        return item != null && this.mData != null && !this.mData.isEmpty() ? this.mData.indexOf(item) : -1;
    }

    private boolean hasSubItems(IExpandable item) {
        List list = item.getSubItems();
        return list != null && list.size() > 0;
    }

    private boolean isExpandable(T item) {
        return item != null && item instanceof IExpandable;
    }

    private IExpandable getExpandableItem(int position) {
        T item = this.getItem(position);
        if (this.isExpandable(item)) {
            return (IExpandable)item;
        }
        return null;
    }

    public int getParentPosition(@NonNull T item) {
        int position = this.getItemPosition(item);
        if (position == -1) {
            return -1;
        }
        int level = item instanceof IExpandable ? ((IExpandable)item).getLevel() : Integer.MAX_VALUE;
        if (level == 0) {
            return position;
        }
        if (level == -1) {
            return -1;
        }
        for (int i = position; i >= 0; --i) {
            IExpandable expandable;
            T temp = this.mData.get(i);
            if (!(temp instanceof IExpandable) || (expandable = (IExpandable)temp).getLevel() < 0 || expandable.getLevel() >= level) continue;
            return i;
        }
        return -1;
    }

    public static interface RequestLoadMoreListener {
        public void onLoadMoreRequested();
    }

    public static interface SpanSizeLookup {
        public int getSpanSize(GridLayoutManager var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnimationType {
    }
}

