/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.chad.library.R;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.animation.AlphaInAnimation;
import com.chad.library.adapter.base.animation.BaseAnimation;
import com.chad.library.adapter.base.animation.ScaleInAnimation;
import com.chad.library.adapter.base.animation.SlideInBottomAnimation;
import com.chad.library.adapter.base.animation.SlideInLeftAnimation;
import com.chad.library.adapter.base.animation.SlideInRightAnimation;
import com.chad.library.adapter.base.listener.OnItemDragListener;
import com.chad.library.adapter.base.listener.OnItemSwipeListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseQuickAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private boolean mNextLoadEnable = false;
    private boolean mLoadingMoreEnable = false;
    private boolean mFirstOnlyEnable = true;
    private boolean mOpenAnimationEnable = false;
    private boolean mEmptyEnable;
    private boolean mHeadAndEmptyEnable;
    private boolean mFootAndEmptyEnable;
    private Interpolator mInterpolator = new LinearInterpolator();
    private int mDuration = 300;
    private int mLastPosition = -1;
    private OnRecyclerViewItemClickListener onRecyclerViewItemClickListener;
    private OnRecyclerViewItemLongClickListener onRecyclerViewItemLongClickListener;
    private RequestLoadMoreListener mRequestLoadMoreListener;
    private BaseAnimation mCustomAnimation;
    private BaseAnimation mSelectAnimation = new AlphaInAnimation();
    private View mHeaderView;
    private View mFooterView;
    private int pageSize = -1;
    private View mContentView;
    private View mEmptyView;
    protected static final String TAG = BaseQuickAdapter.class.getSimpleName();
    protected Context mContext;
    protected int mLayoutResId;
    protected LayoutInflater mLayoutInflater;
    protected List<T> mData;
    protected static final int HEADER_VIEW = 273;
    protected static final int LOADING_VIEW = 546;
    protected static final int FOOTER_VIEW = 819;
    protected static final int EMPTY_VIEW = 1365;
    private View mLoadingView;
    public static final int ALPHAIN = 1;
    public static final int SCALEIN = 2;
    public static final int SLIDEIN_BOTTOM = 3;
    public static final int SLIDEIN_LEFT = 4;
    public static final int SLIDEIN_RIGHT = 5;
    private static final int NO_TOGGLE_VIEW = 0;
    private int mToggleViewId = 0;
    private ItemTouchHelper mItemTouchHelper;
    private boolean itemDragEnabled = false;
    private boolean itemSwipeEnabled = false;
    private OnItemDragListener mOnItemDragListener;
    private OnItemSwipeListener mOnItemSwipeListener;
    private boolean mDragOnLongPress = true;
    private View.OnTouchListener mOnToggleViewTouchListener;
    private View.OnLongClickListener mOnToggleViewLongClickListener;
    private static final String ERROR_NOT_SAME_ITEMTOUCHHELPER = "Item drag and item swipe should pass the same ItemTouchHelper";
    private OnRecyclerViewItemChildClickListener mChildClickListener;

    @Deprecated
    public void setOnLoadMoreListener(int pageSize, RequestLoadMoreListener requestLoadMoreListener) {
        this.setOnLoadMoreListener(requestLoadMoreListener);
    }

    public void setOnLoadMoreListener(RequestLoadMoreListener requestLoadMoreListener) {
        this.mRequestLoadMoreListener = requestLoadMoreListener;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public void openLoadMore(int pageSize, boolean enable) {
        this.pageSize = pageSize;
        this.mNextLoadEnable = enable;
    }

    public void openLoadMore(boolean enable) {
        this.mNextLoadEnable = enable;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setOnRecyclerViewItemClickListener(OnRecyclerViewItemClickListener onRecyclerViewItemClickListener) {
        this.onRecyclerViewItemClickListener = onRecyclerViewItemClickListener;
    }

    public void setOnRecyclerViewItemLongClickListener(OnRecyclerViewItemLongClickListener onRecyclerViewItemLongClickListener) {
        this.onRecyclerViewItemLongClickListener = onRecyclerViewItemLongClickListener;
    }

    public void setOnRecyclerViewItemChildClickListener(OnRecyclerViewItemChildClickListener childClickListener) {
        this.mChildClickListener = childClickListener;
    }

    public BaseQuickAdapter(int layoutResId, List<T> data) {
        ArrayList arrayList = this.mData = data == null ? new ArrayList() : data;
        if (layoutResId != 0) {
            this.mLayoutResId = layoutResId;
        }
    }

    public BaseQuickAdapter(List<T> data) {
        this(0, data);
    }

    public BaseQuickAdapter(View contentView, List<T> data) {
        this(0, data);
        this.mContentView = contentView;
    }

    public void remove(int position) {
        this.mData.remove(position);
        this.notifyItemRemoved(position + this.getHeaderViewsCount());
    }

    public void add(int position, T item) {
        this.mData.add(position, item);
        this.notifyItemInserted(position);
    }

    public void setNewData(List<T> data) {
        this.mData = data;
        if (this.mRequestLoadMoreListener != null) {
            this.mNextLoadEnable = true;
            this.mFooterView = null;
        }
        this.mLastPosition = -1;
        this.notifyDataSetChanged();
    }

    public void addData(List<T> data) {
        this.mData.addAll(data);
        this.notifyDataSetChanged();
    }

    public void setLoadingView(View loadingView) {
        this.mLoadingView = loadingView;
    }

    public List getData() {
        return this.mData;
    }

    public T getItem(int position) {
        return this.mData.get(position);
    }

    public int getHeaderViewsCount() {
        return this.mHeaderView == null ? 0 : 1;
    }

    public int getFooterViewsCount() {
        return this.mFooterView == null ? 0 : 1;
    }

    public int getmEmptyViewCount() {
        return this.mEmptyView == null ? 0 : 1;
    }

    public int getItemCount() {
        int i = this.isLoadMore() ? 1 : 0;
        int count = this.mData.size() + i + this.getHeaderViewsCount() + this.getFooterViewsCount();
        if (this.mData.size() == 0 && this.mEmptyView != null) {
            if (!(count != 0 || this.mHeadAndEmptyEnable && this.mFootAndEmptyEnable)) {
                count += this.getmEmptyViewCount();
            } else if (this.mHeadAndEmptyEnable || this.mFootAndEmptyEnable) {
                count += this.getmEmptyViewCount();
            }
            if (this.mHeadAndEmptyEnable && this.getHeaderViewsCount() == 1 && count == 1 || count == 0) {
                this.mEmptyEnable = true;
                count += this.getmEmptyViewCount();
            }
        }
        return count;
    }

    public int getItemViewType(int position) {
        if (this.mHeaderView != null && position == 0) {
            return 273;
        }
        if (this.mData.size() == 0 && this.mEmptyEnable && this.mEmptyView != null && position <= 2) {
            if ((this.mHeadAndEmptyEnable || this.mFootAndEmptyEnable) && position == 1) {
                if (this.mHeaderView == null && this.mEmptyView != null && this.mFooterView != null) {
                    return 819;
                }
                if (this.mHeaderView != null && this.mEmptyView != null) {
                    return 1365;
                }
            } else if (position == 0) {
                if (this.mHeaderView == null) {
                    return 1365;
                }
                if (this.mFooterView != null) {
                    return 1365;
                }
            } else {
                if (position == 2 && (this.mFootAndEmptyEnable || this.mHeadAndEmptyEnable) && this.mHeaderView != null && this.mEmptyView != null) {
                    return 819;
                }
                if (!(this.mFootAndEmptyEnable && this.mHeadAndEmptyEnable || position != 1 || this.mFooterView == null)) {
                    return 819;
                }
            }
        } else {
            if (this.mData.size() == 0 && this.mEmptyView != null && this.getItemCount() == (this.mHeadAndEmptyEnable ? 2 : 1) && this.mEmptyEnable) {
                return 1365;
            }
            if (position == this.mData.size() + this.getHeaderViewsCount()) {
                if (this.mNextLoadEnable) {
                    return 546;
                }
                return 819;
            }
        }
        return this.getDefItemViewType(position - this.getHeaderViewsCount());
    }

    protected int getDefItemViewType(int position) {
        return super.getItemViewType(position);
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        BaseViewHolder baseViewHolder = null;
        this.mContext = parent.getContext();
        this.mLayoutInflater = LayoutInflater.from((Context)this.mContext);
        switch (viewType) {
            case 546: {
                baseViewHolder = this.getLoadingView(parent);
                break;
            }
            case 273: {
                baseViewHolder = new BaseViewHolder(this.mHeaderView);
                break;
            }
            case 1365: {
                baseViewHolder = new BaseViewHolder(this.mEmptyView);
                break;
            }
            case 819: {
                baseViewHolder = new BaseViewHolder(this.mFooterView);
                break;
            }
            default: {
                baseViewHolder = this.onCreateDefViewHolder(parent, viewType);
                this.initItemClickListener(baseViewHolder);
            }
        }
        return baseViewHolder;
    }

    private BaseViewHolder getLoadingView(ViewGroup parent) {
        if (this.mLoadingView == null) {
            return this.createBaseViewHolder(parent, R.layout.def_loading);
        }
        return new BaseViewHolder(this.mLoadingView);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        int type = holder.getItemViewType();
        if (type == 1365 || type == 273 || type == 819 || type == 546) {
            this.setFullSpan(holder);
        }
    }

    protected void setFullSpan(RecyclerView.ViewHolder holder) {
        if (holder.itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams();
            params.setFullSpan(true);
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    int type = BaseQuickAdapter.this.getItemViewType(position);
                    return type == 1365 || type == 273 || type == 819 || type == 546 ? gridManager.getSpanCount() : 1;
                }
            });
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int positions) {
        int viewType = holder.getItemViewType();
        switch (viewType) {
            case 0: {
                this.convert((BaseViewHolder)holder, this.mData.get(holder.getLayoutPosition() - this.getHeaderViewsCount()));
                this.addAnimation(holder);
                break;
            }
            case 546: {
                this.addLoadMore(holder);
                break;
            }
            case 273: {
                break;
            }
            case 1365: {
                break;
            }
            case 819: {
                break;
            }
            default: {
                this.convert((BaseViewHolder)holder, this.mData.get(holder.getLayoutPosition() - this.getHeaderViewsCount()));
                this.onBindDefViewHolder((BaseViewHolder)holder, this.mData.get(holder.getLayoutPosition() - this.getHeaderViewsCount()));
            }
        }
        if (this.mItemTouchHelper != null && this.itemDragEnabled && viewType != 546 && viewType != 273 && viewType != 1365 && viewType != 819) {
            if (this.mToggleViewId != 0) {
                Object toggleView = ((BaseViewHolder)holder).getView(this.mToggleViewId);
                if (toggleView != null) {
                    toggleView.setTag(R.id.BaseQuickAdapter_viewholder_support, (Object)holder);
                    if (this.mDragOnLongPress) {
                        toggleView.setOnLongClickListener(this.mOnToggleViewLongClickListener);
                    } else {
                        toggleView.setOnTouchListener(this.mOnToggleViewTouchListener);
                    }
                }
            } else {
                holder.itemView.setTag(R.id.BaseQuickAdapter_viewholder_support, (Object)holder);
                holder.itemView.setOnLongClickListener(this.mOnToggleViewLongClickListener);
            }
        }
    }

    protected BaseViewHolder onCreateDefViewHolder(ViewGroup parent, int viewType) {
        return this.createBaseViewHolder(parent, this.mLayoutResId);
    }

    protected BaseViewHolder createBaseViewHolder(ViewGroup parent, int layoutResId) {
        if (this.mContentView == null) {
            return new BaseViewHolder(this.getItemView(layoutResId, parent));
        }
        return new BaseViewHolder(this.mContentView);
    }

    public void addHeaderView(View header) {
        this.mHeaderView = header;
        this.notifyDataSetChanged();
    }

    public void addFooterView(View footer) {
        this.mNextLoadEnable = false;
        this.mFooterView = footer;
        this.notifyDataSetChanged();
    }

    public void setEmptyView(View emptyView) {
        this.setEmptyView(false, false, emptyView);
    }

    public void setEmptyView(boolean isHeadAndEmpty, View emptyView) {
        this.setEmptyView(isHeadAndEmpty, false, emptyView);
    }

    public void setEmptyView(boolean isHeadAndEmpty, boolean isFootAndEmpty, View emptyView) {
        this.mHeadAndEmptyEnable = isHeadAndEmpty;
        this.mFootAndEmptyEnable = isFootAndEmpty;
        this.mEmptyView = emptyView;
        this.mEmptyEnable = true;
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    @Deprecated
    public void isNextLoad(boolean isNextLoad) {
        this.mNextLoadEnable = isNextLoad;
        this.mLoadingMoreEnable = false;
        this.notifyDataSetChanged();
    }

    public void notifyDataChangedAfterLoadMore(boolean isNextLoad) {
        this.mNextLoadEnable = isNextLoad;
        this.mLoadingMoreEnable = false;
        this.notifyDataSetChanged();
    }

    public void notifyDataChangedAfterLoadMore(List<T> data, boolean isNextLoad) {
        this.mData.addAll(data);
        this.notifyDataChangedAfterLoadMore(isNextLoad);
    }

    private void addLoadMore(RecyclerView.ViewHolder holder) {
        if (this.isLoadMore() && !this.mLoadingMoreEnable) {
            this.mLoadingMoreEnable = true;
            this.mRequestLoadMoreListener.onLoadMoreRequested();
        }
    }

    private void initItemClickListener(final BaseViewHolder baseViewHolder) {
        if (this.onRecyclerViewItemClickListener != null) {
            baseViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseQuickAdapter.this.onRecyclerViewItemClickListener.onItemClick(v, baseViewHolder.getLayoutPosition() - BaseQuickAdapter.this.getHeaderViewsCount());
                }
            });
        }
        if (this.onRecyclerViewItemLongClickListener != null) {
            baseViewHolder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return BaseQuickAdapter.this.onRecyclerViewItemLongClickListener.onItemLongClick(v, baseViewHolder.getLayoutPosition() - BaseQuickAdapter.this.getHeaderViewsCount());
                }
            });
        }
    }

    private void addAnimation(RecyclerView.ViewHolder holder) {
        if (this.mOpenAnimationEnable && (!this.mFirstOnlyEnable || holder.getLayoutPosition() > this.mLastPosition)) {
            BaseAnimation animation = null;
            animation = this.mCustomAnimation != null ? this.mCustomAnimation : this.mSelectAnimation;
            for (Animator anim : animation.getAnimators(holder.itemView)) {
                this.startAnim(anim, holder.getLayoutPosition());
            }
            this.mLastPosition = holder.getLayoutPosition();
        }
    }

    protected void startAnim(Animator anim, int index) {
        anim.setDuration((long)this.mDuration).start();
        anim.setInterpolator((TimeInterpolator)this.mInterpolator);
    }

    private boolean isLoadMore() {
        return this.mNextLoadEnable && this.pageSize != -1 && this.mRequestLoadMoreListener != null && this.mData.size() >= this.pageSize;
    }

    protected View getItemView(int layoutResId, ViewGroup parent) {
        return this.mLayoutInflater.inflate(layoutResId, parent, false);
    }

    @Deprecated
    protected void onBindDefViewHolder(BaseViewHolder holder, T item) {
    }

    public void openLoadAnimation(int animationType) {
        this.mOpenAnimationEnable = true;
        this.mCustomAnimation = null;
        switch (animationType) {
            case 1: {
                this.mSelectAnimation = new AlphaInAnimation();
                break;
            }
            case 2: {
                this.mSelectAnimation = new ScaleInAnimation();
                break;
            }
            case 3: {
                this.mSelectAnimation = new SlideInBottomAnimation();
                break;
            }
            case 4: {
                this.mSelectAnimation = new SlideInLeftAnimation();
                break;
            }
            case 5: {
                this.mSelectAnimation = new SlideInRightAnimation();
                break;
            }
        }
    }

    public void openLoadAnimation(BaseAnimation animation) {
        this.mOpenAnimationEnable = true;
        this.mCustomAnimation = animation;
    }

    public void openLoadAnimation() {
        this.mOpenAnimationEnable = true;
    }

    public void isFirstOnly(boolean firstOnly) {
        this.mFirstOnlyEnable = firstOnly;
    }

    protected abstract void convert(BaseViewHolder var1, T var2);

    public long getItemId(int position) {
        return position;
    }

    public void setToggleViewId(int toggleViewId) {
        this.mToggleViewId = toggleViewId;
    }

    public void setToggleDragOnLongPress(boolean longPress) {
        this.mDragOnLongPress = longPress;
        if (this.mDragOnLongPress) {
            this.mOnToggleViewTouchListener = null;
            this.mOnToggleViewLongClickListener = new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (BaseQuickAdapter.this.mItemTouchHelper != null && BaseQuickAdapter.this.itemDragEnabled) {
                        BaseQuickAdapter.this.mItemTouchHelper.startDrag((RecyclerView.ViewHolder)v.getTag(R.id.BaseQuickAdapter_viewholder_support));
                    }
                    return true;
                }
            };
        } else {
            this.mOnToggleViewTouchListener = new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (MotionEventCompat.getActionMasked((MotionEvent)event) == 0 && !BaseQuickAdapter.this.mDragOnLongPress) {
                        if (BaseQuickAdapter.this.mItemTouchHelper != null && BaseQuickAdapter.this.itemDragEnabled) {
                            BaseQuickAdapter.this.mItemTouchHelper.startDrag((RecyclerView.ViewHolder)v.getTag(R.id.BaseQuickAdapter_viewholder_support));
                        }
                        return true;
                    }
                    return false;
                }
            };
            this.mOnToggleViewLongClickListener = null;
        }
    }

    public void enableDragItem(@NonNull ItemTouchHelper itemTouchHelper) {
        this.enableDragItem(itemTouchHelper, 0, true);
    }

    public void enableDragItem(@NonNull ItemTouchHelper itemTouchHelper, int toggleViewId, boolean dragOnLongPress) {
        this.itemDragEnabled = true;
        this.mItemTouchHelper = itemTouchHelper;
        this.setToggleViewId(toggleViewId);
        this.setToggleDragOnLongPress(dragOnLongPress);
    }

    public void disableDragItem() {
        this.itemDragEnabled = false;
        this.mItemTouchHelper = null;
    }

    public boolean isItemDraggable() {
        return this.itemDragEnabled;
    }

    public void enableSwipeItem() {
        this.itemSwipeEnabled = true;
    }

    public void disableSwipeItem() {
        this.itemSwipeEnabled = false;
    }

    public boolean isItemSwipeEnable() {
        return this.itemSwipeEnabled;
    }

    public void setOnItemDragListener(OnItemDragListener onItemDragListener) {
        this.mOnItemDragListener = onItemDragListener;
    }

    public int getViewHolderPosition(RecyclerView.ViewHolder viewHolder) {
        return viewHolder.getAdapterPosition() - this.getHeaderViewsCount();
    }

    public void onItemDragStart(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemDragListener != null && this.itemDragEnabled) {
            this.mOnItemDragListener.onItemDragStart(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    public void onItemDragMoving(RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
        int to;
        int from = this.getViewHolderPosition(source);
        if (from < (to = this.getViewHolderPosition(target))) {
            for (int i = from; i < to; ++i) {
                Collections.swap(this.mData, i, i + 1);
            }
        } else {
            for (int i = from; i > to; --i) {
                Collections.swap(this.mData, i, i - 1);
            }
        }
        this.notifyItemMoved(source.getAdapterPosition(), target.getAdapterPosition());
        if (this.mOnItemDragListener != null && this.itemDragEnabled) {
            this.mOnItemDragListener.onItemDragMoving(source, from, target, to);
        }
    }

    public void onItemDragEnd(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemDragListener != null && this.itemDragEnabled) {
            this.mOnItemDragListener.onItemDragEnd(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    public void setOnItemSwipeListener(OnItemSwipeListener listener) {
        this.mOnItemSwipeListener = listener;
    }

    public void onItemSwipeStart(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.onItemSwipeStart(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    public void onItemSwipeClear(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.clearView(viewHolder, this.getViewHolderPosition(viewHolder));
        }
    }

    public void onItemSwiped(RecyclerView.ViewHolder viewHolder) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.onItemSwiped(viewHolder, this.getViewHolderPosition(viewHolder));
        }
        int pos = this.getViewHolderPosition(viewHolder);
        this.mData.remove(pos);
        this.notifyItemRemoved(viewHolder.getAdapterPosition());
    }

    public void onItemSwiping(Canvas canvas, RecyclerView.ViewHolder viewHolder, float dX, float dY, boolean isCurrentlyActive) {
        if (this.mOnItemSwipeListener != null && this.itemSwipeEnabled) {
            this.mOnItemSwipeListener.onItemSwipeMoving(canvas, viewHolder, dX, dY, isCurrentlyActive);
        }
    }

    public static interface RequestLoadMoreListener {
        public void onLoadMoreRequested();
    }

    public class OnItemChildClickListener
    implements View.OnClickListener {
        public RecyclerView.ViewHolder mViewHolder;

        public void onClick(View v) {
            if (BaseQuickAdapter.this.mChildClickListener != null) {
                BaseQuickAdapter.this.mChildClickListener.onItemChildClick(BaseQuickAdapter.this, v, this.mViewHolder.getLayoutPosition() - BaseQuickAdapter.this.getHeaderViewsCount());
            }
        }
    }

    public static interface OnRecyclerViewItemChildClickListener {
        public void onItemChildClick(BaseQuickAdapter var1, View var2, int var3);
    }

    public static interface OnRecyclerViewItemLongClickListener {
        public boolean onItemLongClick(View var1, int var2);
    }

    public static interface OnRecyclerViewItemClickListener {
        public void onItemClick(View var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnimationType {
    }
}

