/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.chad.library.R;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.animation.AlphaInAnimation;
import com.chad.library.adapter.base.animation.BaseAnimation;
import com.chad.library.adapter.base.animation.ScaleInAnimation;
import com.chad.library.adapter.base.animation.SlideInBottomAnimation;
import com.chad.library.adapter.base.animation.SlideInLeftAnimation;
import com.chad.library.adapter.base.animation.SlideInRightAnimation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseQuickAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private boolean mNextLoadEnable;
    private boolean mLoadingMoreEnable = false;
    private boolean mFirstOnlyEnable = true;
    private boolean mOpenAnimationEnable = false;
    public static final int ALPHAIN = 1;
    public static final int SCALEIN = 2;
    public static final int SLIDEIN_BOTTOM = 3;
    public static final int SLIDEIN_LEFT = 4;
    public static final int SLIDEIN_RIGHT = 5;
    protected static final String TAG = BaseQuickAdapter.class.getSimpleName();
    protected Context mContext;
    protected int mLayoutResId;
    protected List<T> mData;
    private Interpolator mInterpolator = new LinearInterpolator();
    private int mDuration = 300;
    private int mLastPosition = -1;
    private OnRecyclerViewItemClickListener onRecyclerViewItemClickListener;
    private RequestLoadMoreListener mRequestLoadMoreListener;
    private BaseAnimation mCustomAnimation;
    private BaseAnimation mSelectAnimation = new AlphaInAnimation();
    protected static final int HEADER_VIEW = 273;
    protected static final int LOADING_VIEW = 546;
    protected static final int FOOTER_VIEW = 819;
    private View mHeaderView;
    private View mFooterView;

    @Deprecated
    public void setOnLoadMoreListener(int pageSize, RequestLoadMoreListener requestLoadMoreListener) {
        this.setOnLoadMoreListener(requestLoadMoreListener);
    }

    public void setOnLoadMoreListener(RequestLoadMoreListener requestLoadMoreListener) {
        this.mNextLoadEnable = true;
        this.mRequestLoadMoreListener = requestLoadMoreListener;
    }

    public void setOnRecyclerViewItemClickListener(OnRecyclerViewItemClickListener onRecyclerViewItemClickListener) {
        this.onRecyclerViewItemClickListener = onRecyclerViewItemClickListener;
    }

    public BaseQuickAdapter(Context context, int layoutResId, List<T> data) {
        this.mData = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.mContext = context;
        this.mLayoutResId = layoutResId;
    }

    public BaseQuickAdapter(Context context, List<T> data) {
        this.mData = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.mContext = context;
    }

    public void remove(int position) {
        this.mData.remove(position);
        this.notifyItemRemoved(position);
    }

    public void add(int position, T item) {
        this.mData.add(position, item);
        this.notifyItemInserted(position);
    }

    public List getData() {
        return this.mData;
    }

    public int getHeaderViewsCount() {
        return this.mHeaderView == null ? 0 : 1;
    }

    public int getFooterViewsCount() {
        return this.mFooterView == null ? 0 : 1;
    }

    public int getItemCount() {
        int i = this.mNextLoadEnable ? 1 : 0;
        return this.mData.size() + i + this.getHeaderViewsCount() + this.getFooterViewsCount();
    }

    public int getItemViewType(int position) {
        if (this.mHeaderView != null && position == 0) {
            return 273;
        }
        if (position == this.mData.size() + this.getHeaderViewsCount()) {
            if (this.mNextLoadEnable) {
                return 546;
            }
            return 819;
        }
        return this.getDefItemViewType(position);
    }

    protected int getDefItemViewType(int position) {
        return super.getItemViewType(position);
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return this.onCreateDefViewHolder(parent, viewType);
        }
        if (viewType == 546) {
            return new FooterViewHolder(this.getItemView(R.layout.def_loading, parent));
        }
        if (viewType == 273) {
            return new HeadViewHolder(this.mHeaderView);
        }
        if (viewType == 819) {
            return new FooterViewHolder(this.mFooterView);
        }
        return this.onCreateDefViewHolder(parent, viewType);
    }

    protected BaseViewHolder onCreateDefViewHolder(ViewGroup parent, int viewType) {
        return new ContentViewHolder(this.getItemView(this.mLayoutResId, parent));
    }

    public void addHeaderView(View header) {
        if (header == null) {
            throw new RuntimeException("header is null");
        }
        this.mHeaderView = header;
        this.notifyDataSetChanged();
    }

    public void addFooterView(View footer) {
        this.mNextLoadEnable = false;
        if (footer == null) {
            throw new RuntimeException("footer is null");
        }
        this.mFooterView = footer;
        this.notifyDataSetChanged();
    }

    public void isNextLoad(boolean isNextLoad) {
        this.mNextLoadEnable = isNextLoad;
        this.mLoadingMoreEnable = false;
        this.notifyDataSetChanged();
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {
        if (holder instanceof ContentViewHolder) {
            int index = position - this.getHeaderViewsCount();
            BaseViewHolder baseViewHolder = (BaseViewHolder)holder;
            this.convert(baseViewHolder, this.mData.get(index));
            if (this.onRecyclerViewItemClickListener != null) {
                baseViewHolder.convertView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        BaseQuickAdapter.this.onRecyclerViewItemClickListener.onItemClick(v, position - BaseQuickAdapter.this.getHeaderViewsCount());
                    }
                });
            }
            if (this.mOpenAnimationEnable && (!this.mFirstOnlyEnable || position > this.mLastPosition)) {
                BaseAnimation animation = null;
                animation = this.mCustomAnimation != null ? this.mCustomAnimation : this.mSelectAnimation;
                for (Animator anim : animation.getAnimators(holder.itemView)) {
                    anim.setDuration((long)this.mDuration).start();
                    anim.setInterpolator((TimeInterpolator)this.mInterpolator);
                }
                this.mLastPosition = position;
            }
        } else if (holder instanceof FooterViewHolder) {
            if (this.mNextLoadEnable && !this.mLoadingMoreEnable && this.mRequestLoadMoreListener != null) {
                this.mLoadingMoreEnable = true;
                this.mRequestLoadMoreListener.onLoadMoreRequested();
                if (holder.itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
                    StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)holder.itemView.getLayoutParams();
                    params.setFullSpan(true);
                }
            }
        } else if (!(holder instanceof HeadViewHolder)) {
            int index = position - this.getHeaderViewsCount();
            BaseViewHolder baseViewHolder = (BaseViewHolder)holder;
            this.onBindDefViewHolder(baseViewHolder, this.mData.get(index));
        }
    }

    protected View getItemView(int layoutResId, ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(layoutResId, parent, false);
    }

    protected void onBindDefViewHolder(BaseViewHolder holder, T item) {
    }

    public void openLoadAnimation(int animationType) {
        this.mOpenAnimationEnable = true;
        this.mCustomAnimation = null;
        switch (animationType) {
            case 1: {
                this.mSelectAnimation = new AlphaInAnimation();
                break;
            }
            case 2: {
                this.mSelectAnimation = new ScaleInAnimation();
                break;
            }
            case 3: {
                this.mSelectAnimation = new SlideInBottomAnimation();
                break;
            }
            case 4: {
                this.mSelectAnimation = new SlideInLeftAnimation();
                break;
            }
            case 5: {
                this.mSelectAnimation = new SlideInRightAnimation();
            }
        }
    }

    public void openLoadAnimation(BaseAnimation animation) {
        this.mOpenAnimationEnable = true;
        this.mCustomAnimation = animation;
    }

    public void openLoadAnimation() {
        this.mOpenAnimationEnable = true;
    }

    public void isFirstOnly(boolean firstOnly) {
        this.mFirstOnlyEnable = firstOnly;
    }

    protected abstract void convert(BaseViewHolder var1, T var2);

    public long getItemId(int position) {
        return position;
    }

    public static interface RequestLoadMoreListener {
        public void onLoadMoreRequested();
    }

    public static class ContentViewHolder
    extends BaseViewHolder {
        public ContentViewHolder(View itemView) {
            super(itemView.getContext(), itemView);
        }
    }

    public static class HeadViewHolder
    extends BaseViewHolder {
        public HeadViewHolder(View itemView) {
            super(itemView.getContext(), itemView);
        }
    }

    public static class FooterViewHolder
    extends BaseViewHolder {
        public FooterViewHolder(View itemView) {
            super(itemView.getContext(), itemView);
        }
    }

    public static interface OnRecyclerViewItemClickListener {
        public void onItemClick(View var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnimationType {
    }
}

