/*
 * Decompiled with CFR 0.152.
 */
package com.cunoraz.gifview.library;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.os.Build;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import com.cunoraz.gifview.library.R;
import java.io.InputStream;

public class GifView
extends View {
    private static final int DEFAULT_MOVIE_VIEW_DURATION = 1000;
    private int mMovieResourceId;
    private Movie movie;
    private long mMovieStart;
    private int mCurrentAnimationTime;
    private float mLeft;
    private float mTop;
    private float mScale;
    private int mMeasuredMovieWidth;
    private int mMeasuredMovieHeight;
    private volatile boolean mPaused;
    private boolean mVisible = true;

    public GifView(Context context) {
        this(context, null);
    }

    public GifView(Context context, AttributeSet attrs) {
        this(context, attrs, R.styleable.CustomTheme_gifViewStyle);
    }

    public GifView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setViewAttributes(context, attrs, defStyle);
    }

    @SuppressLint(value={"NewApi"})
    private void setViewAttributes(Context context, AttributeSet attrs, int defStyle) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.GifView, defStyle, R.style.Widget_GifView);
        this.mMovieResourceId = array.getResourceId(R.styleable.GifView_gif, -1);
        this.mPaused = array.getBoolean(R.styleable.GifView_paused, false);
        array.recycle();
        if (this.mMovieResourceId != -1) {
            this.movie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this.mMovieResourceId));
        }
    }

    public void setGifResource(int movieResourceId) {
        this.mMovieResourceId = movieResourceId;
        this.movie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this.mMovieResourceId));
        this.requestLayout();
    }

    public int getGifResource() {
        return this.mMovieResourceId;
    }

    public void play() {
        if (this.mPaused) {
            this.mPaused = false;
            this.mMovieStart = SystemClock.uptimeMillis() - (long)this.mCurrentAnimationTime;
            this.invalidate();
        }
    }

    public void pause() {
        if (!this.mPaused) {
            this.mPaused = true;
            this.invalidate();
        }
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public boolean isPlaying() {
        return !this.mPaused;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.movie != null) {
            int maximumHeight;
            int maximumWidth;
            int movieWidth = this.movie.width();
            int movieHeight = this.movie.height();
            float scaleH = 1.0f;
            int measureModeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
            if (measureModeWidth != 0 && movieWidth > (maximumWidth = View.MeasureSpec.getSize((int)widthMeasureSpec))) {
                scaleH = (float)movieWidth / (float)maximumWidth;
            }
            float scaleW = 1.0f;
            int measureModeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (measureModeHeight != 0 && movieHeight > (maximumHeight = View.MeasureSpec.getSize((int)heightMeasureSpec))) {
                scaleW = (float)movieHeight / (float)maximumHeight;
            }
            this.mScale = 1.0f / Math.max(scaleH, scaleW);
            this.mMeasuredMovieWidth = (int)((float)movieWidth * this.mScale);
            this.mMeasuredMovieHeight = (int)((float)movieHeight * this.mScale);
            this.setMeasuredDimension(this.mMeasuredMovieWidth, this.mMeasuredMovieHeight);
        } else {
            this.setMeasuredDimension(this.getSuggestedMinimumWidth(), this.getSuggestedMinimumHeight());
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mLeft = (float)(this.getWidth() - this.mMeasuredMovieWidth) / 2.0f;
        this.mTop = (float)(this.getHeight() - this.mMeasuredMovieHeight) / 2.0f;
        this.mVisible = this.getVisibility() == 0;
    }

    protected void onDraw(Canvas canvas) {
        if (this.movie != null) {
            if (!this.mPaused) {
                this.updateAnimationTime();
                this.drawMovieFrame(canvas);
                this.invalidateView();
            } else {
                this.drawMovieFrame(canvas);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void invalidateView() {
        if (this.mVisible) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.postInvalidateOnAnimation();
            } else {
                this.invalidate();
            }
        }
    }

    private void updateAnimationTime() {
        int dur;
        long now = SystemClock.uptimeMillis();
        if (this.mMovieStart == 0L) {
            this.mMovieStart = now;
        }
        if ((dur = this.movie.duration()) == 0) {
            dur = 1000;
        }
        this.mCurrentAnimationTime = (int)((now - this.mMovieStart) % (long)dur);
    }

    private void drawMovieFrame(Canvas canvas) {
        this.movie.setTime(this.mCurrentAnimationTime);
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null);
        } else {
            canvas.save(1);
        }
        canvas.scale(this.mScale, this.mScale);
        this.movie.draw(canvas, this.mLeft / this.mScale, this.mTop / this.mScale);
        canvas.restore();
    }

    @SuppressLint(value={"NewApi"})
    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        this.mVisible = screenState == 1;
        this.invalidateView();
    }

    @SuppressLint(value={"NewApi"})
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mVisible = visibility == 0;
        this.invalidateView();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.invalidateView();
    }
}

