/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import com.intellij.openapi.util.text.StringUtil;
import dalvik.system.PathClassLoader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.ServiceLoaderLite;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ)\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0086\bJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u0011\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J*\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\r0\b2\u0006\u0010\u0013\u001a\u00020\u0014J8\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\u0015\"\u0004\b\u0000\u0010\r2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\r0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0013\u001a\u00020\u0016J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\bJ\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/util/ServiceLoaderLite;", "", "()V", "SERVICE_DIRECTORY_LOCATION", "", "findImplementations", "", "service", "Ljava/lang/Class;", "file", "Ljava/io/File;", "files", "", "Service", "findImplementationsInDirectory", "classId", "findImplementationsInJar", "getClassIdentifier", "loadImplementations", "classLoader", "Ljava/net/URLClassLoader;", "", "Ljava/lang/ClassLoader;", "parseLine", "line", "parseLines", "lines", "Lkotlin/sequences/Sequence;", "ServiceLoadingException", "kotlinc_release"})
@SourceDebugExtension(value={"SMAP\nServiceLoaderLite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceLoaderLite.kt\norg/jetbrains/kotlin/util/ServiceLoaderLite\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 6 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 8 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,151:1\n11065#2:152\n11400#2,3:153\n1446#3,5:156\n1#4:161\n1#4:164\n1#4:166\n1#4:169\n230#5,2:162\n52#6:165\n1144#7:167\n1313#7:168\n1314#7:170\n1145#7:171\n1183#8,3:172\n*S KotlinDebug\n*F\n+ 1 ServiceLoaderLite.kt\norg/jetbrains/kotlin/util/ServiceLoaderLite\n*L\n45#1:152\n45#1:153,3\n91#1:156,5\n113#1:164\n123#1:166\n129#1:169\n113#1:162,2\n123#1:165\n129#1:167\n129#1:168\n129#1:170\n129#1:171\n135#1:172,3\n*E\n"})
public final class ServiceLoaderLite {
    @NotNull
    public static final ServiceLoaderLite INSTANCE = new ServiceLoaderLite();
    @NotNull
    private static final String SERVICE_DIRECTORY_LOCATION = "META-INF/services/";

    private ServiceLoaderLite() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <Service> List<Service> loadImplementations(@NotNull Class<? extends Service> service, @NotNull URLClassLoader classLoader) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        URL[] uRLArray = classLoader.getURLs();
        Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"getURLs(...)");
        Object[] $this$map$iv = uRLArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            File file;
            void url;
            URL uRL = (URL)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            try {
                file = Paths.get(url.toURI()).toFile();
            }
            catch (FileSystemNotFoundException e) {
                throw new IllegalArgumentException("Only local URLs are supported, got " + url.getProtocol());
            }
            catch (UnsupportedOperationException e) {
                throw new IllegalArgumentException("Only local URLs are supported, got " + url.getProtocol());
            }
            collection.add(file);
        }
        List files = (List)destination$iv$iv;
        URL[] uRLArray2 = classLoader.getURLs();
        Intrinsics.checkNotNullExpressionValue((Object)uRLArray2, (String)"getURLs(...)");
        Object[] objectArray2 = uRLArray2;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        String classpath2 = ArraysKt.joinToString$default((Object[])objectArray2, (CharSequence)string, null, null, (int)0, null, (Function1)loadImplementations.classpath.1.INSTANCE, (int)30, null);
        PathClassLoader loader = new PathClassLoader(classpath2, this.getClass().getClassLoader());
        return this.loadImplementations(service, files, (ClassLoader)loader);
    }

    @NotNull
    public final <Service> List<Service> loadImplementations(@NotNull Class<? extends Service> service, @NotNull List<? extends File> files, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(service, (String)"service");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        List implementations = new ArrayList();
        for (String className : this.findImplementations(service, files)) {
            try {
                Object instance = classLoader.loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                Service Service = service.cast(instance);
                Intrinsics.checkNotNull(Service);
                implementations.add(Service);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException("Unable to find class " + className + " in " + files);
            }
        }
        return implementations;
    }

    public final /* synthetic */ <Service> Set<String> findImplementations(List<? extends File> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        boolean $i$f$findImplementations = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"Service");
        return this.findImplementations(Object.class, files);
    }

    public final /* synthetic */ <Service> List<Service> loadImplementations(URLClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        boolean $i$f$loadImplementations = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"Service");
        return this.loadImplementations(Object.class, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> findImplementations(@NotNull Class<?> service, @NotNull List<? extends File> files) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter(service, (String)"service");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable iterable = files;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Iterable list$iv = INSTANCE.findImplementations(service, it);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)destination$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Set<String> findImplementations(Class<?> service, File file) {
        Set<String> set;
        String classIdentifier = this.getClassIdentifier(service);
        if (file.isDirectory()) {
            set = this.findImplementationsInDirectory(classIdentifier, file);
            return set;
        }
        if (file.isFile()) {
            String string = FilesKt.getExtension((File)file);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)string2, (Object)"jar")) {
                set = this.findImplementationsInJar(classIdentifier, file);
                return set;
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<String> findImplementationsInDirectory(String classId, File file) {
        File file2;
        File it = file2 = new File(file, SERVICE_DIRECTORY_LOCATION + classId);
        boolean bl = false;
        File file3 = it.isFile() ? file2 : null;
        if (file3 == null) {
            return SetsKt.emptySet();
        }
        File serviceFile = file3;
        try {
            File $this$useLines_u24default$iv = serviceFile;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object = $this$useLines_u24default$iv;
            int n = 8192;
            Set<String> set = object;
            set = new InputStreamReader((InputStream)new FileInputStream((File)((Object)set)), charset$iv);
            object = set instanceof BufferedReader ? (BufferedReader)((Object)set) : new BufferedReader((Reader)((Object)set), n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)object;
                boolean bl2 = false;
                Sequence it2 = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl3 = false;
                set = INSTANCE.parseLines(file, (Sequence<String>)it2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return set;
        }
        catch (IOError e) {
            throw new ServiceLoadingException(file, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Set<String> findImplementationsInJar(String classId, File file) {
        Closeable closeable = new ZipFile(file);
        Throwable throwable = null;
        try {
            Set<String> set;
            ZipEntry zipEntry;
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            Object object = zipFile.getEntry(SERVICE_DIRECTORY_LOCATION + classId);
            if (object == null) {
                Set set2 = SetsKt.emptySet();
                return set2;
            }
            Intrinsics.checkNotNull((Object)zipEntry);
            ZipEntry entry = object;
            object = zipFile.getInputStream(entry);
            Throwable throwable2 = null;
            try {
                Set<String> set3;
                void $this$useLines$iv;
                InputStream inputStream = (InputStream)object;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)inputStream);
                Closeable closeable2 = inputStream;
                Charset charset = Charsets.UTF_8;
                Closeable closeable3 = new InputStreamReader((InputStream)closeable2, charset);
                int n = 8192;
                closeable2 = closeable3 instanceof BufferedReader ? (BufferedReader)closeable3 : new BufferedReader((Reader)closeable3, n);
                boolean $i$f$useLines = false;
                closeable3 = $this$useLines$iv;
                n = 8192;
                closeable3 = closeable3 instanceof BufferedReader ? (BufferedReader)closeable3 : new BufferedReader((Reader)closeable3, n);
                Throwable throwable3 = null;
                try {
                    BufferedReader it$iv = (BufferedReader)closeable3;
                    boolean bl3 = false;
                    Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl4 = false;
                    set3 = INSTANCE.parseLines(file, (Sequence<String>)it);
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                set = set3;
            }
            catch (Throwable throwable5) {
                try {
                    try {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        CloseableKt.closeFinally((Closeable)object, throwable2);
                        throw throwable6;
                    }
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
            }
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            Set<String> set4 = set;
            return set4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> parseLines(File file, Sequence<String> lines) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Sequence<String> sequence = lines;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv;
            boolean bl2 = false;
            if (INSTANCE.parseLine(file, it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final String parseLine(File file, String line) {
        String string;
        String it = string = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)line, (char)'#', null, (int)2, null))).toString();
        boolean bl = false;
        String string2 = ((CharSequence)it).length() > 0 ? string : null;
        if (string2 == null) {
            return null;
        }
        String actualLine = string2;
        CharSequence $this$forEachIndexed$iv = actualLine;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            boolean isValid;
            void c;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int index = n;
            boolean bl2 = false;
            boolean bl3 = index == 0 ? StringUtil.isJavaIdentifierStart((char)c) : (isValid = StringUtil.isJavaIdentifierPart((char)c) || c == 46);
            if (isValid) continue;
            String errorText = "Invalid Java identifier: " + line;
            throw new ServiceLoadingException(file, (Throwable)new RuntimeException(errorText));
        }
        return actualLine;
    }

    private final String getClassIdentifier(Class<?> service) {
        String string = service.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/util/ServiceLoaderLite$ServiceLoadingException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "file", "Ljava/io/File;", "cause", "", "(Ljava/io/File;Ljava/lang/Throwable;)V", "getFile", "()Ljava/io/File;", "kotlinc_release"})
    public static final class ServiceLoadingException
    extends RuntimeException {
        @NotNull
        private final File file;

        public ServiceLoadingException(@NotNull File file, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super("Error loading services from " + file, cause);
            this.file = file;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }
    }
}

