/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.ContentRoot;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\u001a \u0010\r\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0007\u001a&\u0010\u0011\u001a\u00020\u000e*\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0007\u001a\u0012\u0010\u0013\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\b\u001a\u0018\u0010\u0014\u001a\u00020\u000e*\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0018\u0010\u0015\u001a\u00020\u000e*\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\n\u0010\u0016\u001a\u00020\u000e*\u00020\u0003\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"javaSourceRoots", "", "", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getJavaSourceRoots", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Ljava/util/Set;", "jvmClasspathRoots", "", "Ljava/io/File;", "getJvmClasspathRoots", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Ljava/util/List;", "jvmModularRoots", "getJvmModularRoots", "addJavaSourceRoot", "", "file", "packagePrefix", "addJavaSourceRoots", "files", "addJvmClasspathRoot", "addJvmClasspathRoots", "addJvmSdkRoots", "configureJdkClasspathRoots", "kotlinc_release"})
@SourceDebugExtension(value={"SMAP\nJvmContentRoots.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmContentRoots.kt\norg/jetbrains/kotlin/cli/jvm/config/JvmContentRootsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1855#2,2:115\n1549#2:117\n1620#2,3:118\n800#2,11:121\n1549#2:132\n1620#2,3:133\n800#2,11:136\n1549#2:147\n1620#2,3:148\n1855#2,2:151\n1611#2:153\n1855#2:154\n1856#2:156\n1612#2:157\n1#3:155\n*S KotlinDebug\n*F\n+ 1 JvmContentRoots.kt\norg/jetbrains/kotlin/cli/jvm/config/JvmContentRootsKt\n*L\n56#1:115,2\n63#1:117\n63#1:118,3\n67#1:121,11\n68#1:132\n68#1:133,3\n71#1:136,11\n72#1:147\n72#1:148,3\n81#1:151,2\n85#1:153\n85#1:154\n85#1:156\n85#1:157\n85#1:155\n*E\n"})
public final class JvmContentRootsKt {
    public static final void addJvmClasspathRoot(@NotNull CompilerConfiguration $this$addJvmClasspathRoot, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$addJvmClasspathRoot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        $this$addJvmClasspathRoot.add(CLIConfigurationKeys.CONTENT_ROOTS, (Object)new JvmClasspathRoot(file));
    }

    public static final void addJvmClasspathRoots(@NotNull CompilerConfiguration $this$addJvmClasspathRoots, @NotNull List<? extends File> files) {
        Intrinsics.checkNotNullParameter((Object)$this$addJvmClasspathRoots, (String)"<this>");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File p0 = (File)element$iv;
            boolean bl = false;
            JvmContentRootsKt.addJvmClasspathRoot($this$addJvmClasspathRoots, p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void addJvmSdkRoots(@NotNull CompilerConfiguration $this$addJvmSdkRoots, @NotNull List<? extends File> files) {
        Collection<JvmClasspathRoot> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addJvmSdkRoots, (String)"<this>");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable iterable = files;
        int n = 0;
        CompilerConfigurationKey compilerConfigurationKey = CLIConfigurationKeys.CONTENT_ROOTS;
        CompilerConfiguration compilerConfiguration = $this$addJvmSdkRoots;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JvmClasspathRoot((File)file, true));
        }
        collection = (List)destination$iv$iv;
        compilerConfiguration.addAll(compilerConfigurationKey, n, (Collection)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getJvmClasspathRoots(@NotNull CompilerConfiguration $this$jvmClasspathRoots) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$jvmClasspathRoots, (String)"<this>");
        List list = $this$jvmClasspathRoots.getList(CLIConfigurationKeys.CONTENT_ROOTS);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JvmClasspathRoot)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            JvmContentRoot jvmContentRoot = (JvmContentRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getFile());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getJvmModularRoots(@NotNull CompilerConfiguration $this$jvmModularRoots) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$jvmModularRoots, (String)"<this>");
        List list = $this$jvmModularRoots.getList(CLIConfigurationKeys.CONTENT_ROOTS);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JvmModulePathRoot)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            JvmContentRoot jvmContentRoot = (JvmContentRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getFile());
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    public static final void addJavaSourceRoot(@NotNull CompilerConfiguration $this$addJavaSourceRoot, @NotNull File file, @Nullable String packagePrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$addJavaSourceRoot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        $this$addJavaSourceRoot.add(CLIConfigurationKeys.CONTENT_ROOTS, (Object)new JavaSourceRoot(file, packagePrefix));
    }

    public static /* synthetic */ void addJavaSourceRoot$default(CompilerConfiguration compilerConfiguration, File file, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        JvmContentRootsKt.addJavaSourceRoot(compilerConfiguration, file, string);
    }

    @JvmOverloads
    public static final void addJavaSourceRoots(@NotNull CompilerConfiguration $this$addJavaSourceRoots, @NotNull List<? extends File> files, @Nullable String packagePrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$addJavaSourceRoots, (String)"<this>");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            JvmContentRootsKt.addJavaSourceRoot($this$addJavaSourceRoots, it, packagePrefix);
        }
    }

    public static /* synthetic */ void addJavaSourceRoots$default(CompilerConfiguration compilerConfiguration, List list, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        JvmContentRootsKt.addJavaSourceRoots(compilerConfiguration, list, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> getJavaSourceRoots(@NotNull CompilerConfiguration $this$javaSourceRoots) {
        void var2_2;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$javaSourceRoots, (String)"<this>");
        List list = $this$javaSourceRoots.getList(CLIConfigurationKeys.CONTENT_ROOTS);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        Iterable iterable = list;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            ContentRoot root = (ContentRoot)element$iv;
            boolean bl2 = false;
            ContentRoot contentRoot = root;
            if ((contentRoot instanceof KotlinSourceRoot ? ((KotlinSourceRoot)root).getPath() : (contentRoot instanceof JavaSourceRoot ? ((JavaSourceRoot)root).getFile().getPath() : null)) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var2_2;
    }

    public static final void configureJdkClasspathRoots(@NotNull CompilerConfiguration $this$configureJdkClasspathRoots) {
        Intrinsics.checkNotNullParameter((Object)$this$configureJdkClasspathRoots, (String)"<this>");
        if ($this$configureJdkClasspathRoots.getBoolean(JVMConfigurationKeys.NO_JDK)) {
            return;
        }
        File jdkHome = (File)$this$configureJdkClasspathRoots.get(JVMConfigurationKeys.JDK_HOME);
        if (jdkHome == null) {
            String string = System.getProperty("java.home");
            Intrinsics.checkNotNull((Object)string);
            File javaHome = new File(string);
            $this$configureJdkClasspathRoots.put(JVMConfigurationKeys.JDK_HOME, (Object)javaHome);
            TuplesKt.to((Object)javaHome, PathUtil.getJdkClassesRootsFromCurrentJre());
        } else {
            TuplesKt.to((Object)jdkHome, PathUtil.getJdkClassesRoots(jdkHome));
        }
    }

    @JvmOverloads
    public static final void addJavaSourceRoot(@NotNull CompilerConfiguration $this$addJavaSourceRoot, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$addJavaSourceRoot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JvmContentRootsKt.addJavaSourceRoot$default($this$addJavaSourceRoot, file, null, 2, null);
    }

    @JvmOverloads
    public static final void addJavaSourceRoots(@NotNull CompilerConfiguration $this$addJavaSourceRoots, @NotNull List<? extends File> files) {
        Intrinsics.checkNotNullParameter((Object)$this$addJavaSourceRoots, (String)"<this>");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        JvmContentRootsKt.addJavaSourceRoots$default($this$addJavaSourceRoots, files, null, 2, null);
    }
}

