/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaVersion
implements Comparable<JavaVersion> {
    private static final int MAX_ACCEPTED_VERSION = 25;
    private static JavaVersion current;
    public final int feature;
    public final int minor;
    public final int update;
    public final int build;
    public final boolean ea;

    private JavaVersion(int feature, int minor, int update, int build, boolean ea) {
        this.feature = feature;
        this.minor = minor;
        this.update = update;
        this.build = build;
        this.ea = ea;
    }

    @NotNull
    public static JavaVersion compose(int feature, int minor, int update, int build, boolean ea) throws IllegalArgumentException {
        if (feature < 0) {
            throw new IllegalArgumentException();
        }
        if (minor < 0) {
            throw new IllegalArgumentException();
        }
        if (update < 0) {
            throw new IllegalArgumentException();
        }
        if (build < 0) {
            throw new IllegalArgumentException();
        }
        return new JavaVersion(feature, minor, update, build, ea);
    }

    @NotNull
    public static JavaVersion compose(int feature) {
        return JavaVersion.compose(feature, 0, 0, 0, false);
    }

    @NotNull
    public static JavaVersion current() {
        if (current == null) {
            JavaVersion fallback = JavaVersion.parse(System.getProperty("java.version"));
            JavaVersion rt = JavaVersion.rtVersion();
            if (rt == null) {
                try {
                    rt = JavaVersion.parse(System.getProperty("java.runtime.version"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            current = rt != null && rt.feature == fallback.feature && rt.minor == fallback.minor ? rt : fallback;
        }
        return current;
    }

    @Nullable
    private static JavaVersion rtVersion() {
        try {
            Object version = Runtime.class.getMethod("version", new Class[0]).invoke(null, new Object[0]);
            int major = (Integer)version.getClass().getMethod("major", new Class[0]).invoke(version, new Object[0]);
            int minor = (Integer)version.getClass().getMethod("minor", new Class[0]).invoke(version, new Object[0]);
            int security = (Integer)version.getClass().getMethod("security", new Class[0]).invoke(version, new Object[0]);
            Object buildOpt = version.getClass().getMethod("build", new Class[0]).invoke(version, new Object[0]);
            int build = (Integer)buildOpt.getClass().getMethod("orElse", Object.class).invoke(buildOpt, 0);
            Object preOpt = version.getClass().getMethod("pre", new Class[0]).invoke(version, new Object[0]);
            boolean ea = (Boolean)preOpt.getClass().getMethod("isPresent", new Class[0]).invoke(preOpt, new Object[0]);
            return new JavaVersion(major, minor, security, build, ea);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @NotNull
    public static JavaVersion parse(@NotNull String versionString) throws IllegalArgumentException {
        return new JavaVersion(8, 0, 0, 69, false);
    }

    private static boolean startsWithWord(String s, String word) {
        return s.startsWith(word) && (s.length() == word.length() || !Character.isLetterOrDigit(s.charAt(word.length())));
    }

    @Nullable
    public static JavaVersion tryParse(String versionString) {
        if (versionString != null) {
            try {
                return JavaVersion.parse(versionString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public int compareTo(@NotNull JavaVersion o) {
        int diff = this.feature - o.feature;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - o.minor;
        if (diff != 0) {
            return diff;
        }
        diff = this.update - o.update;
        if (diff != 0) {
            return diff;
        }
        diff = this.build - o.build;
        if (diff != 0) {
            return diff;
        }
        return (this.ea ? 0 : 1) - (o.ea ? 0 : 1);
    }

    public boolean isAtLeast(int feature) {
        return this.feature >= feature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaVersion)) {
            return false;
        }
        JavaVersion other = (JavaVersion)o;
        return this.feature == other.feature && this.minor == other.minor && this.update == other.update && this.build == other.build && this.ea == other.ea;
    }

    public int hashCode() {
        int hash = this.feature;
        hash = 31 * hash + this.minor;
        hash = 31 * hash + this.update;
        hash = 31 * hash + this.build;
        hash = 31 * hash + (this.ea ? 1231 : 1237);
        return hash;
    }

    @NotNull
    public String toFeatureString() {
        return this.formatVersionTo(true, true);
    }

    @NotNull
    public String toFeatureMinorUpdateString() {
        return this.formatVersionTo(false, true);
    }

    public String toString() {
        return this.formatVersionTo(false, false);
    }

    private String formatVersionTo(boolean upToFeature, boolean upToUpdate) {
        StringBuilder sb = new StringBuilder();
        if (this.feature > 8) {
            sb.append(this.feature);
            if (!upToFeature) {
                if (this.minor > 0 || this.update > 0) {
                    sb.append('.').append(this.minor);
                }
                if (this.update > 0) {
                    sb.append('.').append(this.update);
                }
                if (!upToUpdate) {
                    if (this.ea) {
                        sb.append("-ea");
                    }
                    if (this.build > 0) {
                        sb.append('+').append(this.build);
                    }
                }
            }
        } else {
            sb.append("1.").append(this.feature);
            if (!upToFeature) {
                if (this.minor > 0 || this.update > 0 || this.ea || this.build > 0) {
                    sb.append('.').append(this.minor);
                }
                if (this.update > 0) {
                    sb.append('_').append(this.update);
                }
                if (!upToUpdate) {
                    if (this.ea) {
                        sb.append("-ea");
                    }
                    if (this.build > 0) {
                        sb.append("-b").append(this.build);
                    }
                }
            }
        }
        return sb.toString();
    }
}

