/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.core.CoreBundle;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EdtInvocationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDocumentManagerBase
extends PsiDocumentManager
implements DocumentListener,
Disposable {
    static final Logger LOG = Logger.getInstance(PsiDocumentManagerBase.class);
    private static final Key<Document> HARD_REF_TO_DOCUMENT = Key.create((String)"HARD_REFERENCE_TO_DOCUMENT");
    private static final ThreadLocal<Boolean> ourIsFullReparseInProgress = new ThreadLocal();
    private static final Object PERFORM_ALWAYS_KEY = ObjectUtils.sentinel((String)"PERFORM_ALWAYS");
    protected final Project myProject;
    final Set<Document> myUncommittedDocuments = Collections.newSetFromMap(CollectionFactory.createConcurrentWeakMap());
    private final Map<Document, List<Runnable>> myActionsAfterCommit = CollectionFactory.createConcurrentWeakMap();
    private final PsiManager myPsiManager;
    private final DocumentCommitProcessor myDocumentCommitProcessor;
    private final Map<Document, UncommittedInfo> myUncommittedInfos = new ConcurrentHashMap<Document, UncommittedInfo>();
    private final Key<UncommittedInfo> FREE_THREADED_UNCOMMITTED_INFO = Key.create((String)"FREE_THREADED_UNCOMMITTED_INFO");
    private final ThreadLocal<Integer> myIsCommitInProgress = new ThreadLocal();
    private final PsiToDocumentSynchronizer mySynchronizer;
    private final List<PsiDocumentManager.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<Object, Runnable> actionsWhenAllDocumentsAreCommitted = new LinkedHashMap<Object, Runnable>();
    boolean myStopTrackingDocuments;
    private boolean myPerformBackgroundCommit = true;

    protected PsiDocumentManagerBase(@NotNull Project project) {
        this.myProject = project;
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myDocumentCommitProcessor = new DocumentCommitThread();
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, project.getMessageBus());
    }

    @NotNull
    private static PsiFile ensureValidFile(@NotNull PsiFile psiFile, @NotNull String debugInfo) {
        if (!psiFile.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)psiFile, debugInfo);
        }
        return psiFile;
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    public static boolean isFullReparseInProgress() {
        return ourIsFullReparseInProgress.get() == Boolean.TRUE;
    }

    @NotNull
    private static Document getTopLevelDocument(@NotNull Document document) {
        return document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
    }

    public static boolean checkConsistency(@NotNull PsiFile psiFile, @NotNull Document document) {
        int i;
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document.getCharsSequence();
        int documentLength = document.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        String error = "File '" + psiFile.getName() + "' text mismatch after reparse. File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i = 0; i < documentLength; ++i) {
            if (i >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (i >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (editorText.charAt(i) == fileText[i]) continue;
            error = error + "first unequal char i=" + i + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i) + ")\n";
        error = error + "*********************************************\n";
        if (document instanceof DocumentWindow) {
            error = error + "doc: '" + document.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getInjectionHost((PsiElement)psiFile);
            if (context != null) {
                error = error + "context: " + context + "; text: '" + context.getText() + "'\n";
                error = error + "context file: " + context.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        if (document instanceof DocumentWindow && !((DocumentWindow)document).isValid()) {
            return null;
        }
        PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            return PsiDocumentManagerBase.ensureValidFile(psiFile, "Cached PSI");
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = this.getPsiFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        this.fireFileCreated(document, psiFile);
        return psiFile;
    }

    public void associatePsi(@NotNull Document document, @NotNull PsiFile file) {
        if (file.getProject() != this.myProject) {
            throw new IllegalArgumentException("Method associatePsi() called with file from the wrong project. Expected: " + this.myProject + " but got: " + file.getProject());
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(vFile);
        if (cachedDocument != null && cachedDocument != document) {
            throw new IllegalStateException("Can't replace existing document");
        }
    }

    public final PsiFile getCachedPsiFile(@NotNull Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        return virtualFile == null || !virtualFile.isValid() ? null : this.getCachedPsiFile(virtualFile);
    }

    @Nullable
    FileViewProvider getCachedViewProvider(@NotNull Document document) {
        VirtualFile virtualFile = PsiDocumentManagerBase.getVirtualFile(document);
        if (virtualFile == null) {
            return null;
        }
        return this.getFileManager().findCachedViewProvider(virtualFile);
    }

    @Nullable
    PsiFile getCachedPsiFile(@NotNull VirtualFile virtualFile) {
        return this.getFileManager().getCachedPsiFile(virtualFile);
    }

    @Nullable
    private PsiFile getPsiFile(@NotNull VirtualFile virtualFile) {
        return this.getFileManager().findFile(virtualFile);
    }

    @NotNull
    private FileManager getFileManager() {
        return ((PsiManagerEx)this.myPsiManager).getFileManager();
    }

    public Document getDocument(@NotNull PsiFile file) {
        Document document = this.getCachedDocument(file);
        if (document != null) {
            if (!file.getViewProvider().isPhysical()) {
                PsiUtilCore.ensureValid((PsiElement)file);
                this.associatePsi(document, file);
            }
            return document;
        }
        FileViewProvider viewProvider = file.getViewProvider();
        if (!viewProvider.isEventSystemEnabled()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(viewProvider.getVirtualFile());
        if (document != null) {
            if (document.getTextLength() != file.getTextLength()) {
                String message = "Document/PSI mismatch: " + file + " of " + file.getClass() + "; viewProvider=" + viewProvider + "; uncommitted=" + Arrays.toString(this.getUncommittedDocuments());
                throw new RuntimeExceptionWithAttachments(message, new Attachment[]{new Attachment("document.txt", document.getText()), new Attachment("psi.txt", file.getText())});
            }
            if (!viewProvider.isPhysical()) {
                PsiUtilCore.ensureValid((PsiElement)file);
                this.associatePsi(document, file);
                file.putUserData(HARD_REF_TO_DOCUMENT, (Object)document);
            }
        }
        return document;
    }

    public Document getCachedDocument(@NotNull PsiFile file) {
        if (!file.isPhysical()) {
            return null;
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    public void commitAllDocuments() {
        Document[] documents;
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (this.myUncommittedDocuments.isEmpty()) {
            return;
        }
        for (Document document : documents = this.getUncommittedDocuments()) {
            if (this.isCommitted(document)) {
                if (!this.isEventSystemEnabled(document)) continue;
                LOG.error("Committed document in uncommitted set: " + document);
                continue;
            }
            if (this.doCommit(document)) continue;
            LOG.error("Couldn't commit " + document);
        }
        LOG.assertTrue(!this.hasEventSystemEnabledUncommittedDocuments(), this.myUncommittedDocuments);
    }

    public boolean commitAllDocumentsUnderProgress() {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (application.isWriteAccessAllowed()) {
                this.commitAllDocuments();
                if (!application.isUnitTestMode()) {
                    LOG.error("Do not call commitAllDocumentsUnderProgress inside write-action");
                }
                return true;
            }
            if (application.isUnitTestMode()) {
                WriteAction.run(() -> this.commitAllDocuments());
                return true;
            }
        }
        int semaphoreTimeoutInMs = 50;
        Runnable commitAllDocumentsRunnable = () -> {
            final Semaphore semaphore = new Semaphore(1);
            AppUIExecutor.onWriteThread().later().submit(() -> PsiDocumentManager.getInstance((Project)this.myProject).performWhenAllCommitted(new Runnable(){

                @Override
                public void run() {
                    semaphore.up();
                }

                public String toString() {
                    return "commitAllDocumentsUnderProgress()";
                }
            }));
            while (!semaphore.waitFor(50L)) {
                ProgressManager.checkCanceled();
            }
        };
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(commitAllDocumentsRunnable, CoreBundle.message((String)"progress.title.processing.documents", (Object[])new Object[0]), true, this.myProject);
    }

    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action) {
        Document document = PsiDocumentManagerBase.getTopLevelDocument(doc);
        if (this.isCommitted(document)) {
            action.run();
        } else {
            this.addRunOnCommit(document, action);
        }
    }

    public boolean cancelAndRunWhenAllCommitted(@NotNull Object key, @NotNull Runnable action) {
        if (this.myProject.isDisposed()) {
            action.run();
            return true;
        }
        if (!this.hasEventSystemEnabledUncommittedDocuments()) {
            assert (this.isCommitInProgress() || this.actionsWhenAllDocumentsAreCommitted.isEmpty()) : this.actionsWhenAllDocumentsAreCommitted + "; uncommitted docs: " + this.myUncommittedDocuments;
            action.run();
            return true;
        }
        this.assertWeAreOutsideAfterCommitHandler();
        return false;
    }

    public void addRunOnCommit(@NotNull Document document, @NotNull Runnable action) {
    }

    @NotNull
    private Runnable[] getAndClearActionsAfterCommit(@NotNull Document document) {
        List<Runnable> list = this.myActionsAfterCommit.remove(document);
        return list == null ? new Runnable[]{} : list.toArray(new Runnable[0]);
    }

    public void commitDocument(@NotNull Document doc) {
        Document document = PsiDocumentManagerBase.getTopLevelDocument(doc);
        if (this.isEventSystemEnabled(document)) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        }
        if (!this.isCommitted(document)) {
            this.doCommit(document);
        }
    }

    boolean isEventSystemEnabled(@NotNull Document document) {
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        return viewProvider != null && viewProvider.isEventSystemEnabled();
    }

    boolean finishCommit(final @NotNull Document document, final @NotNull List<? extends BooleanRunnable> finishProcessors, final @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, @NotNull Object reason) {
        assert (!this.myProject.isDisposed()) : "Already disposed";
        final boolean[] ok = new boolean[]{true};
        if (synchronously) {
            ok[0] = this.finishCommitInWriteAction(document, finishProcessors, reparseInjectedProcessors, true);
        } else {
            ApplicationManager.getApplication().runWriteAction((Runnable)new DocumentRunnable(document, this.myProject){

                public void run() {
                    ok[0] = PsiDocumentManagerBase.this.finishCommitInWriteAction(document, finishProcessors, reparseInjectedProcessors, false);
                }
            });
        }
        if (ok[0]) {
            this.runAfterCommitActions(document);
            if (DebugUtil.DO_EXPENSIVE_CHECKS) {
                this.checkAllElementsValid(document, reason);
            }
        }
        return ok[0];
    }

    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        assert (!(document instanceof DocumentWindow));
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().fastenBelts(virtualFile);
        }
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        AtomicBoolean success = new AtomicBoolean(true);
        this.executeInsideCommit(() -> {
            try {
                success.set((Boolean)ProgressManager.getInstance().computeInNonCancelableSection(() -> {
                    if (viewProvider == null) {
                        this.handleCommitWithoutPsi(document);
                        return true;
                    }
                    return this.commitToExistingPsi(document, finishProcessors, reparseInjectedProcessors, synchronously, virtualFile);
                }));
            }
            catch (Throwable e) {
                try {
                    this.forceReload(virtualFile, viewProvider);
                }
                finally {
                    LOG.error("Exception while committing " + viewProvider + ", eventSystemEnabled=" + this.isEventSystemEnabled(document), e);
                }
            }
            finally {
                if (success.get()) {
                    this.myUncommittedDocuments.remove(document);
                }
            }
        });
        return success.get();
    }

    private boolean commitToExistingPsi(@NotNull Document document, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, @Nullable VirtualFile virtualFile) {
        FileViewProvider viewProvider;
        for (BooleanRunnable booleanRunnable : finishProcessors) {
            boolean bl = booleanRunnable.run();
            assert (!synchronously || bl) : booleanRunnable + " in " + finishProcessors;
            if (bl) continue;
            return false;
        }
        this.clearUncommittedInfo(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().updatePointerTargetsAfterReparse(virtualFile);
        }
        if ((viewProvider = this.getCachedViewProvider(document)) != null) {
            viewProvider.contentsSynchronized();
        }
        for (BooleanRunnable booleanRunnable : reparseInjectedProcessors) {
            if (booleanRunnable.run()) continue;
            return false;
        }
        return true;
    }

    void forceReload(VirtualFile virtualFile, @Nullable FileViewProvider viewProvider) {
        if (viewProvider != null) {
            DebugUtil.performPsiModification((String)"psi.forceReload", () -> ((AbstractFileViewProvider)viewProvider).markInvalidated());
        }
        if (virtualFile != null) {
            ((FileManagerImpl)this.getFileManager()).forceReload(virtualFile);
        }
    }

    private void checkAllElementsValid(@NotNull Document document, final @NotNull Object reason) {
        final PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (!element.isValid()) {
                        throw new AssertionError((Object)("Commit to '" + psiFile.getVirtualFile() + "' has led to invalid element: " + element + "; Reason: '" + reason + "'"));
                    }
                }
            });
        }
    }

    private boolean doCommit(@NotNull Document document) {
        assert (!this.isCommitInProgress()) : "Do not call commitDocument() from inside PSI change listener";
        if (this.getSynchronizer().isDocumentAffectedByTransactions(document)) {
            return false;
        }
        PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            this.myUncommittedDocuments.remove(document);
            this.runAfterCommitActions(document);
            return true;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.doCommit(document, psiFile));
        } else {
            this.doCommit(document, psiFile);
        }
        return true;
    }

    private void doCommit(@NotNull Document document, @NotNull PsiFile psiFile) {
        assert (!this.isCommitInProgress()) : "Do not call commitDocument() from inside PSI change listener";
        this.executeInsideCommit(() -> this.myDocumentCommitProcessor.commitSynchronously(document, this.myProject, psiFile));
        assert (!this.isInUncommittedSet(document)) : "Document :" + document;
        this.runAfterCommitActions(document);
    }

    public boolean isCommitInProgress() {
        return this.myIsCommitInProgress.get() != null || PsiDocumentManagerBase.isFullReparseInProgress();
    }

    private void executeInsideCommit(@NotNull Runnable runnable) {
        Integer counter = this.myIsCommitInProgress.get();
        this.myIsCommitInProgress.set(counter == null ? 1 : counter + 1);
        try {
            runnable.run();
        }
        finally {
            this.myIsCommitInProgress.set(counter);
        }
    }

    public <T> T commitAndRunReadAction(@NotNull Computable<T> computation) {
        Ref ref = Ref.create(null);
        this.commitAndRunReadAction(() -> ref.set(computation.compute()));
        return (T)ref.get();
    }

    public void reparseFiles(@NotNull Collection<? extends VirtualFile> files, boolean includeOpenFiles) {
        FileContentUtilCore.reparseFiles(files);
    }

    public void commitAndRunReadAction(@NotNull Runnable runnable) {
        boolean executed;
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            this.commitAllDocuments();
            runnable.run();
            return;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Don't call commitAndRunReadAction inside ReadAction, it will cause a deadlock. " + Thread.currentThread());
        }
        while (!(executed = ((Boolean)ReadAction.compute(() -> {
            if (!this.hasEventSystemEnabledUncommittedDocuments()) {
                runnable.run();
                return true;
            }
            return false;
        })).booleanValue())) {
            ModalityState modality = ModalityState.defaultModalityState();
            Semaphore semaphore = new Semaphore(1);
            AppUIExecutor.onWriteThread((ModalityState)ModalityState.any()).submit(() -> {
                if (this.myProject.isDisposed()) {
                    semaphore.up();
                    return;
                }
                this.performWhenAllCommitted(modality, () -> semaphore.up());
            });
            while (!semaphore.waitFor(10L)) {
                ProgressManager.checkCanceled();
            }
        }
    }

    public boolean performWhenAllCommitted(@NotNull Runnable action) {
        return this.performWhenAllCommitted(ModalityState.defaultModalityState(), action);
    }

    private boolean performWhenAllCommitted(@NotNull ModalityState modality, @NotNull Runnable action) {
        this.assertWeAreOutsideAfterCommitHandler();
        assert (!this.myProject.isDisposed()) : "Already disposed: " + this.myProject;
        if (!this.hasEventSystemEnabledUncommittedDocuments()) {
            action.run();
            return true;
        }
        CompositeRunnable actions = (CompositeRunnable)this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY);
        if (actions == null) {
            actions = new CompositeRunnable();
            this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, actions);
        }
        if (modality != ModalityState.NON_MODAL && TransactionGuard.getInstance().isWriteSafeModality(modality)) {
            for (Document document : this.myUncommittedDocuments) {
                this.retainProviderAndCommitAsync(document, "re-added because performWhenAllCommitted(" + modality + ") was called", modality);
            }
        }
        return false;
    }

    public void performLaterWhenAllCommitted(@NotNull Runnable runnable) {
        this.performLaterWhenAllCommitted(ModalityState.defaultModalityState(), runnable);
    }

    public void performLaterWhenAllCommitted(final @NotNull ModalityState modalityState, final @NotNull Runnable runnable) {
        Runnable whenAllCommitted = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (PsiDocumentManagerBase.this.hasEventSystemEnabledUncommittedDocuments()) {
                        PsiDocumentManagerBase.this.performLaterWhenAllCommitted(runnable);
                    } else {
                        runnable.run();
                    }
                }, modalityState, PsiDocumentManagerBase.this.myProject.getDisposed());
            }

            public String toString() {
                return "performLaterWhenAllCommitted(" + runnable + ")";
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread() && this.isInsideCommitHandler()) {
            whenAllCommitted.run();
        } else {
            EdtInvocationManager.invokeLaterIfNeeded(() -> {
                if (!this.myProject.isDisposed()) {
                    this.performWhenAllCommitted(whenAllCommitted);
                }
            });
        }
    }

    private void runAfterCommitActions(@NotNull Document document) {
        Runnable[] list;
        Application app = ApplicationManager.getApplication();
        if (!app.isDispatchThread() && this.isEventSystemEnabled(document)) {
            app.invokeLater(() -> {
                if (!this.myProject.isDisposed() && this.isCommitted(document)) {
                    this.runAfterCommitActions(document);
                }
            });
            return;
        }
        for (Runnable runnable : list = this.getAndClearActionsAfterCommit(document)) {
            runnable.run();
        }
        if (app.isDispatchThread()) {
            this.runActionsWhenAllCommitted();
        } else {
            app.invokeLater(this::runActionsWhenAllCommitted, this.myProject.getDisposed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActionsWhenAllCommitted() {
        if (!this.mayRunActionsWhenAllCommitted()) {
            return;
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>(this.actionsWhenAllDocumentsAreCommitted.values());
        this.beforeCommitHandler();
        ArrayList<Pair> exceptions = new ArrayList<Pair>();
        try {
            for (Runnable action : actions) {
                try {
                    action.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    exceptions.add(Pair.create((Object)action, (Object)e));
                }
            }
        }
        finally {
            this.actionsWhenAllDocumentsAreCommitted.clear();
        }
        for (Pair pair : exceptions) {
            Runnable action = (Runnable)pair.getFirst();
            Throwable e = (Throwable)pair.getSecond();
            LOG.error("During running " + action, e);
        }
    }

    private boolean mayRunActionsWhenAllCommitted() {
        return !this.isCommitInProgress() && !this.actionsWhenAllDocumentsAreCommitted.isEmpty() && !this.hasEventSystemEnabledUncommittedDocuments();
    }

    public boolean hasEventSystemEnabledUncommittedDocuments() {
        return ContainerUtil.exists(this.myUncommittedDocuments, this::isEventSystemEnabled);
    }

    private void beforeCommitHandler() {
        this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, EmptyRunnable.getInstance());
    }

    private void assertWeAreOutsideAfterCommitHandler() {
        if (this.isInsideCommitHandler()) {
            throw new IncorrectOperationException("You must not call performWhenAllCommitted()/cancelAndRunWhenCommitted() from within after-commit handler");
        }
    }

    private boolean isInsideCommitHandler() {
        return this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY) == EmptyRunnable.getInstance();
    }

    public void addListener(@NotNull PsiDocumentManager.Listener listener) {
        this.myListeners.add(listener);
    }

    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        return false;
    }

    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
    }

    void fireDocumentCreated(@NotNull Document document, PsiFile file) {
        ((PsiDocumentListener)this.myProject.getMessageBus().syncPublisher(PsiDocumentListener.TOPIC)).documentCreated(document, file, this.myProject);
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.documentCreated(document, file);
        }
    }

    private void fireFileCreated(@NotNull Document document, @NotNull PsiFile file) {
        ((PsiDocumentListener)this.myProject.getMessageBus().syncPublisher(PsiDocumentListener.TOPIC)).fileCreated(file, document);
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.fileCreated(file, document);
        }
    }

    @NotNull
    public CharSequence getLastCommittedText(@NotNull Document document) {
        return this.getLastCommittedDocument(document).getImmutableCharSequence();
    }

    public long getLastCommittedStamp(@NotNull Document document) {
        return this.getLastCommittedDocument(PsiDocumentManagerBase.getTopLevelDocument(document)).getModificationStamp();
    }

    @Nullable
    public Document getLastCommittedDocument(@NotNull PsiFile file) {
        Document document = this.getDocument(file);
        return document == null ? null : this.getLastCommittedDocument(document);
    }

    @NotNull
    public DocumentEx getLastCommittedDocument(@NotNull Document document) {
        if (document instanceof FrozenDocument) {
            return (DocumentEx)document;
        }
        if (document instanceof DocumentWindow) {
            DocumentWindow answer;
            DocumentWindow window = (DocumentWindow)document;
            Document delegate = window.getDelegate();
            if (delegate instanceof FrozenDocument) {
                return (DocumentEx)window;
            }
            if (!window.isValid()) {
                throw new AssertionError((Object)("host committed: " + this.isCommitted(delegate) + ", window=" + window));
            }
            UncommittedInfo info = this.getUncommittedInfo(delegate);
            DocumentWindow documentWindow = answer = info == null ? null : (DocumentWindow)info.myFrozenWindows.get(document);
            if (answer == null) {
                answer = this.freezeWindow(window);
            }
            if (info != null) {
                answer = (DocumentWindow)ConcurrencyUtil.cacheOrGet(info.myFrozenWindows, (Object)window, (Object)answer);
            }
            return (DocumentEx)answer;
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.getUncommittedInfo(document);
        return info != null ? info.myFrozen : ((DocumentImpl)((Object)document)).freeze();
    }

    @Nullable
    private UncommittedInfo getUncommittedInfo(@NotNull Document document) {
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        return info != null ? info : (UncommittedInfo)document.getUserData(this.FREE_THREADED_UNCOMMITTED_INFO);
    }

    private void associateUncommittedInfo(Document document, UncommittedInfo info) {
        if (this.isEventSystemEnabled(document)) {
            this.myUncommittedInfos.put(document, info);
        } else {
            document.putUserData(this.FREE_THREADED_UNCOMMITTED_INFO, info);
        }
    }

    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<DocumentEvent> getEventsSinceCommit(@NotNull Document document) {
        assert (document instanceof DocumentImpl) : document;
        UncommittedInfo info = this.getUncommittedInfo(document);
        if (info != null) {
            return new ArrayList<DocumentEvent>(info.myEvents);
        }
        return Collections.emptyList();
    }

    @NotNull
    public Document[] getUncommittedDocuments() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object[] documents = this.myUncommittedDocuments.toArray(Document.EMPTY_ARRAY);
        return (Document[])ArrayUtil.stripTrailingNulls((Object[])documents);
    }

    boolean isInUncommittedSet(@NotNull Document document) {
        return this.myUncommittedDocuments.contains(PsiDocumentManagerBase.getTopLevelDocument(document));
    }

    public boolean isUncommited(@NotNull Document document) {
        return !this.isCommitted(document);
    }

    public boolean isCommitted(@NotNull Document document) {
        document = PsiDocumentManagerBase.getTopLevelDocument(document);
        if (this.getSynchronizer().isInSynchronization(document)) {
            return true;
        }
        return (!(document instanceof DocumentEx) || !((DocumentEx)document).isInEventsHandling()) && !this.isInUncommittedSet(document);
    }

    public boolean hasUncommitedDocuments() {
        return !this.isCommitInProgress() && !this.myUncommittedDocuments.isEmpty();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        FileViewProvider viewProvider;
        boolean inMyProject;
        boolean isRelevant;
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean bl = isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        if (document instanceof DocumentImpl && this.getUncommittedInfo(document) == null) {
            this.associateUncommittedInfo(document, new UncommittedInfo((DocumentImpl)((Object)document)));
        }
        boolean bl2 = inMyProject = (viewProvider = this.getCachedViewProvider(document)) != null && viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            return;
        }
        List files = viewProvider.getAllFiles();
        PsiFile psiCause = null;
        for (PsiFile file : files) {
            if (file == null) {
                throw new AssertionError((Object)("View provider " + viewProvider + " (" + viewProvider.getClass() + ") returned null in its files array: " + files + " for file " + viewProvider.getVirtualFile()));
            }
            if (!PsiToDocumentSynchronizer.isInsideAtomicChange((PsiFile)file)) continue;
            psiCause = file;
        }
        if (psiCause == null) {
            this.beforeDocumentChangeOnUnlockedDocument(viewProvider);
        }
    }

    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        boolean forceCommit;
        boolean inMyProject;
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider == null) {
            this.handleCommitWithoutPsi(document);
            return;
        }
        boolean bl = inMyProject = viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            this.clearUncommittedInfo(document);
            return;
        }
        List files = viewProvider.getAllFiles();
        if (files.isEmpty()) {
            this.handleCommitWithoutPsi(document);
            return;
        }
        boolean commitNecessary = !ContainerUtil.exists((Iterable)files, file -> PsiToDocumentSynchronizer.isInsideAtomicChange((PsiFile)file) || !(file instanceof PsiFileImpl));
        Application application = ApplicationManager.getApplication();
        boolean bl2 = forceCommit = application.hasWriteAction(ExternalChangeAction.class) && (SystemProperties.getBooleanProperty((String)"idea.force.commit.on.external.change", (boolean)false) || application.isHeadlessEnvironment() && !application.isUnitTestMode());
        if (event.isWholeTextReplaced() && document.getTextLength() > 100000) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
        }
        if (commitNecessary) {
            assert (!(document instanceof DocumentWindow));
            this.myUncommittedDocuments.add(document);
            if (forceCommit) {
                this.commitDocument(document);
            } else if (!document.isInBulkUpdate() && this.myPerformBackgroundCommit) {
                this.retainProviderAndCommitAsync(document, event, ModalityState.defaultModalityState());
            }
        } else {
            this.clearUncommittedInfo(document);
        }
    }

    public void bulkUpdateStarting(@NotNull Document document) {
        document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
    }

    public void bulkUpdateFinished(@NotNull Document document) {
        this.retainProviderAndCommitAsync(document, "Bulk update finished", ModalityState.defaultModalityState());
    }

    private void retainProviderAndCommitAsync(@NotNull Document document, @NotNull Object reason, @NotNull ModalityState modality) {
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider != null && viewProvider.isEventSystemEnabled()) {
            this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, this, document, reason, modality, viewProvider);
        }
    }

    void handleCommitWithoutPsi(@NotNull Document document) {
        UncommittedInfo prevInfo = this.clearUncommittedInfo(document);
        if (prevInfo == null) {
            return;
        }
        this.myUncommittedDocuments.remove(document);
        if (!this.myProject.isInitialized() || this.myProject.isDisposed() || this.myProject.isDefault()) {
            return;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            FileManager fileManager = this.getFileManager();
            FileViewProvider viewProvider = fileManager.findCachedViewProvider(virtualFile);
            if (viewProvider != null) {
                ApplicationManager.getApplication().runWriteAction((Runnable)((ExternalChangeAction)() -> ((AbstractFileViewProvider)viewProvider).onContentReload()));
            } else if (FileIndexFacade.getInstance((Project)this.myProject).isInContent(virtualFile)) {
                ApplicationManager.getApplication().runWriteAction((Runnable)((ExternalChangeAction)() -> ((FileManagerImpl)fileManager).firePropertyChangedForUnloadedPsi()));
            }
        }
        this.runAfterCommitActions(document);
    }

    @Nullable
    private UncommittedInfo clearUncommittedInfo(@NotNull Document document) {
        UncommittedInfo info = this.getUncommittedInfo(document);
        if (info != null) {
            this.myUncommittedInfos.remove(document);
            document.putUserData(this.FREE_THREADED_UNCOMMITTED_INFO, null);
            this.getSmartPointerManager().updatePointers(document, info.myFrozen, info.myEvents);
        }
        return info;
    }

    private SmartPointerManagerImpl getSmartPointerManager() {
        return (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)this.myProject);
    }

    private boolean isRelevant(@NotNull VirtualFile virtualFile) {
        return !this.myProject.isDisposed() && !virtualFile.getFileType().isBinary();
    }

    public void clearUncommittedDocuments() {
        this.myUncommittedInfos.clear();
        this.myUncommittedDocuments.clear();
        this.mySynchronizer.cleanupForNextTest();
    }

    public void disableBackgroundCommit(@NotNull Disposable parentDisposable) {
        assert (this.myPerformBackgroundCommit);
        this.myPerformBackgroundCommit = false;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myPerformBackgroundCommit = true;
        });
    }

    public void dispose() {
    }

    @NotNull
    public PsiToDocumentSynchronizer getSynchronizer() {
        return this.mySynchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparseFileFromText(@NotNull PsiFileImpl file) {
        if (this.isCommitInProgress()) {
            throw new IllegalStateException("Re-entrant commit is not allowed");
        }
        FileElement node = file.calcTreeElement();
        CharSequence text = node.getChars();
        ourIsFullReparseInProgress.set(Boolean.TRUE);
        try {
            ProgressIndicator indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator());
            DiffLog log = BlockSupportImpl.makeFullParse((PsiFileImpl)file, (FileASTNode)node, (CharSequence)text, (ProgressIndicator)indicator, (CharSequence)text).log;
            log.doActualPsiChange((PsiFile)file);
            file.getViewProvider().contentsSynchronized();
        }
        finally {
            ourIsFullReparseInProgress.remove();
        }
    }

    @NotNull
    List<BooleanRunnable> reparseChangedInjectedFragments(@NotNull Document hostDocument, @NotNull PsiFile hostPsiFile, @NotNull TextRange range, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot) {
        return Collections.emptyList();
    }

    public boolean isDefaultProject() {
        return this.myProject.isDefault();
    }

    public String someDocumentDebugInfo(@NotNull Document document) {
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        return "cachedProvider: " + viewProvider + "; isEventSystemEnabled: " + this.isEventSystemEnabled(document) + "; isCommitted:" + this.isCommitted(document) + "; myIsCommitInProgress:" + this.isCommitInProgress() + "; isInUncommittedSet:" + this.isInUncommittedSet(document);
    }

    private static final class UncommittedInfo {
        private final FrozenDocument myFrozen;
        private final List<DocumentEvent> myEvents = new ArrayList<DocumentEvent>();
        private final ConcurrentMap<DocumentWindow, DocumentWindow> myFrozenWindows = new ConcurrentHashMap<DocumentWindow, DocumentWindow>();

        private UncommittedInfo(@NotNull DocumentImpl original) {
            this.myFrozen = original.freeze();
        }
    }

    private static class CompositeRunnable
    extends ArrayList<Runnable>
    implements Runnable {
        private CompositeRunnable() {
        }

        @Override
        public void run() {
            for (Runnable runnable : this) {
                runnable.run();
            }
        }
    }

    public class PriorityEventCollector
    implements PrioritizedDocumentListener {
        public int getPriority() {
            return -1;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            UncommittedInfo info = PsiDocumentManagerBase.this.getUncommittedInfo(event.getDocument());
            if (info != null) {
                info.myEvents.add(event);
            }
        }
    }
}

