/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

class LockFreeCOWSortedArray<T>
extends AtomicReference<T[]> {
    @NotNull
    private final Comparator<? super T> comparator;
    @NotNull
    private final ArrayFactory<? extends T> arrayFactory;

    LockFreeCOWSortedArray(@NotNull Comparator<? super T> comparator, @NotNull ArrayFactory<? extends T> arrayFactory) {
        this.comparator = comparator;
        this.arrayFactory = arrayFactory;
        this.set(arrayFactory.create(0));
    }

    void add(@NotNull T element) {
        int i;
        Object[] newArray;
        Object[] oldArray;
        while (!this.compareAndSet(oldArray = (Object[])this.get(), newArray = ArrayUtil.insert((Object[])oldArray, (int)(i = this.insertionIndex(oldArray, element)), element))) {
        }
    }

    boolean remove(@NotNull T listener) {
        Object[] newArray;
        Object[] oldArray;
        do {
            if ((oldArray = (Object[])this.get()) != (newArray = ArrayUtil.remove((Object[])oldArray, listener, this.arrayFactory))) continue;
            return false;
        } while (!this.compareAndSet(oldArray, newArray));
        return true;
    }

    private int insertionIndex(@NotNull T[] elements, @NotNull T e) {
        for (int i = 0; i < elements.length; ++i) {
            T element = elements[i];
            if (this.comparator.compare(e, element) >= 0) continue;
            return i;
        }
        return elements.length;
    }

    @NotNull
    T[] getArray() {
        return (Object[])this.get();
    }
}

