/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.DocumentWriteAccessGuard;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.LockFreeCOWSortedArray;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    static final Key<Reference<RangeMarkerTree<RangeMarkerEx>>> RANGE_MARKERS_KEY = Key.create((String)"RANGE_MARKERS_KEY");
    static final Key<Reference<RangeMarkerTree<RangeMarkerEx>>> PERSISTENT_RANGE_MARKERS_KEY = Key.create((String)"PERSISTENT_RANGE_MARKERS_KEY");
    private static final Logger LOG = Logger.getInstance(DocumentImpl.class);
    private static final ReferenceQueue<RangeMarkerTree<RangeMarkerEx>> rmTreeQueue = new ReferenceQueue();
    private final LockFreeCOWSortedArray<DocumentListener> myDocumentListeners = new LockFreeCOWSortedArray(PrioritizedDocumentListener.COMPARATOR, DocumentListener.ARRAY_FACTORY);
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers = new RangeMarkerTree((Document)((Object)this));
    private final RangeMarkerTree<RangeMarkerEx> myPersistentRangeMarkers = new RangeMarkerTree((Document)((Object)this));
    private final List<RangeMarker> myGuardedBlocks = new ArrayList<RangeMarker>();
    private final Object myLineSetLock = ObjectUtils.sentinel((String)"line set lock");
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport((Object)this);
    private final boolean myAssertThreading;
    private final AtomicInteger sequence = new AtomicInteger();
    private volatile LineSet myLineSet;
    private volatile ImmutableCharSequence myText;
    private volatile SoftReference<String> myTextString;
    private final CharSequence myMutableCharSequence = new CharSequence(){

        @Override
        public int length() {
            return DocumentImpl.this.myText.length();
        }

        @Override
        public char charAt(int index) {
            return DocumentImpl.this.myText.charAt(index);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            return DocumentImpl.this.myText.subSequence(start, end);
        }

        @Override
        @NotNull
        public String toString() {
            return DocumentImpl.this.doGetText();
        }
    };
    private volatile FrozenDocument myFrozen;
    private boolean myIsReadOnly;
    private volatile long myModificationStamp;
    private int myCheckGuardedBlocks;
    private boolean myGuardsSuppressed;
    private boolean myEventsHandling;
    private volatile boolean myDoingBulkUpdate;
    private volatile Throwable myBulkUpdateEnteringTrace;
    private boolean myUpdatingBulkModeStatus;
    private volatile boolean myAcceptSlashR;
    private boolean myChangeInProgress;
    private volatile int myBufferSize;

    public DocumentImpl(@NotNull String text) {
        this(text, false);
    }

    public DocumentImpl(@NotNull CharSequence chars) {
        this(chars, false);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean forUseInNonAWTThread) {
        this(chars, false, forUseInNonAWTThread);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean acceptSlashR, boolean forUseInNonAWTThread) {
        this.setAcceptSlashR(acceptSlashR);
        this.assertValidSeparators(chars);
        this.myText = CharArrayUtil.createImmutableCharSequence((CharSequence)chars);
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertThreading = !forUseInNonAWTThread;
    }

    public static boolean areRangeMarkersRetainedFor(@NotNull VirtualFile f) {
        DocumentImpl.processQueue();
        return SoftReference.dereference((Reference)((Reference)f.getUserData(RANGE_MARKERS_KEY))) != null || SoftReference.dereference((Reference)((Reference)f.getUserData(PERSISTENT_RANGE_MARKERS_KEY))) != null;
    }

    public static void processQueue() {
        RMTreeReference ref;
        while ((ref = (RMTreeReference)rmTreeQueue.poll()) != null) {
            ref.virtualFile.replace(RANGE_MARKERS_KEY, (Object)ref, null);
            ref.virtualFile.replace(PERSISTENT_RANGE_MARKERS_KEY, (Object)ref, null);
        }
    }

    @NotNull
    static RangeMarker createRangeMarkerForVirtualFile(@NotNull VirtualFile file, int offset, int startLine, int startCol, int endLine, int endCol, boolean persistent) {
        throw new UnsupportedOperationException();
    }

    private static boolean offsetInRange(int offset, int start, int end) {
        return start <= offset && offset < end;
    }

    private static boolean rangesIntersect(int start0, int end0, boolean start0Inclusive, boolean end0Inclusive, int start1, int end1, boolean start1Inclusive, boolean end1Inclusive) {
        if (start0 > start1 || start0 == start1 && !start0Inclusive) {
            if (end1 == start0) {
                return start0Inclusive && end1Inclusive;
            }
            return end1 > start0;
        }
        if (end0 == start1) {
            return start1Inclusive && end0Inclusive;
        }
        return end0 > start1;
    }

    public void documentCreatedFrom(@NotNull VirtualFile f, int tabSize) {
        DocumentImpl.processQueue();
        this.getSaveRMTree(f, RANGE_MARKERS_KEY, this.myRangeMarkers, tabSize);
        this.getSaveRMTree(f, PERSISTENT_RANGE_MARKERS_KEY, this.myPersistentRangeMarkers, tabSize);
    }

    private void getSaveRMTree(@NotNull VirtualFile f, @NotNull Key<Reference<RangeMarkerTree<RangeMarkerEx>>> key, @NotNull RangeMarkerTree<RangeMarkerEx> tree, int tabSize) {
        Reference oldRef;
        RMTreeReference freshRef = new RMTreeReference(tree, f);
        while (!f.replace(key, (Object)(oldRef = (Reference)f.getUserData(key)), (Object)freshRef)) {
        }
        RangeMarkerTree oldTree = (RangeMarkerTree)SoftReference.dereference((Reference)oldRef);
        if (oldTree == null) {
            // empty if block
        }
    }

    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    public boolean acceptsSlashR() {
        return this.myAcceptSlashR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                lineSet = this.myLineSet;
                if (lineSet == null) {
                    this.myLineSet = lineSet = LineSet.createLineSet((CharSequence)this.myText);
                }
            }
        }
        return lineSet;
    }

    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
    }

    public boolean stripTrailingSpaces(Project project) {
        return this.stripTrailingSpaces(project, false);
    }

    public boolean stripTrailingSpaces(Project project, boolean inChangedLinesOnly) {
        return this.stripTrailingSpaces(project, inChangedLinesOnly, null);
    }

    public boolean isLineModified(int line) {
        LineSet lineSet = this.myLineSet;
        return lineSet != null && lineSet.isModified(line);
    }

    boolean stripTrailingSpaces(@Nullable Project project, boolean inChangedLinesOnly, int[] caretOffsets) {
        throw new UnsupportedOperationException();
    }

    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    public boolean isWritable() {
        if (this.myIsReadOnly) {
            return false;
        }
        for (DocumentWriteAccessGuard guard : (DocumentWriteAccessGuard[])DocumentWriteAccessGuard.EP_NAME.getExtensions()) {
            if (guard.isWritable((Document)((Object)this)).isSuccess()) continue;
            return false;
        }
        return true;
    }

    private RangeMarkerTree<RangeMarkerEx> treeFor(@NotNull RangeMarkerEx rangeMarker) {
        return rangeMarker instanceof PersistentRangeMarker ? this.myPersistentRangeMarkers : this.myRangeMarkers;
    }

    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        return this.treeFor(rangeMarker).removeInterval((Object)rangeMarker);
    }

    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        throw new UnsupportedOperationException();
    }

    int getRangeMarkersSize() {
        return this.myRangeMarkers.size() + this.myPersistentRangeMarkers.size();
    }

    int getRangeMarkersNodeSize() {
        return this.myRangeMarkers.nodeSize() + this.myPersistentRangeMarkers.nodeSize();
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        LOG.assertTrue(startOffset <= endOffset, (Object)"Should be startOffset <= endOffset");
        RangeMarker block = this.createRangeMarker(startOffset, endOffset, true);
        this.myGuardedBlocks.add(block);
        return block;
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        this.myGuardedBlocks.remove(block);
    }

    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        return this.myGuardedBlocks;
    }

    public RangeMarker getOffsetGuard(int offset) {
        for (int i = 0; i < this.myGuardedBlocks.size(); ++i) {
            RangeMarker block = this.myGuardedBlocks.get(i);
            if (!DocumentImpl.offsetInRange(offset, block.getStartOffset(), block.getEndOffset())) continue;
            return block;
        }
        return null;
    }

    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, end, true, true, block.getStartOffset(), block.getEndOffset(), block.isGreedyToLeft(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    public void startGuardedBlockChecking() {
        ++this.myCheckGuardedBlocks;
    }

    public void stopGuardedBlockChecking() {
        LOG.assertTrue(this.myCheckGuardedBlocks > 0, (Object)"Unpaired start/stopGuardedBlockChecking");
        --this.myCheckGuardedBlocks;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (0 > startOffset || startOffset > endOffset || endOffset > this.getTextLength()) {
            LOG.error("Incorrect offsets: startOffset=" + startOffset + ", endOffset=" + endOffset + ", text length=" + this.getTextLength());
        }
        throw new UnsupportedOperationException();
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
        this.myFrozen = null;
    }

    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        this.replaceString(0, this.getTextLength(), 0, chars, newModificationStamp, true);
        this.clearLineModificationFlags();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset);
        }
        if (offset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + "; documentLength: " + this.getTextLength());
        }
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (s.length() == 0) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(offset, offset);
        if (marker != null) {
            this.throwGuardedFragment(marker, offset, "", s);
        }
        ImmutableCharSequence newText = this.myText.insert(offset, s);
        ImmutableCharSequence newString = newText.subtext(offset, offset + s.length());
        this.updateText(newText, offset, "", (CharSequence)newString, false, LocalTimeCounter.currentTime(), offset, 0, offset);
        this.trimToSize();
    }

    private void trimToSize() {
        if (this.myBufferSize != 0 && this.getTextLength() > this.myBufferSize) {
            this.deleteString(0, this.getTextLength() - this.myBufferSize);
        }
    }

    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (startOffset == endOffset) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, this.myText.subSequence(startOffset, endOffset), "");
        }
        ImmutableCharSequence newText = this.myText.delete(startOffset, endOffset);
        ImmutableCharSequence oldString = this.myText.subtext(startOffset, endOffset);
        this.updateText(newText, startOffset, (CharSequence)oldString, "", false, LocalTimeCounter.currentTime(), startOffset, endOffset - startOffset, startOffset);
    }

    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        this.assertBounds(srcStart, srcEnd);
        if (dstOffset == srcStart || dstOffset == srcEnd) {
            return;
        }
        ProperTextRange srcRange = new ProperTextRange(srcStart, srcEnd);
        assert (!srcRange.containsOffset(dstOffset)) : "Can't perform text move from range [" + srcStart + "; " + srcEnd + ") to offset " + dstOffset;
        String replacement = this.getCharsSequence().subSequence(srcStart, srcEnd).toString();
        int shift = dstOffset < srcStart ? srcEnd - srcStart : 0;
        this.replaceString(dstOffset, dstOffset, srcStart + shift, replacement, LocalTimeCounter.currentTime(), false);
        this.replaceString(srcStart + shift, srcEnd + shift, dstOffset, "", LocalTimeCounter.currentTime(), false);
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        this.replaceString(startOffset, endOffset, startOffset, s, LocalTimeCounter.currentTime(), false);
    }

    public void replaceString(int startOffset, int endOffset, int moveOffset, @NotNull CharSequence s, long newModificationStamp, boolean wholeTextReplaced) {
        ImmutableCharSequence newText;
        int newEndInString;
        int newStartInString;
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (moveOffset != startOffset && startOffset != endOffset && s.length() != 0) {
            throw new IllegalArgumentException("moveOffset != startOffset for a modification which is neither an insert nor deletion. startOffset: " + startOffset + "; endOffset: " + endOffset + ";; moveOffset: " + moveOffset + ";");
        }
        int initialStartOffset = startOffset;
        int initialOldLength = endOffset - startOffset;
        int newStringLength = s.length();
        ImmutableCharSequence chars = this.myText;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        if (newStartInString == newStringLength && startOffset == endOffset && !wholeTextReplaced) {
            return;
        }
        for (newEndInString = newStringLength; endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1); --newEndInString, --endOffset) {
        }
        if (startOffset == 0 && endOffset == this.getTextLength()) {
            wholeTextReplaced = true;
        }
        CharSequence changedPart = s.subSequence(newStartInString, newEndInString);
        ImmutableCharSequence sToDelete = this.myText.subtext(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, (CharSequence)sToDelete, changedPart);
        }
        if (wholeTextReplaced && s instanceof ImmutableCharSequence) {
            newText = (ImmutableCharSequence)s;
        } else {
            this.myText.delete(startOffset, endOffset);
            newText = this.myText.insert(startOffset, changedPart);
            changedPart = newText.subtext(startOffset, startOffset + changedPart.length());
        }
        boolean wasOptimized = initialStartOffset != startOffset || endOffset - startOffset != initialOldLength;
        this.updateText(newText, startOffset, (CharSequence)sToDelete, changedPart, wholeTextReplaced, newModificationStamp, initialStartOffset, initialOldLength, wasOptimized ? startOffset : moveOffset);
        this.trimToSize();
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    public boolean isWriteThreadOnly() {
        return this.myAssertThreading;
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
            VirtualFile file = FileDocumentManager.getInstance().getFile((Document)((Object)this));
            if (file != null && file.isInLocalFileSystem()) {
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
            }
        }
        if (this.myIsReadOnly) {
            throw new ReadOnlyModificationException((Document)((Object)this), CoreBundle.message((String)"attempt.to.modify.read.only.document.error.message", (Object[])new Object[0]));
        }
        for (DocumentWriteAccessGuard guard : (DocumentWriteAccessGuard[])DocumentWriteAccessGuard.EP_NAME.getExtensions()) {
            DocumentWriteAccessGuard.Result result = guard.isWritable((Document)((Object)this));
            if (result.isSuccess()) continue;
            throw new ReadOnlyModificationException((Document)((Object)this), String.format("%s: guardClass=%s, failureReason=%s", CoreBundle.message((String)"attempt.to.modify.read.only.document.error.message", (Object[])new Object[0]), guard.getClass().getName(), result.getFailureReason()));
        }
    }

    private void assertValidSeparators(@NotNull CharSequence s) {
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators((CharSequence)s);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected document modification from DocumentListener");
        }
    }

    private void throwGuardedFragment(@NotNull RangeMarker guard, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString) {
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl((Document)((Object)this), offset, oldString, newString, this.myModificationStamp, false, offset, oldString.length(), offset);
            throw new ReadOnlyFragmentModificationException((DocumentEvent)event, guard);
        }
    }

    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    public void clearLineModificationFlags() {
        this.myLineSet = this.getLineSet().clearModificationFlags();
        this.myFrozen = null;
    }

    public void clearLineModificationFlags(int startLine, int endLine) {
        this.myLineSet = this.getLineSet().clearModificationFlags(startLine, endLine);
        this.myFrozen = null;
    }

    void clearLineModificationFlagsExcept(int[] caretLines) {
        IntArrayList modifiedLines = new IntArrayList(caretLines.length);
        LineSet lineSet = this.getLineSet();
        for (int line : caretLines) {
            if (line < 0 || line >= lineSet.getLineCount() || !lineSet.isModified(line)) continue;
            modifiedLines.add(line);
        }
        lineSet = lineSet.clearModificationFlags();
        this.myLineSet = lineSet = lineSet.setModified((IntList)modifiedLines);
        this.myFrozen = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText(@NotNull ImmutableCharSequence newText, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, boolean wholeTextReplaced, long newModificationStamp, int initialStartOffset, int initialOldLength, int moveOffset) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("updating document " + (Object)((Object)this) + ".\nNext string:'" + newString + "'\nOld string:'" + oldString + "'");
        }
        assert (moveOffset >= 0 && moveOffset <= this.getTextLength()) : "Invalid moveOffset: " + moveOffset;
        this.assertNotNestedModification();
        this.myChangeInProgress = true;
        DelayedExceptions exceptions = new DelayedExceptions();
        try {
            DocumentEventImpl event = new DocumentEventImpl((Document)((Object)this), offset, oldString, newString, this.myModificationStamp, wholeTextReplaced, initialStartOffset, initialOldLength, moveOffset);
            this.beforeChangedUpdate((DocumentEvent)event, exceptions);
            this.myTextString = null;
            ImmutableCharSequence prevText = this.myText;
            this.myText = newText;
            this.sequence.incrementAndGet();
            this.changedUpdate((DocumentEvent)event, newModificationStamp, (CharSequence)prevText, exceptions);
        }
        finally {
            this.myChangeInProgress = false;
            exceptions.rethrowPCE();
        }
    }

    public int getModificationSequence() {
        return this.sequence.get();
    }

    private void beforeChangedUpdate(DocumentEvent event, DelayedExceptions exceptions) {
        FileDocumentManager manager;
        VirtualFile file;
        Application app = ApplicationManager.getApplication();
        if (app != null && (file = (manager = FileDocumentManager.getInstance()).getFile((Document)((Object)this))) != null && !file.isValid()) {
            LOG.error("File of this document has been deleted: " + file);
        }
        this.assertInsideCommand();
        this.getLineSet();
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange(event);
                    continue;
                }
                catch (Throwable e) {
                    exceptions.register(e);
                }
            }
        }
        this.myEventsHandling = true;
    }

    private void assertInsideCommand() {
        if (!this.myAssertThreading) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (!commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
            throw new IncorrectOperationException("Must not change document outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changedUpdate(@NotNull DocumentEvent event, long newModificationStamp, @NotNull CharSequence prevText, DelayedExceptions exceptions) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace(new Throwable(event.toString()));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            assert (event.getOldFragment().length() == event.getOldLength()) : "event.getOldFragment().length() = " + event.getOldFragment().length() + "; event.getOldLength() = " + event.getOldLength();
            assert (event.getNewFragment().length() == event.getNewLength()) : "event.getNewFragment().length() = " + event.getNewFragment().length() + "; event.getNewLength() = " + event.getNewLength();
            assert (prevText.length() + event.getNewLength() - event.getOldLength() == this.getTextLength()) : "prevText.length() = " + prevText.length() + "; event.getNewLength() = " + event.getNewLength() + "; event.getOldLength() = " + event.getOldLength() + "; getTextLength() = " + this.getTextLength();
            this.myLineSet = this.getLineSet().update(prevText, event.getOffset(), event.getOffset() + event.getOldLength(), event.getNewFragment(), event.isWholeTextReplaced());
            assert (this.getTextLength() == this.myLineSet.getLength()) : "getTextLength() = " + this.getTextLength() + "; myLineSet.getLength() = " + this.myLineSet.getLength();
            this.myFrozen = null;
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener : listeners = this.getListeners()) {
                    try {
                        listener.documentChanged(event);
                    }
                    catch (Throwable e) {
                        exceptions.register(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @NotNull
    public String getText() {
        return (String)ReadAction.compute(this::doGetText);
    }

    public void setText(@NotNull CharSequence text) {
        Runnable runnable = () -> this.replaceString(0, this.getTextLength(), 0, text, LocalTimeCounter.currentTime(), true);
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress() || !this.myAssertThreading) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable, "", (Object)DocCommandGroupId.noneGroupId((Document)((Object)this)));
        }
        this.clearLineModificationFlags();
    }

    @NotNull
    private String doGetText() {
        String s = (String)SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference((Object)s);
        }
        return s;
    }

    @NotNull
    public String getText(@NotNull TextRange range) {
        return (String)ReadAction.compute(() -> this.myText.subSequence(range.getStartOffset(), range.getEndOffset()).toString());
    }

    public int getTextLength() {
        return this.myText.length();
    }

    @NotNull
    public CharSequence getCharsSequence() {
        return this.myMutableCharSequence;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        return this.myText;
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (ArrayUtil.contains((Object)listener, (Object[])this.getListeners())) {
            LOG.error("Already registered: " + listener);
        }
        this.myDocumentListeners.add(listener);
    }

    public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        this.addDocumentListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new DocumentListenerDisposable(this.myDocumentListeners, listener));
    }

    public void removeDocumentListener(@NotNull DocumentListener listener) {
        boolean success = this.myDocumentListeners.remove(listener);
        if (!success) {
            LOG.error("Can't remove document listener (" + listener + "). Registered listeners: " + Arrays.toString(this.getListeners()));
        }
    }

    public int getLineNumber(int offset) {
        return this.getLineSet().findLineIndex(offset);
    }

    public int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    public int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result >= 0);
        return result;
    }

    public int getLineSeparatorLength(int line) {
        int separatorLength = this.getLineSet().getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    public int getLineCount() {
        int lineCount = this.getLineSet().getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    private DocumentListener[] getListeners() {
        return this.myDocumentListeners.getArray();
    }

    public void fireReadOnlyModificationAttempt() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setCyclicBufferSize(int bufferSize) {
        assert (bufferSize >= 0) : bufferSize;
        this.myBufferSize = bufferSize;
    }

    public boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    public void setInBulkUpdate(boolean value) {
        if (this.myAssertThreading) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        if (this.myUpdatingBulkModeStatus) {
            throw new IllegalStateException("Detected bulk mode status update from DocumentBulkUpdateListener");
        }
        if (this.myDoingBulkUpdate == value) {
            return;
        }
        this.myUpdatingBulkModeStatus = true;
        try {
            if (value) {
                this.notifyListenersOnBulkModeStarting();
                this.myBulkUpdateEnteringTrace = new Throwable();
                this.myDoingBulkUpdate = true;
            } else {
                this.myDoingBulkUpdate = false;
                this.myBulkUpdateEnteringTrace = null;
                this.notifyListenersOnBulkModeFinished();
            }
        }
        finally {
            this.myUpdatingBulkModeStatus = false;
        }
    }

    private void notifyListenersOnBulkModeStarting() {
        DelayedExceptions exceptions = new DelayedExceptions();
        DocumentListener[] listeners = this.getListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
        }
        exceptions.rethrowPCE();
    }

    private void notifyListenersOnBulkModeFinished() {
        DocumentListener[] listeners;
        DelayedExceptions exceptions = new DelayedExceptions();
        for (DocumentListener documentListener : listeners = this.getListeners()) {
        }
        exceptions.rethrowPCE();
    }

    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor) {
        return this.processRangeMarkersOverlappingWith(0, this.getTextLength(), processor);
    }

    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String dumpState() {
        StringBuilder result = new StringBuilder();
        result.append("intervals:\n");
        int lineCount = this.getLineCount();
        for (int line = 0; line < lineCount; ++line) {
            result.append(line).append(": ").append(this.getLineStartOffset(line)).append("-").append(this.getLineEndOffset(line)).append(", ");
        }
        if (lineCount > 0) {
            result.setLength(result.length() - 2);
        }
        return result.toString();
    }

    public String toString() {
        return "DocumentImpl[" + FileDocumentManager.getInstance().getFile((Document)((Object)this)) + (this.isInEventsHandling() ? ",inEventHandling" : "") + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FrozenDocument freeze() {
        FrozenDocument frozen = this.myFrozen;
        if (frozen == null) {
            Object object = this.myLineSetLock;
            synchronized (object) {
                frozen = this.myFrozen;
                if (frozen == null) {
                    this.myFrozen = frozen = new FrozenDocument(this.myText, this.myLineSet, this.myModificationStamp, (String)SoftReference.dereference(this.myTextString));
                }
            }
        }
        return frozen;
    }

    public void assertNotInBulkUpdate() {
        if (this.myDoingBulkUpdate) {
            throw new UnexpectedBulkUpdateStateException(this.myBulkUpdateEnteringTrace);
        }
    }

    private static class RMTreeReference
    extends WeakReference<RangeMarkerTree<RangeMarkerEx>> {
        @NotNull
        private final VirtualFile virtualFile;

        RMTreeReference(@NotNull RangeMarkerTree<RangeMarkerEx> referent, @NotNull VirtualFile virtualFile) {
            super(referent, rmTreeQueue);
            this.virtualFile = virtualFile;
        }
    }

    private final class DelayedExceptions {
        Throwable myException;

        private DelayedExceptions() {
        }

        void register(Throwable e) {
            if (this.myException == null) {
                this.myException = e;
            } else {
                this.myException.addSuppressed(e);
            }
            if (!(e instanceof ProcessCanceledException)) {
                LOG.error(e);
            } else if (DocumentImpl.this.myAssertThreading) {
                LOG.error("ProcessCanceledException must not be thrown from document listeners for real document", new Throwable(e));
            }
        }

        void rethrowPCE() {
            if (this.myException instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)this.myException;
            }
        }
    }

    private static class DocumentListenerDisposable
    implements Disposable {
        @NotNull
        private final LockFreeCOWSortedArray<? super DocumentListener> myList;
        @NotNull
        private final DocumentListener myListener;

        DocumentListenerDisposable(@NotNull LockFreeCOWSortedArray<? super DocumentListener> list, @NotNull DocumentListener listener) {
            this.myList = list;
            this.myListener = listener;
        }

        public void dispose() {
            this.myList.remove((DocumentListener)this.myListener);
        }
    }

    private static final class UnexpectedBulkUpdateStateException
    extends RuntimeException
    implements ExceptionWithAttachments {
        private final Attachment[] myAttachments;

        private UnexpectedBulkUpdateStateException(Throwable enteringTrace) {
            super("Current operation is not permitted in bulk mode, see Document.setInBulkUpdate javadoc");
            Attachment[] attachmentArray;
            if (enteringTrace == null) {
                attachmentArray = Attachment.EMPTY_ARRAY;
            } else {
                Attachment[] attachmentArray2 = new Attachment[1];
                attachmentArray = attachmentArray2;
                attachmentArray2[0] = new Attachment("enteringTrace.txt", enteringTrace);
            }
            this.myAttachments = attachmentArray;
        }

        public Attachment[] getAttachments() {
            return this.myAttachments;
        }
    }
}

