/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.concurrency.JobLauncher;
import com.intellij.core.CoreEncodingRegistry;
import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.impl.CoreVirtualFilePointerManager;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiReferenceServiceImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.stubs.CoreStubTreeLoader;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.impl.GraphAlgorithmsImpl;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class CoreApplicationEnvironment {
    @NotNull
    protected final VirtualFileSystem myJarFileSystem;
    protected final MockApplication myApplication;
    private final CoreFileTypeRegistry myFileTypeRegistry;
    private final CoreLocalFileSystem myLocalFileSystem;
    private final VirtualFileSystem myJrtFileSystem;
    @NotNull
    private final Disposable myParentDisposable;
    private final boolean myUnitTestMode;

    public CoreApplicationEnvironment(@NotNull Disposable parentDisposable) {
        this(parentDisposable, true);
    }

    public CoreApplicationEnvironment(@NotNull Disposable parentDisposable, boolean unitTestMode) {
        this.myParentDisposable = parentDisposable;
        this.myUnitTestMode = unitTestMode;
        DisabledPluginsState.setIgnoreDisabledPlugins((boolean)true);
        this.myFileTypeRegistry = new CoreFileTypeRegistry();
        this.myApplication = this.createApplication(this.myParentDisposable);
        ApplicationManager.setApplication((Application)this.myApplication, () -> this.myFileTypeRegistry, (Disposable)this.myParentDisposable);
        this.myLocalFileSystem = this.createLocalFileSystem();
        this.myJarFileSystem = this.createJarFileSystem();
        this.myJrtFileSystem = this.createJrtFileSystem();
        this.registerApplicationService(FileDocumentManager.class, new MockFileDocumentManagerImpl(null, DocumentImpl::new));
        CoreApplicationEnvironment.registerApplicationExtensionPoint(new ExtensionPointName("com.intellij.virtualFileManagerListener"), VirtualFileManagerListener.class);
        List<VirtualFileSystem> fs = this.myJrtFileSystem != null ? Arrays.asList(this.myLocalFileSystem, this.myJarFileSystem, this.myJrtFileSystem) : Arrays.asList(this.myLocalFileSystem, this.myJarFileSystem);
        this.registerApplicationService(VirtualFileManager.class, new VirtualFileManagerImpl(fs));
        CoreApplicationEnvironment.registerApplicationExtensionPoint(new ExtensionPointName("com.intellij.virtualFileSystem"), KeyedLazyInstanceEP.class);
        this.registerApplicationService(EncodingManager.class, new CoreEncodingRegistry());
        this.registerApplicationService(VirtualFilePointerManager.class, this.createVirtualFilePointerManager());
        this.registerApplicationService(DefaultASTFactory.class, new DefaultASTFactoryImpl());
        this.registerApplicationService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.registerApplicationService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        this.registerApplicationService(StubTreeLoader.class, new CoreStubTreeLoader());
        this.registerApplicationService(PsiReferenceService.class, new PsiReferenceServiceImpl());
        this.registerApplicationService(ProgressManager.class, this.createProgressIndicatorProvider());
        this.registerApplicationService(JobLauncher.class, this.createJobLauncher());
        this.registerApplicationService(CodeFoldingSettings.class, new CodeFoldingSettings());
        this.registerApplicationService(CommandProcessor.class, new CoreCommandProcessor());
        this.registerApplicationService(GraphAlgorithms.class, new GraphAlgorithmsImpl());
        this.myApplication.registerService(ApplicationInfo.class, ApplicationInfoImpl.class);
        CoreApplicationEnvironment.registerApplicationExtensionPoint(DynamicBundle.LanguageBundleEP.EP_NAME, DynamicBundle.LanguageBundleEP.class);
    }

    public static <T> void registerComponentInstance(@NotNull MutablePicoContainer container, @NotNull Class<T> key, @NotNull T implementation) {
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        CoreApplicationEnvironment.registerExtensionPoint(area, extensionPointName.getName(), aClass);
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull String name, @NotNull Class<? extends T> aClass) {
        if (!area.hasExtensionPoint(name)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || Modifier.isAbstract(aClass.getModifiers()) ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name, aClass.getName(), kind);
        }
    }

    public static <T> void registerApplicationExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), extensionPointName.getName(), aClass);
    }

    public static <T> void registerApplicationDynamicExtensionPoint(@NotNull String extensionPointName, @NotNull Class<? extends T> aClass) {
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass);
    }

    public static void registerExtensionPointAndExtensions(@NotNull Path pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor = PluginDescriptorLoader.loadForCoreEnv((Path)pluginRoot, (String)fileName);
        if (descriptor == null) {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
            return;
        }
        List extensionPoints = descriptor.appContainerDescriptor.extensionPoints;
        ExtensionsAreaImpl areaImpl = (ExtensionsAreaImpl)area;
        if (extensionPoints != null) {
            areaImpl.registerExtensionPoints(extensionPoints, (PluginDescriptor)descriptor);
        }
        descriptor.registerExtensions(areaImpl.extensionPoints, descriptor.appContainerDescriptor, null);
    }

    public <T> void registerApplicationService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        this.myApplication.registerService(serviceInterface, serviceImplementation);
    }

    @Nullable
    protected VirtualFileSystem createJrtFileSystem() {
        return null;
    }

    @NotNull
    protected VirtualFilePointerManager createVirtualFilePointerManager() {
        return new CoreVirtualFilePointerManager();
    }

    @NotNull
    protected MockApplication createApplication(@NotNull Disposable parentDisposable) {
        return new MockApplication(parentDisposable){

            public boolean isUnitTestMode() {
                return CoreApplicationEnvironment.this.myUnitTestMode;
            }
        };
    }

    @NotNull
    protected JobLauncher createJobLauncher() {
        return new JobLauncher(){};
    }

    @NotNull
    protected ProgressManager createProgressIndicatorProvider() {
        return new CoreProgressManager();
    }

    @NotNull
    protected VirtualFileSystem createJarFileSystem() {
        return new CoreJarFileSystem();
    }

    @NotNull
    protected CoreLocalFileSystem createLocalFileSystem() {
        return new CoreLocalFileSystem();
    }

    @NotNull
    public MockApplication getApplication() {
        return this.myApplication;
    }

    @NotNull
    public Disposable getParentDisposable() {
        return this.myParentDisposable;
    }

    public <T> void registerApplicationComponent(@NotNull Class<T> interfaceClass, @NotNull T implementation) {
        CoreApplicationEnvironment.registerComponentInstance(this.myApplication.getPicoContainer(), interfaceClass, implementation);
        if (implementation instanceof Disposable) {
            Disposer.register((Disposable)this.myApplication, (Disposable)((Disposable)implementation));
        }
    }

    public void registerFileType(@NotNull FileType fileType, @NotNull @NonNls String extension) {
        this.myFileTypeRegistry.registerFileType(fileType, extension);
    }

    public void registerParserDefinition(@NotNull ParserDefinition definition) {
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), (Object)definition);
    }

    public <T> void addExplicitExtension(@NotNull LanguageExtension<T> instance, @NotNull Language language, @NotNull T object) {
        instance.addExplicitExtension((Object)language, object, this.myParentDisposable);
    }

    public void registerParserDefinition(@NotNull Language language, @NotNull ParserDefinition parserDefinition) {
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, language, (Object)parserDefinition);
    }

    public <T> void addExplicitExtension(@NotNull FileTypeExtension<T> instance, @NotNull FileType fileType, @NotNull T object) {
        instance.addExplicitExtension((Object)fileType, object, this.myParentDisposable);
    }

    public <T> void addExplicitExtension(@NotNull ClassExtension<T> instance, @NotNull Class aClass, @NotNull T object) {
        instance.addExplicitExtension((Object)aClass, object, this.myParentDisposable);
    }

    public <T> void addExtension(@NotNull ExtensionPointName<T> name, @NotNull T extension) {
        ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(name);
        extensionPoint.registerExtension(extension, this.myParentDisposable);
    }

    @NotNull
    public CoreLocalFileSystem getLocalFileSystem() {
        return this.myLocalFileSystem;
    }

    @NotNull
    public VirtualFileSystem getJarFileSystem() {
        return this.myJarFileSystem;
    }

    @Nullable
    public VirtualFileSystem getJrtFileSystem() {
        return this.myJrtFileSystem;
    }
}

