/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import jdk.xml.internal.SecuritySupport;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.NewInstance;

@Deprecated(since="9")
public final class XMLReaderFactory {
    private static final String property = "org.xml.sax.driver";

    private XMLReaderFactory() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        XMLReader provider;
        String className = null;
        ClassLoader cl = SecuritySupport.getClassLoader();
        try {
            className = SecuritySupport.getSystemProperty(property);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (className == null && (provider = XMLReaderFactory.findServiceProvider(XMLReader.class, cl)) != null) {
            return provider;
        }
        if (className == null) {
            className = XMLReaderFactory.jarLookup(cl);
        }
        if (className == null) {
            return new SAXParser();
        }
        return XMLReaderFactory.loadClass(cl, className);
    }

    public static XMLReader createXMLReader(String className) throws SAXException {
        return XMLReaderFactory.loadClass(SecuritySupport.getClassLoader(), className);
    }

    private static XMLReader loadClass(ClassLoader loader, String className) throws SAXException {
        try {
            return NewInstance.newInstance(XMLReader.class, loader, className);
        }
        catch (ClassNotFoundException e1) {
            throw new SAXException("SAX2 driver class " + className + " not found", e1);
        }
        catch (IllegalAccessException e2) {
            throw new SAXException("SAX2 driver class " + className + " found but cannot be loaded", e2);
        }
        catch (InstantiationException e3) {
            throw new SAXException("SAX2 driver class " + className + " loaded but cannot be instantiated (no empty public constructor?)", e3);
        }
        catch (ClassCastException e4) {
            throw new SAXException("SAX2 driver class " + className + " does not implement XMLReader", e4);
        }
    }

    private static String jarLookup(ClassLoader loader) {
        ClassLoader cl = Objects.requireNonNull(loader);
        String clsFromJar = null;
        String service = "META-INF/services/org.xml.sax.driver";
        try {
            InputStream in = SecuritySupport.getResourceAsStream(cl, service);
            if (in == null) {
                in = SecuritySupport.getResourceAsStream(null, service);
            }
            if (in != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
                clsFromJar = reader.readLine();
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return clsFromJar;
    }

    private static <T> T findServiceProvider(Class<T> type, ClassLoader loader) throws SAXException {
        ClassLoader cl = Objects.requireNonNull(loader);
        try {
            return (T)AccessController.doPrivileged(() -> {
                ServiceLoader serviceLoader = ServiceLoader.load(type, cl);
                Iterator iterator = serviceLoader.iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                return null;
            });
        }
        catch (ServiceConfigurationError e) {
            RuntimeException x = new RuntimeException("Provider for " + type + " cannot be created", e);
            throw new SAXException("Provider for " + type + " cannot be created", x);
        }
    }
}

