/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

class NewInstance {
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xerces.internal";
    private static final String DEFAULT_CLASS = "com.sun.org.apache.xerces.internal.parsers.SAXParser";

    NewInstance() {
    }

    static <T> T newInstance(Class<T> type, ClassLoader loader, String clsName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClassLoader classLoader = Objects.requireNonNull(loader);
        String className = Objects.requireNonNull(clsName);
        if (className.equals(DEFAULT_CLASS)) {
            return type.cast(new SAXParser());
        }
        boolean internal = false;
        if (System.getSecurityManager() != null && className != null && className.startsWith(DEFAULT_PACKAGE)) {
            internal = true;
        }
        Class<?> driverClass = classLoader == null || internal ? Class.forName(className) : classLoader.loadClass(className);
        try {
            return type.cast(driverClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new InstantiationException(ex.getMessage());
        }
    }
}

