/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom.bootstrap;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.DOMImplementationSource;

public final class DOMImplementationRegistry {
    public static final String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private static final int DEFAULT_LINE_LENGTH = 80;
    private List<DOMImplementationSource> sources;
    private static final String FALLBACK_CLASS = "com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl";
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xerces.internal.dom";

    private DOMImplementationRegistry(List<DOMImplementationSource> srcs) {
        this.sources = srcs;
    }

    public static DOMImplementationRegistry newInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        ArrayList<DOMImplementationSource> sources = new ArrayList<DOMImplementationSource>();
        ClassLoader classLoader = DOMImplementationRegistry.getClassLoader();
        String p = DOMImplementationRegistry.getSystemProperty(PROPERTY);
        if (p == null) {
            p = DOMImplementationRegistry.getServiceValue(classLoader);
        }
        if (p == null) {
            p = FALLBACK_CLASS;
        }
        if (p != null) {
            StringTokenizer st = new StringTokenizer(p);
            while (st.hasMoreTokens()) {
                String sourceName = st.nextToken();
                boolean internal = false;
                if (System.getSecurityManager() != null && sourceName != null && sourceName.startsWith(DEFAULT_PACKAGE)) {
                    internal = true;
                }
                Class<?> sourceClass = null;
                sourceClass = classLoader != null && !internal ? classLoader.loadClass(sourceName) : Class.forName(sourceName);
                try {
                    DOMImplementationSource source = (DOMImplementationSource)sourceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    sources.add(source);
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    throw new InstantiationException(e.getMessage());
                }
            }
        }
        return new DOMImplementationRegistry(sources);
    }

    public DOMImplementation getDOMImplementation(String features) {
        int size = this.sources.size();
        Object name = null;
        for (int i = 0; i < size; ++i) {
            DOMImplementationSource source = this.sources.get(i);
            DOMImplementation impl = source.getDOMImplementation(features);
            if (impl == null) continue;
            return impl;
        }
        return null;
    }

    public DOMImplementationList getDOMImplementationList(String features) {
        final ArrayList<DOMImplementation> implementations = new ArrayList<DOMImplementation>();
        int size = this.sources.size();
        for (int i = 0; i < size; ++i) {
            DOMImplementationSource source = this.sources.get(i);
            DOMImplementationList impls = source.getDOMImplementationList(features);
            for (int j = 0; j < impls.getLength(); ++j) {
                DOMImplementation impl = impls.item(j);
                implementations.add(impl);
            }
        }
        return new DOMImplementationList(){

            @Override
            public DOMImplementation item(int index) {
                if (index >= 0 && index < implementations.size()) {
                    try {
                        return (DOMImplementation)implementations.get(index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        return null;
                    }
                }
                return null;
            }

            @Override
            public int getLength() {
                return implementations.size();
            }
        };
    }

    public void addSource(DOMImplementationSource s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (!this.sources.contains(s)) {
            this.sources.add(s);
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader contextClassLoader = DOMImplementationRegistry.getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader;
            }
        }
        catch (Exception e) {
            return DOMImplementationRegistry.class.getClassLoader();
        }
        return DOMImplementationRegistry.class.getClassLoader();
    }

    private static String getServiceValue(ClassLoader classLoader) {
        block5: {
            String serviceId = "META-INF/services/org.w3c.dom.DOMImplementationSourceList";
            try {
                BufferedReader rd;
                InputStream is = DOMImplementationRegistry.getResourceAsStream(classLoader, serviceId);
                if (is == null) break block5;
                try {
                    rd = new BufferedReader(new InputStreamReader(is, "UTF-8"), 80);
                }
                catch (UnsupportedEncodingException e) {
                    rd = new BufferedReader(new InputStreamReader(is), 80);
                }
                String serviceValue = rd.readLine();
                rd.close();
                if (serviceValue != null && serviceValue.length() > 0) {
                    return serviceValue;
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    private static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    private static InputStream getResourceAsStream(final ClassLoader classLoader, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                InputStream ris = classLoader == null ? ClassLoader.getSystemResourceAsStream(name) : classLoader.getResourceAsStream(name);
                return ris;
            }
        });
    }
}

