/*
 * Decompiled with CFR 0.152.
 */
package jdk.xml.internal;

import jdk.xml.internal.JdkProperty;
import jdk.xml.internal.SecuritySupport;

public class JdkXmlFeatures {
    public static final String ORACLE_JAXP_PROPERTY_PREFIX = "http://www.oracle.com/xml/jaxp/properties/";
    public static final String XML_FEATURE_MANAGER = "http://www.oracle.com/xml/jaxp/properties/XmlFeatureManager";
    public static final String CATALOG_FEATURES = "javax.xml.catalog.catalogFeatures";
    public static final String PROPERTY_USE_CATALOG = "http://javax.xml.XMLConstants/feature/useCatalog";
    private final boolean[] featureValues = new boolean[XmlFeature.values().length];
    private final JdkProperty.State[] states = new JdkProperty.State[XmlFeature.values().length];
    boolean secureProcessing;

    public JdkXmlFeatures(boolean secureProcessing) {
        this.secureProcessing = secureProcessing;
        for (XmlFeature f : XmlFeature.values()) {
            if (secureProcessing && f.enforced()) {
                this.featureValues[f.ordinal()] = f.enforcedValue();
                this.states[f.ordinal()] = JdkProperty.State.FSP;
                continue;
            }
            this.featureValues[f.ordinal()] = f.defaultValue();
            this.states[f.ordinal()] = JdkProperty.State.DEFAULT;
        }
        this.readSystemProperties();
    }

    public void update() {
        this.readSystemProperties();
    }

    public boolean setFeature(String propertyName, JdkProperty.State state, Object value) {
        JdkProperty.State pState = state;
        XmlFeature f = this.findByName(propertyName);
        if (f != null) {
            if (state == JdkProperty.State.APIPROPERTY) {
                pState = f.getState(propertyName);
            }
            if (pState != null) {
                this.setFeature(f.ordinal(), pState, value);
                return true;
            }
        }
        return false;
    }

    public void setFeature(XmlFeature feature, JdkProperty.State state, boolean value) {
        this.setFeature(feature.ordinal(), state, value);
    }

    public boolean getFeature(XmlFeature feature) {
        return this.featureValues[feature.ordinal()];
    }

    public boolean getFeature(int index) {
        return this.featureValues[index];
    }

    public void setFeature(int index, JdkProperty.State state, Object value) {
        boolean temp = Boolean.class.isAssignableFrom(value.getClass()) ? (Boolean)value : Boolean.parseBoolean((String)value);
        this.setFeature(index, state, temp);
    }

    public void setFeature(int index, JdkProperty.State state, boolean value) {
        if (state.compareTo(this.states[index]) >= 0) {
            this.featureValues[index] = value;
            this.states[index] = state;
        }
    }

    public XmlFeature findByName(String propertyName) {
        for (XmlFeature feature : XmlFeature.values()) {
            if (!feature.equalsPropertyName(propertyName)) continue;
            return feature;
        }
        return null;
    }

    public int getIndex(String propertyName) {
        for (XmlFeature feature : XmlFeature.values()) {
            if (!feature.equalsPropertyName(propertyName)) continue;
            return feature.ordinal();
        }
        return -1;
    }

    private void readSystemProperties() {
        for (XmlFeature feature : XmlFeature.values()) {
            String oldName;
            if (this.getSystemProperty(feature, feature.systemProperty()) || (oldName = feature.systemPropertyOld()) == null) continue;
            this.getSystemProperty(feature, oldName);
        }
    }

    private boolean getSystemProperty(XmlFeature feature, String sysPropertyName) {
        try {
            String value = SecuritySupport.getSystemProperty(sysPropertyName);
            if (value != null && !value.isEmpty()) {
                this.setFeature(feature, JdkProperty.State.SYSTEMPROPERTY, Boolean.parseBoolean(value));
                return true;
            }
            value = SecuritySupport.readJAXPProperty(sysPropertyName);
            if (value != null && !value.isEmpty()) {
                this.setFeature(feature, JdkProperty.State.JAXPDOTPROPERTIES, Boolean.parseBoolean(value));
                return true;
            }
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid setting for system property: " + feature.systemProperty());
        }
        return false;
    }

    public static enum XmlFeature {
        ENABLE_EXTENSION_FUNCTION(JdkProperty.ImplPropMap.ENABLEEXTFUNC, null, null, true, null, null, true, false, true, true),
        USE_CATALOG(null, "http://javax.xml.XMLConstants/feature/useCatalog", "javax.xml.useCatalog", false, null, null, true, false, true, false),
        RESET_SYMBOL_TABLE_FEATURE(JdkProperty.ImplPropMap.RESETSYMBOLTABLE, null, null, false, null, null, false, false, true, false),
        JDK_OVERRIDE_PARSER(JdkProperty.ImplPropMap.OVERRIDEPARSER, null, null, false, null, null, false, false, true, false);

        private final JdkProperty.ImplPropMap implMap;
        private final String name;
        private final String nameSP;
        private final boolean differ;
        private final String nameOld;
        private final String nameOldSP;
        private final boolean valueDefault;
        private final boolean valueEnforced;
        private final boolean hasSystem;
        private final boolean enforced;

        private XmlFeature(JdkProperty.ImplPropMap implMap, String name, String nameSP, boolean differ, String nameOld, String nameOldSP, boolean value, boolean valueEnforced, boolean hasSystem, boolean enforced) {
            this.implMap = implMap;
            if (implMap != null) {
                this.name = implMap.qName();
                this.nameSP = implMap.systemProperty();
                this.nameOld = implMap.qNameOld();
                this.nameOldSP = implMap.systemPropertyOld();
            } else {
                this.name = name;
                this.nameSP = nameSP;
                this.nameOld = nameOld;
                this.nameOldSP = nameOldSP;
            }
            this.differ = differ;
            this.valueDefault = value;
            this.valueEnforced = valueEnforced;
            this.hasSystem = hasSystem;
            this.enforced = enforced;
        }

        boolean equalsPropertyName(String propertyName) {
            if (this.implMap != null) {
                return this.implMap.is(propertyName);
            }
            return this.name.equals(propertyName) || this.nameOld != null && this.nameOld.equals(propertyName);
        }

        public String apiProperty() {
            return this.name;
        }

        String systemProperty() {
            return this.nameSP;
        }

        String systemPropertyOld() {
            return this.nameOldSP;
        }

        public boolean defaultValue() {
            return this.valueDefault;
        }

        public boolean enforcedValue() {
            return this.valueEnforced;
        }

        boolean hasSystemProperty() {
            return this.hasSystem;
        }

        boolean enforced() {
            return this.enforced;
        }

        public JdkProperty.State getState(String name) {
            if (this.implMap != null) {
                return this.implMap.getState(name);
            }
            if (this.name.equals(name)) {
                return JdkProperty.State.APIPROPERTY;
            }
            return null;
        }
    }
}

