/*
 * Decompiled with CFR 0.152.
 */
package jdk.xml.internal;

import jdk.xml.internal.SecuritySupport;

public final class JdkProperty<T> {
    private final ImplPropMap pName;
    private final Class<T> pType;
    private T pValue;
    private State pState = State.DEFAULT;

    public JdkProperty(ImplPropMap name, Class<T> type, T value, State state) {
        this.pName = name;
        this.pType = type;
        this.pValue = value;
        this.pState = state;
        this.readSystemProperty();
    }

    private void readSystemProperty() {
        if (this.pState == State.DEFAULT) {
            Object value = null;
            if (this.pName.systemProperty() != null) {
                value = SecuritySupport.getJAXPSystemProperty(this.pType, this.pName.systemProperty(), null);
            }
            if (value == null && this.pName.systemPropertyOld() != null) {
                value = SecuritySupport.getJAXPSystemProperty(this.pType, this.pName.systemPropertyOld(), null);
            }
            if (value != null) {
                this.pValue = value;
                this.pState = State.SYSTEMPROPERTY;
            }
        }
    }

    public T getValue() {
        return this.pValue;
    }

    public boolean setValue(String name, T value, State state) {
        State pState1 = this.pName.getState(name);
        if (pState1 != null && pState1.compareTo(this.pState) >= 0) {
            this.pState = pState1;
            this.pValue = value;
            return true;
        }
        return false;
    }

    public static enum State {
        DEFAULT("default"),
        FSP("FEATURE_SECURE_PROCESSING"),
        JAXPDOTPROPERTIES("jaxp.properties"),
        LEGACY_SYSTEMPROPERTY("legacy system property"),
        SYSTEMPROPERTY("system property"),
        LEGACY_APIPROPERTY("legacy property"),
        APIPROPERTY("property");

        final String literal;

        private State(String literal) {
            this.literal = literal;
        }

        public String literal() {
            return this.literal;
        }
    }

    public static enum ImplPropMap {
        ISSTANDALONE("isStandalone", "http://www.oracle.com/xml/jaxp/properties/isStandalone", "jdk.xml.isStandalone", true, null, null),
        XSLTCISSTANDALONE("xsltcIsStandalone", "http://www.oracle.com/xml/jaxp/properties/xsltcIsStandalone", "jdk.xml.xsltcIsStandalone", true, "http://www.oracle.com/xml/is-standalone", null),
        CDATACHUNKSIZE("cdataChunkSize", "jdk.xml.cdataChunkSize", "jdk.xml.cdataChunkSize", false, null, null),
        EXTCLSLOADER("extensionClassLoader", "jdk.xml.extensionClassLoader", null, true, "jdk.xml.transform.extensionClassLoader", null),
        ENABLEEXTFUNC("enableExtensionFunctions", "http://www.oracle.com/xml/jaxp/properties/enableExtensionFunctions", "jdk.xml.enableExtensionFunctions", true, null, "javax.xml.enableExtensionFunctions"),
        OVERRIDEPARSER("overrideDefaultParser", "jdk.xml.overrideDefaultParser", "jdk.xml.overrideDefaultParser", false, "http://www.oracle.com/feature/use-service-mechanism", "http://www.oracle.com/feature/use-service-mechanism"),
        RESETSYMBOLTABLE("resetSymbolTable", "jdk.xml.resetSymbolTable", "jdk.xml.resetSymbolTable", false, null, null),
        ENTITYCOUNT("getEntityCountInfo", "jdk.xml.getEntityCountInfo", null, true, "http://www.oracle.com/xml/jaxp/properties/getEntityCountInfo", null);

        private final String name;
        private final String qName;
        private final String spName;
        private final boolean differ;
        private final String oldQName;
        private final String oldSPName;

        private ImplPropMap(String name, String qName, String spName, boolean differ, String oldQName, String oldSPName) {
            this.name = name;
            this.qName = qName;
            this.spName = spName;
            this.differ = differ;
            this.oldQName = oldQName;
            this.oldSPName = oldSPName;
        }

        public boolean is(String name) {
            return this.spName != null && this.spName.equals(name) || this.differ && this.qName.equals(name) || this.oldQName != null && this.oldQName.equals(name);
        }

        public boolean isNameDiffer() {
            return this.differ;
        }

        public State getState(String name) {
            if (this.spName != null && this.spName.equals(name) || this.spName == null && this.qName.equals(name)) {
                return State.APIPROPERTY;
            }
            if (this.differ && this.qName.equals(name) || this.oldQName != null && this.oldQName.equals(name)) {
                return State.LEGACY_APIPROPERTY;
            }
            return null;
        }

        public String qName() {
            return this.qName;
        }

        public String qNameOld() {
            return this.oldQName;
        }

        public String systemProperty() {
            return this.spName;
        }

        public String systemPropertyOld() {
            return this.oldSPName;
        }
    }
}

