/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathNodes;
import org.w3c.dom.Node;

public interface XPathEvaluationResult<T> {
    public XPathResultType type();

    public T value();

    public static enum XPathResultType {
        ANY(new QName("http://www.w3.org/1999/XSL/Transform", "any"), XPathEvaluationResult.class),
        BOOLEAN(XPathConstants.BOOLEAN, Boolean.class),
        NUMBER(XPathConstants.NUMBER, Number.class),
        STRING(XPathConstants.STRING, String.class),
        NODESET(XPathConstants.NODESET, XPathNodes.class),
        NODE(XPathConstants.NODE, Node.class);

        final QName qnameType;
        final Class<?> clsType;

        private XPathResultType(QName qnameType, Class<?> clsType) {
            this.qnameType = qnameType;
            this.clsType = clsType;
        }

        private boolean equalsClassType(Class<?> clsType) {
            if (Objects.nonNull(clsType) && this.clsType.isAssignableFrom(clsType)) {
                if (this.clsType == Number.class) {
                    return this.isAcceptedNumberSubType(clsType);
                }
                return true;
            }
            return false;
        }

        private boolean isAcceptedNumberSubType(Class<?> clsType) {
            return clsType.isAssignableFrom(Double.class) || clsType.isAssignableFrom(Integer.class) || clsType.isAssignableFrom(Long.class);
        }

        public static QName getQNameType(Class<?> clsType) {
            for (XPathResultType type : XPathResultType.values()) {
                if (!type.equalsClassType(clsType)) continue;
                return type.qnameType;
            }
            return null;
        }
    }
}

