/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.catalog.CatalogFeatures;
import javax.xml.catalog.CatalogImpl;
import javax.xml.catalog.CatalogMessages;
import jdk.xml.internal.SecuritySupport;

class Util {
    static final String URN = "urn:publicid:";
    static final String PUBLICID_PREFIX = "-//";
    static final String PUBLICID_PREFIX_ALT = "+//";
    static final String SCHEME_FILE = "file";
    static final String SCHEME_JAR = "jar";
    static final String SCHEME_JARFILE = "jar:file:";

    Util() {
    }

    static String resolve(CatalogImpl catalog, String publicId, String systemId) {
        String resolvedSystemId;
        block4: {
            resolvedSystemId = null;
            catalog.reset();
            if (systemId != null) {
                resolvedSystemId = catalog.matchSystem(systemId);
            }
            if (resolvedSystemId == null && publicId != null) {
                resolvedSystemId = catalog.matchPublic(publicId);
            }
            if (resolvedSystemId == null && systemId != null) {
                resolvedSystemId = catalog.matchURI(systemId);
            }
            catalog.markAsSearched();
            if (resolvedSystemId != null) break block4;
            Iterator iter = catalog.catalogs().iterator();
            while (iter.hasNext() && (resolvedSystemId = Util.resolve((CatalogImpl)iter.next(), publicId, systemId)) == null) {
            }
        }
        return resolvedSystemId;
    }

    static void validateUrisSyntax(URI ... uris) {
        for (URI uri : uris) {
            Util.validateUriSyntax(uri);
        }
    }

    static void validateUrisSyntax(String ... uris) {
        for (String uri : uris) {
            Util.validateUriSyntax(URI.create(uri));
        }
    }

    static void validateUriSyntax(URI uri) {
        CatalogMessages.reportNPEOnNull("URI input", uri);
        if (!uri.isAbsolute()) {
            CatalogMessages.reportIAE("UriNotAbsolute", new Object[]{uri}, null);
        }
        try {
            uri.toURL();
        }
        catch (MalformedURLException ex) {
            CatalogMessages.reportIAE("UriNotValidUrl", new Object[]{uri}, null);
        }
    }

    static boolean isFileUri(URI uri) {
        return SCHEME_FILE.equals(uri.getScheme()) || SCHEME_JAR.equals(uri.getScheme());
    }

    static boolean isFileUriExist(URI uri, boolean openJarFile) {
        if (uri != null && uri.isAbsolute() && null != uri.getScheme()) {
            switch (uri.getScheme()) {
                case "file": {
                    String path = uri.getPath();
                    File f1 = new File(path);
                    if (!f1.isFile()) break;
                    return true;
                }
                case "jar": {
                    String tempUri = uri.toString();
                    int pos = tempUri.indexOf("!");
                    if (pos < 0) {
                        return false;
                    }
                    if (openJarFile) {
                        String jarFile = tempUri.substring(SCHEME_JARFILE.length(), pos);
                        String entryName = tempUri.substring(pos + 2);
                        try {
                            JarFile jf = new JarFile(jarFile);
                            JarEntry je = jf.getJarEntry(entryName);
                            if (je != null) {
                                return true;
                            }
                            break;
                        }
                        catch (IOException ex) {
                            return false;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    static String[] getCatalogFiles(String sysPropertyName) {
        String value = SecuritySupport.getJAXPSystemProperty(sysPropertyName);
        if (value != null && !value.isEmpty()) {
            return value.split(";");
        }
        return null;
    }

    static String getNotNullOrEmpty(String test) {
        if (test == null) {
            return test;
        }
        String temp = test.trim();
        if (temp.length() == 0) {
            return null;
        }
        return temp;
    }

    static void validateFeatureInput(CatalogFeatures.Feature f, String value) {
        CatalogMessages.reportNPEOnNull(f.name(), value);
        if (value.length() == 0) {
            CatalogMessages.reportIAE("InvalidArgument", new Object[]{value, f.name()}, null);
        }
        if (f == CatalogFeatures.Feature.PREFER) {
            if (!value.equals("system") && !value.equals("public")) {
                CatalogMessages.reportIAE("InvalidArgument", new Object[]{value, CatalogFeatures.Feature.PREFER.name()}, null);
            }
        } else if (f == CatalogFeatures.Feature.DEFER) {
            if (!value.equals("true") && !value.equals("false")) {
                CatalogMessages.reportIAE("InvalidArgument", new Object[]{value, CatalogFeatures.Feature.DEFER.name()}, null);
            }
        } else if (f == CatalogFeatures.Feature.RESOLVE) {
            if (!(value.equals("strict") || value.equals("continue") || value.equals("ignore"))) {
                CatalogMessages.reportIAE("InvalidArgument", new Object[]{value, CatalogFeatures.Feature.RESOLVE.name()}, null);
            }
        } else if (f == CatalogFeatures.Feature.FILES) {
            Util.validateUrisSyntax(value.split(";"));
        }
    }
}

