/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URL;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.Normalizer;

final class UriSuffix
extends BaseEntry {
    String uriSuffix;
    URL uri;

    public UriSuffix(String base, String uriSuffix, String uri) {
        super(BaseEntry.CatalogEntryType.URISUFFIX, base);
        this.setURISuffix(uriSuffix);
        this.setURI(uri);
    }

    public void setURISuffix(String uriSuffix) {
        CatalogMessages.reportNPEOnNull("uriSuffix", uriSuffix);
        this.uriSuffix = Normalizer.normalizeURI(uriSuffix);
    }

    public void setURI(String uri) {
        this.uri = this.verifyURI("setURI", this.baseURI, uri);
    }

    public String getURISuffix() {
        return this.uriSuffix;
    }

    public String getURI() {
        return this.uri.toString();
    }

    @Override
    public String match(String systemId, int currentMatch) {
        if (systemId.endsWith(this.uriSuffix) && currentMatch < this.uriSuffix.length()) {
            return this.uri.toString();
        }
        return null;
    }

    @Override
    public String match(String systemId) {
        return this.match(systemId, 0);
    }
}

