/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URL;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.Normalizer;

final class UriEntry
extends BaseEntry {
    String name;
    URL uri;

    public UriEntry(String base, String name, String uri) {
        super(BaseEntry.CatalogEntryType.URI, base);
        this.setName(name);
        this.setURI(uri);
    }

    public void setName(String name) {
        CatalogMessages.reportNPEOnNull("name", name);
        this.name = name.startsWith("-//") || name.startsWith("+//") ? Normalizer.normalizePublicId(name) : Normalizer.normalizeURI(name);
    }

    public void setURI(String uri) {
        this.uri = this.verifyURI("setURI", this.baseURI, uri);
    }

    public String getName() {
        return this.name;
    }

    public URL getURI() {
        return this.uri;
    }

    @Override
    public String match(String name) {
        if (this.name.equals(name)) {
            return this.uri.toString();
        }
        return null;
    }
}

