/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URL;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.Normalizer;

final class SystemSuffix
extends BaseEntry {
    String systemIdSuffix;
    URL uri;

    public SystemSuffix(String base, String systemIdSuffix, String uri) {
        super(BaseEntry.CatalogEntryType.SYSTEMSUFFIX, base);
        this.setSystemIdSuffix(systemIdSuffix);
        this.setURI(uri);
    }

    public void setSystemIdSuffix(String systemIdSuffix) {
        CatalogMessages.reportNPEOnNull("systemIdSuffix", systemIdSuffix);
        this.systemIdSuffix = Normalizer.normalizeURI(systemIdSuffix);
    }

    public void setURI(String uri) {
        this.uri = this.verifyURI("setURI", this.baseURI, uri);
    }

    public String getSystemIdSuffix() {
        return this.systemIdSuffix;
    }

    public URL getURI() {
        return this.uri;
    }

    @Override
    public String match(String systemId, int currentMatch) {
        if (systemId.endsWith(this.systemIdSuffix) && currentMatch < this.systemIdSuffix.length()) {
            return this.uri.toString();
        }
        return null;
    }

    @Override
    public String match(String systemId) {
        return this.match(systemId, 0);
    }
}

