/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URL;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.Normalizer;

final class SystemEntry
extends BaseEntry {
    String systemId;
    URL uri;

    public SystemEntry(String base, String systemId, String uri) {
        super(BaseEntry.CatalogEntryType.SYSTEM, base);
        this.setSystemId(systemId);
        this.setURI(uri);
    }

    public void setSystemId(String systemId) {
        CatalogMessages.reportNPEOnNull("systemId", systemId);
        this.systemId = Normalizer.normalizeURI(systemId);
    }

    public void setURI(String uri) {
        this.uri = this.verifyURI("setURI", this.baseURI, uri);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public URL getURI() {
        return this.uri;
    }

    @Override
    public String match(String systemId) {
        if (this.systemId.equals(systemId)) {
            return this.uri.toString();
        }
        return null;
    }
}

