/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.catalog;

import java.net.URL;
import javax.xml.catalog.BaseEntry;
import javax.xml.catalog.CatalogMessages;
import javax.xml.catalog.Normalizer;

final class RewriteUri
extends BaseEntry {
    String uriStartString;
    URL rewritePrefix;

    public RewriteUri(String base, String uriStartString, String rewritePrefix) {
        super(BaseEntry.CatalogEntryType.REWRITEURI, base);
        this.setURIStartString(uriStartString);
        this.setRewritePrefix(rewritePrefix);
    }

    public void setURIStartString(String uriStartString) {
        CatalogMessages.reportNPEOnNull("uriStartString", uriStartString);
        this.uriStartString = Normalizer.normalizeURI(uriStartString);
    }

    public void setRewritePrefix(String rewritePrefix) {
        this.rewritePrefix = this.verifyURI("setRewritePrefix", this.baseURI, rewritePrefix);
    }

    public String getURIStartString() {
        return this.uriStartString;
    }

    public URL getRewritePrefix() {
        return this.rewritePrefix;
    }

    @Override
    public String match(String systemId, int currentMatch) {
        if (this.uriStartString.length() < systemId.length() && this.uriStartString.equals(systemId.substring(0, this.uriStartString.length())) && currentMatch < this.uriStartString.length()) {
            String prefix = this.rewritePrefix.toExternalForm();
            String sysId = this.uriStartString.endsWith("/") ? systemId.substring(this.uriStartString.length()) : systemId.substring(this.uriStartString.length() + 1);
            if (prefix.endsWith("/")) {
                return prefix + sysId;
            }
            return prefix + "/" + sysId;
        }
        return null;
    }

    @Override
    public String match(String systemId) {
        return this.match(systemId, 0);
    }
}

